/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedMetric;
import software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedMetricsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ECSServiceRecommendedOptionProjectedMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ECSServiceRecommendedOptionProjectedMetric> {
    private static final SdkField<Integer> RECOMMENDED_CPU_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("recommendedCpuUnits").getter(ECSServiceRecommendedOptionProjectedMetric.getter(ECSServiceRecommendedOptionProjectedMetric::recommendedCpuUnits)).setter(ECSServiceRecommendedOptionProjectedMetric.setter(Builder::recommendedCpuUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedCpuUnits").build()}).build();
    private static final SdkField<Integer> RECOMMENDED_MEMORY_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("recommendedMemorySize").getter(ECSServiceRecommendedOptionProjectedMetric.getter(ECSServiceRecommendedOptionProjectedMetric::recommendedMemorySize)).setter(ECSServiceRecommendedOptionProjectedMetric.setter(Builder::recommendedMemorySize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedMemorySize").build()}).build();
    private static final SdkField<List<ECSServiceProjectedMetric>> PROJECTED_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("projectedMetrics").getter(ECSServiceRecommendedOptionProjectedMetric.getter(ECSServiceRecommendedOptionProjectedMetric::projectedMetrics)).setter(ECSServiceRecommendedOptionProjectedMetric.setter(Builder::projectedMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectedMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ECSServiceProjectedMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDED_CPU_UNITS_FIELD, RECOMMENDED_MEMORY_SIZE_FIELD, PROJECTED_METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ECSServiceRecommendedOptionProjectedMetric.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer recommendedCpuUnits;
    private final Integer recommendedMemorySize;
    private final List<ECSServiceProjectedMetric> projectedMetrics;

    private ECSServiceRecommendedOptionProjectedMetric(BuilderImpl builder) {
        this.recommendedCpuUnits = builder.recommendedCpuUnits;
        this.recommendedMemorySize = builder.recommendedMemorySize;
        this.projectedMetrics = builder.projectedMetrics;
    }

    public final Integer recommendedCpuUnits() {
        return this.recommendedCpuUnits;
    }

    public final Integer recommendedMemorySize() {
        return this.recommendedMemorySize;
    }

    public final boolean hasProjectedMetrics() {
        return this.projectedMetrics != null && !(this.projectedMetrics instanceof SdkAutoConstructList);
    }

    public final List<ECSServiceProjectedMetric> projectedMetrics() {
        return this.projectedMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedCpuUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedMemorySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectedMetrics() ? this.projectedMetrics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ECSServiceRecommendedOptionProjectedMetric)) {
            return false;
        }
        ECSServiceRecommendedOptionProjectedMetric other = (ECSServiceRecommendedOptionProjectedMetric)obj;
        return Objects.equals(this.recommendedCpuUnits(), other.recommendedCpuUnits()) && Objects.equals(this.recommendedMemorySize(), other.recommendedMemorySize()) && this.hasProjectedMetrics() == other.hasProjectedMetrics() && Objects.equals(this.projectedMetrics(), other.projectedMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"ECSServiceRecommendedOptionProjectedMetric").add("RecommendedCpuUnits", (Object)this.recommendedCpuUnits()).add("RecommendedMemorySize", (Object)this.recommendedMemorySize()).add("ProjectedMetrics", this.hasProjectedMetrics() ? this.projectedMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recommendedCpuUnits": {
                return Optional.ofNullable(clazz.cast(this.recommendedCpuUnits()));
            }
            case "recommendedMemorySize": {
                return Optional.ofNullable(clazz.cast(this.recommendedMemorySize()));
            }
            case "projectedMetrics": {
                return Optional.ofNullable(clazz.cast(this.projectedMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("recommendedCpuUnits", RECOMMENDED_CPU_UNITS_FIELD);
        map.put("recommendedMemorySize", RECOMMENDED_MEMORY_SIZE_FIELD);
        map.put("projectedMetrics", PROJECTED_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ECSServiceRecommendedOptionProjectedMetric, T> g) {
        return obj -> g.apply((ECSServiceRecommendedOptionProjectedMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer recommendedCpuUnits;
        private Integer recommendedMemorySize;
        private List<ECSServiceProjectedMetric> projectedMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ECSServiceRecommendedOptionProjectedMetric model) {
            this.recommendedCpuUnits(model.recommendedCpuUnits);
            this.recommendedMemorySize(model.recommendedMemorySize);
            this.projectedMetrics(model.projectedMetrics);
        }

        public final Integer getRecommendedCpuUnits() {
            return this.recommendedCpuUnits;
        }

        public final void setRecommendedCpuUnits(Integer recommendedCpuUnits) {
            this.recommendedCpuUnits = recommendedCpuUnits;
        }

        @Override
        public final Builder recommendedCpuUnits(Integer recommendedCpuUnits) {
            this.recommendedCpuUnits = recommendedCpuUnits;
            return this;
        }

        public final Integer getRecommendedMemorySize() {
            return this.recommendedMemorySize;
        }

        public final void setRecommendedMemorySize(Integer recommendedMemorySize) {
            this.recommendedMemorySize = recommendedMemorySize;
        }

        @Override
        public final Builder recommendedMemorySize(Integer recommendedMemorySize) {
            this.recommendedMemorySize = recommendedMemorySize;
            return this;
        }

        public final List<ECSServiceProjectedMetric.Builder> getProjectedMetrics() {
            List<ECSServiceProjectedMetric.Builder> result = ECSServiceProjectedMetricsCopier.copyToBuilder(this.projectedMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectedMetrics(Collection<ECSServiceProjectedMetric.BuilderImpl> projectedMetrics) {
            this.projectedMetrics = ECSServiceProjectedMetricsCopier.copyFromBuilder(projectedMetrics);
        }

        @Override
        public final Builder projectedMetrics(Collection<ECSServiceProjectedMetric> projectedMetrics) {
            this.projectedMetrics = ECSServiceProjectedMetricsCopier.copy(projectedMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedMetrics(ECSServiceProjectedMetric ... projectedMetrics) {
            this.projectedMetrics(Arrays.asList(projectedMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedMetrics(Consumer<ECSServiceProjectedMetric.Builder> ... projectedMetrics) {
            this.projectedMetrics(Stream.of(projectedMetrics).map(c -> (ECSServiceProjectedMetric)((ECSServiceProjectedMetric.Builder)ECSServiceProjectedMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ECSServiceRecommendedOptionProjectedMetric build() {
            return new ECSServiceRecommendedOptionProjectedMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ECSServiceRecommendedOptionProjectedMetric> {
        public Builder recommendedCpuUnits(Integer var1);

        public Builder recommendedMemorySize(Integer var1);

        public Builder projectedMetrics(Collection<ECSServiceProjectedMetric> var1);

        public Builder projectedMetrics(ECSServiceProjectedMetric ... var1);

        public Builder projectedMetrics(Consumer<ECSServiceProjectedMetric.Builder> ... var1);
    }
}

