/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.AccountIdsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerRequest;
import software.amazon.awssdk.services.computeoptimizer.model.FunctionArnsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFilter;
import software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendationFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLambdaFunctionRecommendationsRequest
extends ComputeOptimizerRequest
implements ToCopyableBuilder<Builder, GetLambdaFunctionRecommendationsRequest> {
    private static final SdkField<List<String>> FUNCTION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("functionArns").getter(GetLambdaFunctionRecommendationsRequest.getter(GetLambdaFunctionRecommendationsRequest::functionArns)).setter(GetLambdaFunctionRecommendationsRequest.setter(Builder::functionArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountIds").getter(GetLambdaFunctionRecommendationsRequest.getter(GetLambdaFunctionRecommendationsRequest::accountIds)).setter(GetLambdaFunctionRecommendationsRequest.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LambdaFunctionRecommendationFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(GetLambdaFunctionRecommendationsRequest.getter(GetLambdaFunctionRecommendationsRequest::filters)).setter(GetLambdaFunctionRecommendationsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LambdaFunctionRecommendationFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetLambdaFunctionRecommendationsRequest.getter(GetLambdaFunctionRecommendationsRequest::nextToken)).setter(GetLambdaFunctionRecommendationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetLambdaFunctionRecommendationsRequest.getter(GetLambdaFunctionRecommendationsRequest::maxResults)).setter(GetLambdaFunctionRecommendationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ARNS_FIELD, ACCOUNT_IDS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("functionArns", FUNCTION_ARNS_FIELD);
            this.put("accountIds", ACCOUNT_IDS_FIELD);
            this.put("filters", FILTERS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
        }
    });
    private final List<String> functionArns;
    private final List<String> accountIds;
    private final List<LambdaFunctionRecommendationFilter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private GetLambdaFunctionRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.functionArns = builder.functionArns;
        this.accountIds = builder.accountIds;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasFunctionArns() {
        return this.functionArns != null && !(this.functionArns instanceof SdkAutoConstructList);
    }

    public final List<String> functionArns() {
        return this.functionArns;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<LambdaFunctionRecommendationFilter> filters() {
        return this.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctionArns() ? this.functionArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLambdaFunctionRecommendationsRequest)) {
            return false;
        }
        GetLambdaFunctionRecommendationsRequest other = (GetLambdaFunctionRecommendationsRequest)((Object)obj);
        return this.hasFunctionArns() == other.hasFunctionArns() && Objects.equals(this.functionArns(), other.functionArns()) && this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetLambdaFunctionRecommendationsRequest").add("FunctionArns", this.hasFunctionArns() ? this.functionArns() : null).add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "functionArns": {
                return Optional.ofNullable(clazz.cast(this.functionArns()));
            }
            case "accountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetLambdaFunctionRecommendationsRequest, T> g) {
        return obj -> g.apply((GetLambdaFunctionRecommendationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerRequest.BuilderImpl
    implements Builder {
        private List<String> functionArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private List<LambdaFunctionRecommendationFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLambdaFunctionRecommendationsRequest model) {
            super(model);
            this.functionArns(model.functionArns);
            this.accountIds(model.accountIds);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getFunctionArns() {
            if (this.functionArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.functionArns;
        }

        public final void setFunctionArns(Collection<String> functionArns) {
            this.functionArns = FunctionArnsCopier.copy(functionArns);
        }

        @Override
        public final Builder functionArns(Collection<String> functionArns) {
            this.functionArns = FunctionArnsCopier.copy(functionArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionArns(String ... functionArns) {
            this.functionArns(Arrays.asList(functionArns));
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final List<LambdaFunctionRecommendationFilter.Builder> getFilters() {
            List<LambdaFunctionRecommendationFilter.Builder> result = LambdaFunctionRecommendationFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<LambdaFunctionRecommendationFilter.BuilderImpl> filters) {
            this.filters = LambdaFunctionRecommendationFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<LambdaFunctionRecommendationFilter> filters) {
            this.filters = LambdaFunctionRecommendationFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(LambdaFunctionRecommendationFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<LambdaFunctionRecommendationFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (LambdaFunctionRecommendationFilter)((LambdaFunctionRecommendationFilter.Builder)LambdaFunctionRecommendationFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLambdaFunctionRecommendationsRequest build() {
            return new GetLambdaFunctionRecommendationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComputeOptimizerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLambdaFunctionRecommendationsRequest> {
        public Builder functionArns(Collection<String> var1);

        public Builder functionArns(String ... var1);

        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder filters(Collection<LambdaFunctionRecommendationFilter> var1);

        public Builder filters(LambdaFunctionRecommendationFilter ... var1);

        public Builder filters(Consumer<LambdaFunctionRecommendationFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

