/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingGroupConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingGroupConfiguration> {
    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("desiredCapacity").getter(AutoScalingGroupConfiguration.getter(AutoScalingGroupConfiguration::desiredCapacity)).setter(AutoScalingGroupConfiguration.setter(Builder::desiredCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCapacity").build()}).build();
    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minSize").getter(AutoScalingGroupConfiguration.getter(AutoScalingGroupConfiguration::minSize)).setter(AutoScalingGroupConfiguration.setter(Builder::minSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minSize").build()}).build();
    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxSize").getter(AutoScalingGroupConfiguration.getter(AutoScalingGroupConfiguration::maxSize)).setter(AutoScalingGroupConfiguration.setter(Builder::maxSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSize").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(AutoScalingGroupConfiguration.getter(AutoScalingGroupConfiguration::instanceType)).setter(AutoScalingGroupConfiguration.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_CAPACITY_FIELD, MIN_SIZE_FIELD, MAX_SIZE_FIELD, INSTANCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("desiredCapacity", DESIRED_CAPACITY_FIELD);
            this.put("minSize", MIN_SIZE_FIELD);
            this.put("maxSize", MAX_SIZE_FIELD);
            this.put("instanceType", INSTANCE_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer desiredCapacity;
    private final Integer minSize;
    private final Integer maxSize;
    private final String instanceType;

    private AutoScalingGroupConfiguration(BuilderImpl builder) {
        this.desiredCapacity = builder.desiredCapacity;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.instanceType = builder.instanceType;
    }

    public final Integer desiredCapacity() {
        return this.desiredCapacity;
    }

    public final Integer minSize() {
        return this.minSize;
    }

    public final Integer maxSize() {
        return this.maxSize;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroupConfiguration)) {
            return false;
        }
        AutoScalingGroupConfiguration other = (AutoScalingGroupConfiguration)obj;
        return Objects.equals(this.desiredCapacity(), other.desiredCapacity()) && Objects.equals(this.minSize(), other.minSize()) && Objects.equals(this.maxSize(), other.maxSize()) && Objects.equals(this.instanceType(), other.instanceType());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingGroupConfiguration").add("DesiredCapacity", (Object)this.desiredCapacity()).add("MinSize", (Object)this.minSize()).add("MaxSize", (Object)this.maxSize()).add("InstanceType", (Object)this.instanceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "desiredCapacity": {
                return Optional.ofNullable(clazz.cast(this.desiredCapacity()));
            }
            case "minSize": {
                return Optional.ofNullable(clazz.cast(this.minSize()));
            }
            case "maxSize": {
                return Optional.ofNullable(clazz.cast(this.maxSize()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroupConfiguration, T> g) {
        return obj -> g.apply((AutoScalingGroupConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer desiredCapacity;
        private Integer minSize;
        private Integer maxSize;
        private String instanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroupConfiguration model) {
            this.desiredCapacity(model.desiredCapacity);
            this.minSize(model.minSize);
            this.maxSize(model.maxSize);
            this.instanceType(model.instanceType);
        }

        public final Integer getDesiredCapacity() {
            return this.desiredCapacity;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final Integer getMinSize() {
            return this.minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final Integer getMaxSize() {
            return this.maxSize;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public AutoScalingGroupConfiguration build() {
            return new AutoScalingGroupConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingGroupConfiguration> {
        public Builder desiredCapacity(Integer var1);

        public Builder minSize(Integer var1);

        public Builder maxSize(Integer var1);

        public Builder instanceType(String var1);
    }
}

