/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.AccountIdsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportableIdleField;
import software.amazon.awssdk.services.computeoptimizer.model.ExportableIdleFieldsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.FileFormat;
import software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendationFilter;
import software.amazon.awssdk.services.computeoptimizer.model.IdleRecommendationFiltersCopier;
import software.amazon.awssdk.services.computeoptimizer.model.S3DestinationConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportIdleRecommendationsRequest
extends ComputeOptimizerRequest
implements ToCopyableBuilder<Builder, ExportIdleRecommendationsRequest> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountIds").getter(ExportIdleRecommendationsRequest.getter(ExportIdleRecommendationsRequest::accountIds)).setter(ExportIdleRecommendationsRequest.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<IdleRecommendationFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(ExportIdleRecommendationsRequest.getter(ExportIdleRecommendationsRequest::filters)).setter(ExportIdleRecommendationsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdleRecommendationFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FIELDS_TO_EXPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fieldsToExport").getter(ExportIdleRecommendationsRequest.getter(ExportIdleRecommendationsRequest::fieldsToExportAsStrings)).setter(ExportIdleRecommendationsRequest.setter(Builder::fieldsToExportWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldsToExport").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<S3DestinationConfig> S3_DESTINATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3DestinationConfig").getter(ExportIdleRecommendationsRequest.getter(ExportIdleRecommendationsRequest::s3DestinationConfig)).setter(ExportIdleRecommendationsRequest.setter(Builder::s3DestinationConfig)).constructor(S3DestinationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DestinationConfig").build()}).build();
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileFormat").getter(ExportIdleRecommendationsRequest.getter(ExportIdleRecommendationsRequest::fileFormatAsString)).setter(ExportIdleRecommendationsRequest.setter(Builder::fileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()}).build();
    private static final SdkField<Boolean> INCLUDE_MEMBER_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeMemberAccounts").getter(ExportIdleRecommendationsRequest.getter(ExportIdleRecommendationsRequest::includeMemberAccounts)).setter(ExportIdleRecommendationsRequest.setter(Builder::includeMemberAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeMemberAccounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD, FILTERS_FIELD, FIELDS_TO_EXPORT_FIELD, S3_DESTINATION_CONFIG_FIELD, FILE_FORMAT_FIELD, INCLUDE_MEMBER_ACCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accountIds", ACCOUNT_IDS_FIELD);
            this.put("filters", FILTERS_FIELD);
            this.put("fieldsToExport", FIELDS_TO_EXPORT_FIELD);
            this.put("s3DestinationConfig", S3_DESTINATION_CONFIG_FIELD);
            this.put("fileFormat", FILE_FORMAT_FIELD);
            this.put("includeMemberAccounts", INCLUDE_MEMBER_ACCOUNTS_FIELD);
        }
    });
    private final List<String> accountIds;
    private final List<IdleRecommendationFilter> filters;
    private final List<String> fieldsToExport;
    private final S3DestinationConfig s3DestinationConfig;
    private final String fileFormat;
    private final Boolean includeMemberAccounts;

    private ExportIdleRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.filters = builder.filters;
        this.fieldsToExport = builder.fieldsToExport;
        this.s3DestinationConfig = builder.s3DestinationConfig;
        this.fileFormat = builder.fileFormat;
        this.includeMemberAccounts = builder.includeMemberAccounts;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<IdleRecommendationFilter> filters() {
        return this.filters;
    }

    public final List<ExportableIdleField> fieldsToExport() {
        return ExportableIdleFieldsCopier.copyStringToEnum(this.fieldsToExport);
    }

    public final boolean hasFieldsToExport() {
        return this.fieldsToExport != null && !(this.fieldsToExport instanceof SdkAutoConstructList);
    }

    public final List<String> fieldsToExportAsStrings() {
        return this.fieldsToExport;
    }

    public final S3DestinationConfig s3DestinationConfig() {
        return this.s3DestinationConfig;
    }

    public final FileFormat fileFormat() {
        return FileFormat.fromValue(this.fileFormat);
    }

    public final String fileFormatAsString() {
        return this.fileFormat;
    }

    public final Boolean includeMemberAccounts() {
        return this.includeMemberAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldsToExport() ? this.fieldsToExportAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DestinationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeMemberAccounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportIdleRecommendationsRequest)) {
            return false;
        }
        ExportIdleRecommendationsRequest other = (ExportIdleRecommendationsRequest)((Object)obj);
        return this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && this.hasFieldsToExport() == other.hasFieldsToExport() && Objects.equals(this.fieldsToExportAsStrings(), other.fieldsToExportAsStrings()) && Objects.equals(this.s3DestinationConfig(), other.s3DestinationConfig()) && Objects.equals(this.fileFormatAsString(), other.fileFormatAsString()) && Objects.equals(this.includeMemberAccounts(), other.includeMemberAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"ExportIdleRecommendationsRequest").add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("FieldsToExport", this.hasFieldsToExport() ? this.fieldsToExportAsStrings() : null).add("S3DestinationConfig", (Object)this.s3DestinationConfig()).add("FileFormat", (Object)this.fileFormatAsString()).add("IncludeMemberAccounts", (Object)this.includeMemberAccounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "fieldsToExport": {
                return Optional.ofNullable(clazz.cast(this.fieldsToExportAsStrings()));
            }
            case "s3DestinationConfig": {
                return Optional.ofNullable(clazz.cast(this.s3DestinationConfig()));
            }
            case "fileFormat": {
                return Optional.ofNullable(clazz.cast(this.fileFormatAsString()));
            }
            case "includeMemberAccounts": {
                return Optional.ofNullable(clazz.cast(this.includeMemberAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExportIdleRecommendationsRequest, T> g) {
        return obj -> g.apply((ExportIdleRecommendationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerRequest.BuilderImpl
    implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private List<IdleRecommendationFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<String> fieldsToExport = DefaultSdkAutoConstructList.getInstance();
        private S3DestinationConfig s3DestinationConfig;
        private String fileFormat;
        private Boolean includeMemberAccounts;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportIdleRecommendationsRequest model) {
            super(model);
            this.accountIds(model.accountIds);
            this.filters(model.filters);
            this.fieldsToExportWithStrings(model.fieldsToExport);
            this.s3DestinationConfig(model.s3DestinationConfig);
            this.fileFormat(model.fileFormat);
            this.includeMemberAccounts(model.includeMemberAccounts);
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final List<IdleRecommendationFilter.Builder> getFilters() {
            List<IdleRecommendationFilter.Builder> result = IdleRecommendationFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<IdleRecommendationFilter.BuilderImpl> filters) {
            this.filters = IdleRecommendationFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<IdleRecommendationFilter> filters) {
            this.filters = IdleRecommendationFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(IdleRecommendationFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<IdleRecommendationFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (IdleRecommendationFilter)((IdleRecommendationFilter.Builder)IdleRecommendationFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getFieldsToExport() {
            if (this.fieldsToExport instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fieldsToExport;
        }

        public final void setFieldsToExport(Collection<String> fieldsToExport) {
            this.fieldsToExport = ExportableIdleFieldsCopier.copy(fieldsToExport);
        }

        @Override
        public final Builder fieldsToExportWithStrings(Collection<String> fieldsToExport) {
            this.fieldsToExport = ExportableIdleFieldsCopier.copy(fieldsToExport);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldsToExportWithStrings(String ... fieldsToExport) {
            this.fieldsToExportWithStrings(Arrays.asList(fieldsToExport));
            return this;
        }

        @Override
        public final Builder fieldsToExport(Collection<ExportableIdleField> fieldsToExport) {
            this.fieldsToExport = ExportableIdleFieldsCopier.copyEnumToString(fieldsToExport);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldsToExport(ExportableIdleField ... fieldsToExport) {
            this.fieldsToExport(Arrays.asList(fieldsToExport));
            return this;
        }

        public final S3DestinationConfig.Builder getS3DestinationConfig() {
            return this.s3DestinationConfig != null ? this.s3DestinationConfig.toBuilder() : null;
        }

        public final void setS3DestinationConfig(S3DestinationConfig.BuilderImpl s3DestinationConfig) {
            this.s3DestinationConfig = s3DestinationConfig != null ? s3DestinationConfig.build() : null;
        }

        @Override
        public final Builder s3DestinationConfig(S3DestinationConfig s3DestinationConfig) {
            this.s3DestinationConfig = s3DestinationConfig;
            return this;
        }

        public final String getFileFormat() {
            return this.fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(FileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final Boolean getIncludeMemberAccounts() {
            return this.includeMemberAccounts;
        }

        public final void setIncludeMemberAccounts(Boolean includeMemberAccounts) {
            this.includeMemberAccounts = includeMemberAccounts;
        }

        @Override
        public final Builder includeMemberAccounts(Boolean includeMemberAccounts) {
            this.includeMemberAccounts = includeMemberAccounts;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportIdleRecommendationsRequest build() {
            return new ExportIdleRecommendationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComputeOptimizerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportIdleRecommendationsRequest> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder filters(Collection<IdleRecommendationFilter> var1);

        public Builder filters(IdleRecommendationFilter ... var1);

        public Builder filters(Consumer<IdleRecommendationFilter.Builder> ... var1);

        public Builder fieldsToExportWithStrings(Collection<String> var1);

        public Builder fieldsToExportWithStrings(String ... var1);

        public Builder fieldsToExport(Collection<ExportableIdleField> var1);

        public Builder fieldsToExport(ExportableIdleField ... var1);

        public Builder s3DestinationConfig(S3DestinationConfig var1);

        default public Builder s3DestinationConfig(Consumer<S3DestinationConfig.Builder> s3DestinationConfig) {
            return this.s3DestinationConfig((S3DestinationConfig)((S3DestinationConfig.Builder)S3DestinationConfig.builder().applyMutation(s3DestinationConfig)).build());
        }

        public Builder fileFormat(String var1);

        public Builder fileFormat(FileFormat var1);

        public Builder includeMemberAccounts(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

