/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupConfiguration;
import software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendationOption;
import software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendationOptionsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk;
import software.amazon.awssdk.services.computeoptimizer.model.EffectiveRecommendationPreferences;
import software.amazon.awssdk.services.computeoptimizer.model.Finding;
import software.amazon.awssdk.services.computeoptimizer.model.GpuInfo;
import software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType;
import software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadTypesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetric;
import software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetricsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingGroupRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingGroupRecommendation> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::accountId)).setter(AutoScalingGroupRecommendation.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoScalingGroupArn").getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::autoScalingGroupArn)).setter(AutoScalingGroupRecommendation.setter(Builder::autoScalingGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupArn").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoScalingGroupName").getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::autoScalingGroupName)).setter(AutoScalingGroupRecommendation.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupName").build()}).build();
    private static final SdkField<String> FINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("finding").getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::findingAsString)).setter(AutoScalingGroupRecommendation.setter(Builder::finding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finding").build()}).build();
    private static final SdkField<List<UtilizationMetric>> UTILIZATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("utilizationMetrics").getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::utilizationMetrics)).setter(AutoScalingGroupRecommendation.setter(Builder::utilizationMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utilizationMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UtilizationMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> LOOK_BACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("lookBackPeriodInDays").getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::lookBackPeriodInDays)).setter(AutoScalingGroupRecommendation.setter(Builder::lookBackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookBackPeriodInDays").build()}).build();
    private static final SdkField<AutoScalingGroupConfiguration> CURRENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentConfiguration").getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::currentConfiguration)).setter(AutoScalingGroupRecommendation.setter(Builder::currentConfiguration)).constructor(AutoScalingGroupConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentConfiguration").build()}).build();
    private static final SdkField<GpuInfo> CURRENT_INSTANCE_GPU_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentInstanceGpuInfo").getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::currentInstanceGpuInfo)).setter(AutoScalingGroupRecommendation.setter(Builder::currentInstanceGpuInfo)).constructor(GpuInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentInstanceGpuInfo").build()}).build();
    private static final SdkField<List<AutoScalingGroupRecommendationOption>> RECOMMENDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendationOptions").getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::recommendationOptions)).setter(AutoScalingGroupRecommendation.setter(Builder::recommendationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoScalingGroupRecommendationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_REFRESH_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastRefreshTimestamp").getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::lastRefreshTimestamp)).setter(AutoScalingGroupRecommendation.setter(Builder::lastRefreshTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRefreshTimestamp").build()}).build();
    private static final SdkField<String> CURRENT_PERFORMANCE_RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentPerformanceRisk").getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::currentPerformanceRiskAsString)).setter(AutoScalingGroupRecommendation.setter(Builder::currentPerformanceRisk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPerformanceRisk").build()}).build();
    private static final SdkField<EffectiveRecommendationPreferences> EFFECTIVE_RECOMMENDATION_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("effectiveRecommendationPreferences").getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::effectiveRecommendationPreferences)).setter(AutoScalingGroupRecommendation.setter(Builder::effectiveRecommendationPreferences)).constructor(EffectiveRecommendationPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveRecommendationPreferences").build()}).build();
    private static final SdkField<List<String>> INFERRED_WORKLOAD_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inferredWorkloadTypes").getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::inferredWorkloadTypesAsStrings)).setter(AutoScalingGroupRecommendation.setter(Builder::inferredWorkloadTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferredWorkloadTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, AUTO_SCALING_GROUP_ARN_FIELD, AUTO_SCALING_GROUP_NAME_FIELD, FINDING_FIELD, UTILIZATION_METRICS_FIELD, LOOK_BACK_PERIOD_IN_DAYS_FIELD, CURRENT_CONFIGURATION_FIELD, CURRENT_INSTANCE_GPU_INFO_FIELD, RECOMMENDATION_OPTIONS_FIELD, LAST_REFRESH_TIMESTAMP_FIELD, CURRENT_PERFORMANCE_RISK_FIELD, EFFECTIVE_RECOMMENDATION_PREFERENCES_FIELD, INFERRED_WORKLOAD_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accountId", ACCOUNT_ID_FIELD);
            this.put("autoScalingGroupArn", AUTO_SCALING_GROUP_ARN_FIELD);
            this.put("autoScalingGroupName", AUTO_SCALING_GROUP_NAME_FIELD);
            this.put("finding", FINDING_FIELD);
            this.put("utilizationMetrics", UTILIZATION_METRICS_FIELD);
            this.put("lookBackPeriodInDays", LOOK_BACK_PERIOD_IN_DAYS_FIELD);
            this.put("currentConfiguration", CURRENT_CONFIGURATION_FIELD);
            this.put("currentInstanceGpuInfo", CURRENT_INSTANCE_GPU_INFO_FIELD);
            this.put("recommendationOptions", RECOMMENDATION_OPTIONS_FIELD);
            this.put("lastRefreshTimestamp", LAST_REFRESH_TIMESTAMP_FIELD);
            this.put("currentPerformanceRisk", CURRENT_PERFORMANCE_RISK_FIELD);
            this.put("effectiveRecommendationPreferences", EFFECTIVE_RECOMMENDATION_PREFERENCES_FIELD);
            this.put("inferredWorkloadTypes", INFERRED_WORKLOAD_TYPES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String autoScalingGroupArn;
    private final String autoScalingGroupName;
    private final String finding;
    private final List<UtilizationMetric> utilizationMetrics;
    private final Double lookBackPeriodInDays;
    private final AutoScalingGroupConfiguration currentConfiguration;
    private final GpuInfo currentInstanceGpuInfo;
    private final List<AutoScalingGroupRecommendationOption> recommendationOptions;
    private final Instant lastRefreshTimestamp;
    private final String currentPerformanceRisk;
    private final EffectiveRecommendationPreferences effectiveRecommendationPreferences;
    private final List<String> inferredWorkloadTypes;

    private AutoScalingGroupRecommendation(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.autoScalingGroupArn = builder.autoScalingGroupArn;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.finding = builder.finding;
        this.utilizationMetrics = builder.utilizationMetrics;
        this.lookBackPeriodInDays = builder.lookBackPeriodInDays;
        this.currentConfiguration = builder.currentConfiguration;
        this.currentInstanceGpuInfo = builder.currentInstanceGpuInfo;
        this.recommendationOptions = builder.recommendationOptions;
        this.lastRefreshTimestamp = builder.lastRefreshTimestamp;
        this.currentPerformanceRisk = builder.currentPerformanceRisk;
        this.effectiveRecommendationPreferences = builder.effectiveRecommendationPreferences;
        this.inferredWorkloadTypes = builder.inferredWorkloadTypes;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String autoScalingGroupArn() {
        return this.autoScalingGroupArn;
    }

    public final String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public final Finding finding() {
        return Finding.fromValue(this.finding);
    }

    public final String findingAsString() {
        return this.finding;
    }

    public final boolean hasUtilizationMetrics() {
        return this.utilizationMetrics != null && !(this.utilizationMetrics instanceof SdkAutoConstructList);
    }

    public final List<UtilizationMetric> utilizationMetrics() {
        return this.utilizationMetrics;
    }

    public final Double lookBackPeriodInDays() {
        return this.lookBackPeriodInDays;
    }

    public final AutoScalingGroupConfiguration currentConfiguration() {
        return this.currentConfiguration;
    }

    public final GpuInfo currentInstanceGpuInfo() {
        return this.currentInstanceGpuInfo;
    }

    public final boolean hasRecommendationOptions() {
        return this.recommendationOptions != null && !(this.recommendationOptions instanceof SdkAutoConstructList);
    }

    public final List<AutoScalingGroupRecommendationOption> recommendationOptions() {
        return this.recommendationOptions;
    }

    public final Instant lastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public final CurrentPerformanceRisk currentPerformanceRisk() {
        return CurrentPerformanceRisk.fromValue(this.currentPerformanceRisk);
    }

    public final String currentPerformanceRiskAsString() {
        return this.currentPerformanceRisk;
    }

    public final EffectiveRecommendationPreferences effectiveRecommendationPreferences() {
        return this.effectiveRecommendationPreferences;
    }

    public final List<InferredWorkloadType> inferredWorkloadTypes() {
        return InferredWorkloadTypesCopier.copyStringToEnum(this.inferredWorkloadTypes);
    }

    public final boolean hasInferredWorkloadTypes() {
        return this.inferredWorkloadTypes != null && !(this.inferredWorkloadTypes instanceof SdkAutoConstructList);
    }

    public final List<String> inferredWorkloadTypesAsStrings() {
        return this.inferredWorkloadTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUtilizationMetrics() ? this.utilizationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lookBackPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentInstanceGpuInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationOptions() ? this.recommendationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRefreshTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPerformanceRiskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveRecommendationPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInferredWorkloadTypes() ? this.inferredWorkloadTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroupRecommendation)) {
            return false;
        }
        AutoScalingGroupRecommendation other = (AutoScalingGroupRecommendation)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.autoScalingGroupArn(), other.autoScalingGroupArn()) && Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.findingAsString(), other.findingAsString()) && this.hasUtilizationMetrics() == other.hasUtilizationMetrics() && Objects.equals(this.utilizationMetrics(), other.utilizationMetrics()) && Objects.equals(this.lookBackPeriodInDays(), other.lookBackPeriodInDays()) && Objects.equals(this.currentConfiguration(), other.currentConfiguration()) && Objects.equals(this.currentInstanceGpuInfo(), other.currentInstanceGpuInfo()) && this.hasRecommendationOptions() == other.hasRecommendationOptions() && Objects.equals(this.recommendationOptions(), other.recommendationOptions()) && Objects.equals(this.lastRefreshTimestamp(), other.lastRefreshTimestamp()) && Objects.equals(this.currentPerformanceRiskAsString(), other.currentPerformanceRiskAsString()) && Objects.equals(this.effectiveRecommendationPreferences(), other.effectiveRecommendationPreferences()) && this.hasInferredWorkloadTypes() == other.hasInferredWorkloadTypes() && Objects.equals(this.inferredWorkloadTypesAsStrings(), other.inferredWorkloadTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingGroupRecommendation").add("AccountId", (Object)this.accountId()).add("AutoScalingGroupArn", (Object)this.autoScalingGroupArn()).add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("Finding", (Object)this.findingAsString()).add("UtilizationMetrics", this.hasUtilizationMetrics() ? this.utilizationMetrics() : null).add("LookBackPeriodInDays", (Object)this.lookBackPeriodInDays()).add("CurrentConfiguration", (Object)this.currentConfiguration()).add("CurrentInstanceGpuInfo", (Object)this.currentInstanceGpuInfo()).add("RecommendationOptions", this.hasRecommendationOptions() ? this.recommendationOptions() : null).add("LastRefreshTimestamp", (Object)this.lastRefreshTimestamp()).add("CurrentPerformanceRisk", (Object)this.currentPerformanceRiskAsString()).add("EffectiveRecommendationPreferences", (Object)this.effectiveRecommendationPreferences()).add("InferredWorkloadTypes", this.hasInferredWorkloadTypes() ? this.inferredWorkloadTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "autoScalingGroupArn": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupArn()));
            }
            case "autoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "finding": {
                return Optional.ofNullable(clazz.cast(this.findingAsString()));
            }
            case "utilizationMetrics": {
                return Optional.ofNullable(clazz.cast(this.utilizationMetrics()));
            }
            case "lookBackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookBackPeriodInDays()));
            }
            case "currentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.currentConfiguration()));
            }
            case "currentInstanceGpuInfo": {
                return Optional.ofNullable(clazz.cast(this.currentInstanceGpuInfo()));
            }
            case "recommendationOptions": {
                return Optional.ofNullable(clazz.cast(this.recommendationOptions()));
            }
            case "lastRefreshTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastRefreshTimestamp()));
            }
            case "currentPerformanceRisk": {
                return Optional.ofNullable(clazz.cast(this.currentPerformanceRiskAsString()));
            }
            case "effectiveRecommendationPreferences": {
                return Optional.ofNullable(clazz.cast(this.effectiveRecommendationPreferences()));
            }
            case "inferredWorkloadTypes": {
                return Optional.ofNullable(clazz.cast(this.inferredWorkloadTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroupRecommendation, T> g) {
        return obj -> g.apply((AutoScalingGroupRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String autoScalingGroupArn;
        private String autoScalingGroupName;
        private String finding;
        private List<UtilizationMetric> utilizationMetrics = DefaultSdkAutoConstructList.getInstance();
        private Double lookBackPeriodInDays;
        private AutoScalingGroupConfiguration currentConfiguration;
        private GpuInfo currentInstanceGpuInfo;
        private List<AutoScalingGroupRecommendationOption> recommendationOptions = DefaultSdkAutoConstructList.getInstance();
        private Instant lastRefreshTimestamp;
        private String currentPerformanceRisk;
        private EffectiveRecommendationPreferences effectiveRecommendationPreferences;
        private List<String> inferredWorkloadTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroupRecommendation model) {
            this.accountId(model.accountId);
            this.autoScalingGroupArn(model.autoScalingGroupArn);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.finding(model.finding);
            this.utilizationMetrics(model.utilizationMetrics);
            this.lookBackPeriodInDays(model.lookBackPeriodInDays);
            this.currentConfiguration(model.currentConfiguration);
            this.currentInstanceGpuInfo(model.currentInstanceGpuInfo);
            this.recommendationOptions(model.recommendationOptions);
            this.lastRefreshTimestamp(model.lastRefreshTimestamp);
            this.currentPerformanceRisk(model.currentPerformanceRisk);
            this.effectiveRecommendationPreferences(model.effectiveRecommendationPreferences);
            this.inferredWorkloadTypesWithStrings(model.inferredWorkloadTypes);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAutoScalingGroupArn() {
            return this.autoScalingGroupArn;
        }

        public final void setAutoScalingGroupArn(String autoScalingGroupArn) {
            this.autoScalingGroupArn = autoScalingGroupArn;
        }

        @Override
        public final Builder autoScalingGroupArn(String autoScalingGroupArn) {
            this.autoScalingGroupArn = autoScalingGroupArn;
            return this;
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getFinding() {
            return this.finding;
        }

        public final void setFinding(String finding) {
            this.finding = finding;
        }

        @Override
        public final Builder finding(String finding) {
            this.finding = finding;
            return this;
        }

        @Override
        public final Builder finding(Finding finding) {
            this.finding(finding == null ? null : finding.toString());
            return this;
        }

        public final List<UtilizationMetric.Builder> getUtilizationMetrics() {
            List<UtilizationMetric.Builder> result = UtilizationMetricsCopier.copyToBuilder(this.utilizationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUtilizationMetrics(Collection<UtilizationMetric.BuilderImpl> utilizationMetrics) {
            this.utilizationMetrics = UtilizationMetricsCopier.copyFromBuilder(utilizationMetrics);
        }

        @Override
        public final Builder utilizationMetrics(Collection<UtilizationMetric> utilizationMetrics) {
            this.utilizationMetrics = UtilizationMetricsCopier.copy(utilizationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(UtilizationMetric ... utilizationMetrics) {
            this.utilizationMetrics(Arrays.asList(utilizationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(Consumer<UtilizationMetric.Builder> ... utilizationMetrics) {
            this.utilizationMetrics(Stream.of(utilizationMetrics).map(c -> (UtilizationMetric)((UtilizationMetric.Builder)UtilizationMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getLookBackPeriodInDays() {
            return this.lookBackPeriodInDays;
        }

        public final void setLookBackPeriodInDays(Double lookBackPeriodInDays) {
            this.lookBackPeriodInDays = lookBackPeriodInDays;
        }

        @Override
        public final Builder lookBackPeriodInDays(Double lookBackPeriodInDays) {
            this.lookBackPeriodInDays = lookBackPeriodInDays;
            return this;
        }

        public final AutoScalingGroupConfiguration.Builder getCurrentConfiguration() {
            return this.currentConfiguration != null ? this.currentConfiguration.toBuilder() : null;
        }

        public final void setCurrentConfiguration(AutoScalingGroupConfiguration.BuilderImpl currentConfiguration) {
            this.currentConfiguration = currentConfiguration != null ? currentConfiguration.build() : null;
        }

        @Override
        public final Builder currentConfiguration(AutoScalingGroupConfiguration currentConfiguration) {
            this.currentConfiguration = currentConfiguration;
            return this;
        }

        public final GpuInfo.Builder getCurrentInstanceGpuInfo() {
            return this.currentInstanceGpuInfo != null ? this.currentInstanceGpuInfo.toBuilder() : null;
        }

        public final void setCurrentInstanceGpuInfo(GpuInfo.BuilderImpl currentInstanceGpuInfo) {
            this.currentInstanceGpuInfo = currentInstanceGpuInfo != null ? currentInstanceGpuInfo.build() : null;
        }

        @Override
        public final Builder currentInstanceGpuInfo(GpuInfo currentInstanceGpuInfo) {
            this.currentInstanceGpuInfo = currentInstanceGpuInfo;
            return this;
        }

        public final List<AutoScalingGroupRecommendationOption.Builder> getRecommendationOptions() {
            List<AutoScalingGroupRecommendationOption.Builder> result = AutoScalingGroupRecommendationOptionsCopier.copyToBuilder(this.recommendationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendationOptions(Collection<AutoScalingGroupRecommendationOption.BuilderImpl> recommendationOptions) {
            this.recommendationOptions = AutoScalingGroupRecommendationOptionsCopier.copyFromBuilder(recommendationOptions);
        }

        @Override
        public final Builder recommendationOptions(Collection<AutoScalingGroupRecommendationOption> recommendationOptions) {
            this.recommendationOptions = AutoScalingGroupRecommendationOptionsCopier.copy(recommendationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationOptions(AutoScalingGroupRecommendationOption ... recommendationOptions) {
            this.recommendationOptions(Arrays.asList(recommendationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationOptions(Consumer<AutoScalingGroupRecommendationOption.Builder> ... recommendationOptions) {
            this.recommendationOptions(Stream.of(recommendationOptions).map(c -> (AutoScalingGroupRecommendationOption)((AutoScalingGroupRecommendationOption.Builder)AutoScalingGroupRecommendationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastRefreshTimestamp() {
            return this.lastRefreshTimestamp;
        }

        public final void setLastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
        }

        @Override
        public final Builder lastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
            return this;
        }

        public final String getCurrentPerformanceRisk() {
            return this.currentPerformanceRisk;
        }

        public final void setCurrentPerformanceRisk(String currentPerformanceRisk) {
            this.currentPerformanceRisk = currentPerformanceRisk;
        }

        @Override
        public final Builder currentPerformanceRisk(String currentPerformanceRisk) {
            this.currentPerformanceRisk = currentPerformanceRisk;
            return this;
        }

        @Override
        public final Builder currentPerformanceRisk(CurrentPerformanceRisk currentPerformanceRisk) {
            this.currentPerformanceRisk(currentPerformanceRisk == null ? null : currentPerformanceRisk.toString());
            return this;
        }

        public final EffectiveRecommendationPreferences.Builder getEffectiveRecommendationPreferences() {
            return this.effectiveRecommendationPreferences != null ? this.effectiveRecommendationPreferences.toBuilder() : null;
        }

        public final void setEffectiveRecommendationPreferences(EffectiveRecommendationPreferences.BuilderImpl effectiveRecommendationPreferences) {
            this.effectiveRecommendationPreferences = effectiveRecommendationPreferences != null ? effectiveRecommendationPreferences.build() : null;
        }

        @Override
        public final Builder effectiveRecommendationPreferences(EffectiveRecommendationPreferences effectiveRecommendationPreferences) {
            this.effectiveRecommendationPreferences = effectiveRecommendationPreferences;
            return this;
        }

        public final Collection<String> getInferredWorkloadTypes() {
            if (this.inferredWorkloadTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inferredWorkloadTypes;
        }

        public final void setInferredWorkloadTypes(Collection<String> inferredWorkloadTypes) {
            this.inferredWorkloadTypes = InferredWorkloadTypesCopier.copy(inferredWorkloadTypes);
        }

        @Override
        public final Builder inferredWorkloadTypesWithStrings(Collection<String> inferredWorkloadTypes) {
            this.inferredWorkloadTypes = InferredWorkloadTypesCopier.copy(inferredWorkloadTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferredWorkloadTypesWithStrings(String ... inferredWorkloadTypes) {
            this.inferredWorkloadTypesWithStrings(Arrays.asList(inferredWorkloadTypes));
            return this;
        }

        @Override
        public final Builder inferredWorkloadTypes(Collection<InferredWorkloadType> inferredWorkloadTypes) {
            this.inferredWorkloadTypes = InferredWorkloadTypesCopier.copyEnumToString(inferredWorkloadTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferredWorkloadTypes(InferredWorkloadType ... inferredWorkloadTypes) {
            this.inferredWorkloadTypes(Arrays.asList(inferredWorkloadTypes));
            return this;
        }

        public AutoScalingGroupRecommendation build() {
            return new AutoScalingGroupRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingGroupRecommendation> {
        public Builder accountId(String var1);

        public Builder autoScalingGroupArn(String var1);

        public Builder autoScalingGroupName(String var1);

        public Builder finding(String var1);

        public Builder finding(Finding var1);

        public Builder utilizationMetrics(Collection<UtilizationMetric> var1);

        public Builder utilizationMetrics(UtilizationMetric ... var1);

        public Builder utilizationMetrics(Consumer<UtilizationMetric.Builder> ... var1);

        public Builder lookBackPeriodInDays(Double var1);

        public Builder currentConfiguration(AutoScalingGroupConfiguration var1);

        default public Builder currentConfiguration(Consumer<AutoScalingGroupConfiguration.Builder> currentConfiguration) {
            return this.currentConfiguration((AutoScalingGroupConfiguration)((AutoScalingGroupConfiguration.Builder)AutoScalingGroupConfiguration.builder().applyMutation(currentConfiguration)).build());
        }

        public Builder currentInstanceGpuInfo(GpuInfo var1);

        default public Builder currentInstanceGpuInfo(Consumer<GpuInfo.Builder> currentInstanceGpuInfo) {
            return this.currentInstanceGpuInfo((GpuInfo)((GpuInfo.Builder)GpuInfo.builder().applyMutation(currentInstanceGpuInfo)).build());
        }

        public Builder recommendationOptions(Collection<AutoScalingGroupRecommendationOption> var1);

        public Builder recommendationOptions(AutoScalingGroupRecommendationOption ... var1);

        public Builder recommendationOptions(Consumer<AutoScalingGroupRecommendationOption.Builder> ... var1);

        public Builder lastRefreshTimestamp(Instant var1);

        public Builder currentPerformanceRisk(String var1);

        public Builder currentPerformanceRisk(CurrentPerformanceRisk var1);

        public Builder effectiveRecommendationPreferences(EffectiveRecommendationPreferences var1);

        default public Builder effectiveRecommendationPreferences(Consumer<EffectiveRecommendationPreferences.Builder> effectiveRecommendationPreferences) {
            return this.effectiveRecommendationPreferences((EffectiveRecommendationPreferences)((EffectiveRecommendationPreferences.Builder)EffectiveRecommendationPreferences.builder().applyMutation(effectiveRecommendationPreferences)).build());
        }

        public Builder inferredWorkloadTypesWithStrings(Collection<String> var1);

        public Builder inferredWorkloadTypesWithStrings(String ... var1);

        public Builder inferredWorkloadTypes(Collection<InferredWorkloadType> var1);

        public Builder inferredWorkloadTypes(InferredWorkloadType ... var1);
    }
}

