/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.CpuVendorArchitecture;
import software.amazon.awssdk.services.computeoptimizer.model.CpuVendorArchitecturesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.EffectivePreferredResource;
import software.amazon.awssdk.services.computeoptimizer.model.EffectivePreferredResourcesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.EnhancedInfrastructureMetrics;
import software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricsPreference;
import software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadTypesPreference;
import software.amazon.awssdk.services.computeoptimizer.model.InstanceSavingsEstimationMode;
import software.amazon.awssdk.services.computeoptimizer.model.LookBackPeriodPreference;
import software.amazon.awssdk.services.computeoptimizer.model.UtilizationPreference;
import software.amazon.awssdk.services.computeoptimizer.model.UtilizationPreferencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EffectiveRecommendationPreferences
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EffectiveRecommendationPreferences> {
    private static final SdkField<List<String>> CPU_VENDOR_ARCHITECTURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cpuVendorArchitectures").getter(EffectiveRecommendationPreferences.getter(EffectiveRecommendationPreferences::cpuVendorArchitecturesAsStrings)).setter(EffectiveRecommendationPreferences.setter(Builder::cpuVendorArchitecturesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuVendorArchitectures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENHANCED_INFRASTRUCTURE_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("enhancedInfrastructureMetrics").getter(EffectiveRecommendationPreferences.getter(EffectiveRecommendationPreferences::enhancedInfrastructureMetricsAsString)).setter(EffectiveRecommendationPreferences.setter(Builder::enhancedInfrastructureMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedInfrastructureMetrics").build()}).build();
    private static final SdkField<String> INFERRED_WORKLOAD_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inferredWorkloadTypes").getter(EffectiveRecommendationPreferences.getter(EffectiveRecommendationPreferences::inferredWorkloadTypesAsString)).setter(EffectiveRecommendationPreferences.setter(Builder::inferredWorkloadTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferredWorkloadTypes").build()}).build();
    private static final SdkField<ExternalMetricsPreference> EXTERNAL_METRICS_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("externalMetricsPreference").getter(EffectiveRecommendationPreferences.getter(EffectiveRecommendationPreferences::externalMetricsPreference)).setter(EffectiveRecommendationPreferences.setter(Builder::externalMetricsPreference)).constructor(ExternalMetricsPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalMetricsPreference").build()}).build();
    private static final SdkField<String> LOOK_BACK_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lookBackPeriod").getter(EffectiveRecommendationPreferences.getter(EffectiveRecommendationPreferences::lookBackPeriodAsString)).setter(EffectiveRecommendationPreferences.setter(Builder::lookBackPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookBackPeriod").build()}).build();
    private static final SdkField<List<UtilizationPreference>> UTILIZATION_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("utilizationPreferences").getter(EffectiveRecommendationPreferences.getter(EffectiveRecommendationPreferences::utilizationPreferences)).setter(EffectiveRecommendationPreferences.setter(Builder::utilizationPreferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utilizationPreferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UtilizationPreference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EffectivePreferredResource>> PREFERRED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("preferredResources").getter(EffectiveRecommendationPreferences.getter(EffectiveRecommendationPreferences::preferredResources)).setter(EffectiveRecommendationPreferences.setter(Builder::preferredResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EffectivePreferredResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InstanceSavingsEstimationMode> SAVINGS_ESTIMATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsEstimationMode").getter(EffectiveRecommendationPreferences.getter(EffectiveRecommendationPreferences::savingsEstimationMode)).setter(EffectiveRecommendationPreferences.setter(Builder::savingsEstimationMode)).constructor(InstanceSavingsEstimationMode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsEstimationMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPU_VENDOR_ARCHITECTURES_FIELD, ENHANCED_INFRASTRUCTURE_METRICS_FIELD, INFERRED_WORKLOAD_TYPES_FIELD, EXTERNAL_METRICS_PREFERENCE_FIELD, LOOK_BACK_PERIOD_FIELD, UTILIZATION_PREFERENCES_FIELD, PREFERRED_RESOURCES_FIELD, SAVINGS_ESTIMATION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cpuVendorArchitectures", CPU_VENDOR_ARCHITECTURES_FIELD);
            this.put("enhancedInfrastructureMetrics", ENHANCED_INFRASTRUCTURE_METRICS_FIELD);
            this.put("inferredWorkloadTypes", INFERRED_WORKLOAD_TYPES_FIELD);
            this.put("externalMetricsPreference", EXTERNAL_METRICS_PREFERENCE_FIELD);
            this.put("lookBackPeriod", LOOK_BACK_PERIOD_FIELD);
            this.put("utilizationPreferences", UTILIZATION_PREFERENCES_FIELD);
            this.put("preferredResources", PREFERRED_RESOURCES_FIELD);
            this.put("savingsEstimationMode", SAVINGS_ESTIMATION_MODE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> cpuVendorArchitectures;
    private final String enhancedInfrastructureMetrics;
    private final String inferredWorkloadTypes;
    private final ExternalMetricsPreference externalMetricsPreference;
    private final String lookBackPeriod;
    private final List<UtilizationPreference> utilizationPreferences;
    private final List<EffectivePreferredResource> preferredResources;
    private final InstanceSavingsEstimationMode savingsEstimationMode;

    private EffectiveRecommendationPreferences(BuilderImpl builder) {
        this.cpuVendorArchitectures = builder.cpuVendorArchitectures;
        this.enhancedInfrastructureMetrics = builder.enhancedInfrastructureMetrics;
        this.inferredWorkloadTypes = builder.inferredWorkloadTypes;
        this.externalMetricsPreference = builder.externalMetricsPreference;
        this.lookBackPeriod = builder.lookBackPeriod;
        this.utilizationPreferences = builder.utilizationPreferences;
        this.preferredResources = builder.preferredResources;
        this.savingsEstimationMode = builder.savingsEstimationMode;
    }

    public final List<CpuVendorArchitecture> cpuVendorArchitectures() {
        return CpuVendorArchitecturesCopier.copyStringToEnum(this.cpuVendorArchitectures);
    }

    public final boolean hasCpuVendorArchitectures() {
        return this.cpuVendorArchitectures != null && !(this.cpuVendorArchitectures instanceof SdkAutoConstructList);
    }

    public final List<String> cpuVendorArchitecturesAsStrings() {
        return this.cpuVendorArchitectures;
    }

    public final EnhancedInfrastructureMetrics enhancedInfrastructureMetrics() {
        return EnhancedInfrastructureMetrics.fromValue(this.enhancedInfrastructureMetrics);
    }

    public final String enhancedInfrastructureMetricsAsString() {
        return this.enhancedInfrastructureMetrics;
    }

    public final InferredWorkloadTypesPreference inferredWorkloadTypes() {
        return InferredWorkloadTypesPreference.fromValue(this.inferredWorkloadTypes);
    }

    public final String inferredWorkloadTypesAsString() {
        return this.inferredWorkloadTypes;
    }

    public final ExternalMetricsPreference externalMetricsPreference() {
        return this.externalMetricsPreference;
    }

    public final LookBackPeriodPreference lookBackPeriod() {
        return LookBackPeriodPreference.fromValue(this.lookBackPeriod);
    }

    public final String lookBackPeriodAsString() {
        return this.lookBackPeriod;
    }

    public final boolean hasUtilizationPreferences() {
        return this.utilizationPreferences != null && !(this.utilizationPreferences instanceof SdkAutoConstructList);
    }

    public final List<UtilizationPreference> utilizationPreferences() {
        return this.utilizationPreferences;
    }

    public final boolean hasPreferredResources() {
        return this.preferredResources != null && !(this.preferredResources instanceof SdkAutoConstructList);
    }

    public final List<EffectivePreferredResource> preferredResources() {
        return this.preferredResources;
    }

    public final InstanceSavingsEstimationMode savingsEstimationMode() {
        return this.savingsEstimationMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCpuVendorArchitectures() ? this.cpuVendorArchitecturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedInfrastructureMetricsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferredWorkloadTypesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalMetricsPreference());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookBackPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUtilizationPreferences() ? this.utilizationPreferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPreferredResources() ? this.preferredResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsEstimationMode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectiveRecommendationPreferences)) {
            return false;
        }
        EffectiveRecommendationPreferences other = (EffectiveRecommendationPreferences)obj;
        return this.hasCpuVendorArchitectures() == other.hasCpuVendorArchitectures() && Objects.equals(this.cpuVendorArchitecturesAsStrings(), other.cpuVendorArchitecturesAsStrings()) && Objects.equals(this.enhancedInfrastructureMetricsAsString(), other.enhancedInfrastructureMetricsAsString()) && Objects.equals(this.inferredWorkloadTypesAsString(), other.inferredWorkloadTypesAsString()) && Objects.equals(this.externalMetricsPreference(), other.externalMetricsPreference()) && Objects.equals(this.lookBackPeriodAsString(), other.lookBackPeriodAsString()) && this.hasUtilizationPreferences() == other.hasUtilizationPreferences() && Objects.equals(this.utilizationPreferences(), other.utilizationPreferences()) && this.hasPreferredResources() == other.hasPreferredResources() && Objects.equals(this.preferredResources(), other.preferredResources()) && Objects.equals(this.savingsEstimationMode(), other.savingsEstimationMode());
    }

    public final String toString() {
        return ToString.builder((String)"EffectiveRecommendationPreferences").add("CpuVendorArchitectures", this.hasCpuVendorArchitectures() ? this.cpuVendorArchitecturesAsStrings() : null).add("EnhancedInfrastructureMetrics", (Object)this.enhancedInfrastructureMetricsAsString()).add("InferredWorkloadTypes", (Object)this.inferredWorkloadTypesAsString()).add("ExternalMetricsPreference", (Object)this.externalMetricsPreference()).add("LookBackPeriod", (Object)this.lookBackPeriodAsString()).add("UtilizationPreferences", this.hasUtilizationPreferences() ? this.utilizationPreferences() : null).add("PreferredResources", this.hasPreferredResources() ? this.preferredResources() : null).add("SavingsEstimationMode", (Object)this.savingsEstimationMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cpuVendorArchitectures": {
                return Optional.ofNullable(clazz.cast(this.cpuVendorArchitecturesAsStrings()));
            }
            case "enhancedInfrastructureMetrics": {
                return Optional.ofNullable(clazz.cast(this.enhancedInfrastructureMetricsAsString()));
            }
            case "inferredWorkloadTypes": {
                return Optional.ofNullable(clazz.cast(this.inferredWorkloadTypesAsString()));
            }
            case "externalMetricsPreference": {
                return Optional.ofNullable(clazz.cast(this.externalMetricsPreference()));
            }
            case "lookBackPeriod": {
                return Optional.ofNullable(clazz.cast(this.lookBackPeriodAsString()));
            }
            case "utilizationPreferences": {
                return Optional.ofNullable(clazz.cast(this.utilizationPreferences()));
            }
            case "preferredResources": {
                return Optional.ofNullable(clazz.cast(this.preferredResources()));
            }
            case "savingsEstimationMode": {
                return Optional.ofNullable(clazz.cast(this.savingsEstimationMode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EffectiveRecommendationPreferences, T> g) {
        return obj -> g.apply((EffectiveRecommendationPreferences)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> cpuVendorArchitectures = DefaultSdkAutoConstructList.getInstance();
        private String enhancedInfrastructureMetrics;
        private String inferredWorkloadTypes;
        private ExternalMetricsPreference externalMetricsPreference;
        private String lookBackPeriod;
        private List<UtilizationPreference> utilizationPreferences = DefaultSdkAutoConstructList.getInstance();
        private List<EffectivePreferredResource> preferredResources = DefaultSdkAutoConstructList.getInstance();
        private InstanceSavingsEstimationMode savingsEstimationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(EffectiveRecommendationPreferences model) {
            this.cpuVendorArchitecturesWithStrings(model.cpuVendorArchitectures);
            this.enhancedInfrastructureMetrics(model.enhancedInfrastructureMetrics);
            this.inferredWorkloadTypes(model.inferredWorkloadTypes);
            this.externalMetricsPreference(model.externalMetricsPreference);
            this.lookBackPeriod(model.lookBackPeriod);
            this.utilizationPreferences(model.utilizationPreferences);
            this.preferredResources(model.preferredResources);
            this.savingsEstimationMode(model.savingsEstimationMode);
        }

        public final Collection<String> getCpuVendorArchitectures() {
            if (this.cpuVendorArchitectures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cpuVendorArchitectures;
        }

        public final void setCpuVendorArchitectures(Collection<String> cpuVendorArchitectures) {
            this.cpuVendorArchitectures = CpuVendorArchitecturesCopier.copy(cpuVendorArchitectures);
        }

        @Override
        public final Builder cpuVendorArchitecturesWithStrings(Collection<String> cpuVendorArchitectures) {
            this.cpuVendorArchitectures = CpuVendorArchitecturesCopier.copy(cpuVendorArchitectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cpuVendorArchitecturesWithStrings(String ... cpuVendorArchitectures) {
            this.cpuVendorArchitecturesWithStrings(Arrays.asList(cpuVendorArchitectures));
            return this;
        }

        @Override
        public final Builder cpuVendorArchitectures(Collection<CpuVendorArchitecture> cpuVendorArchitectures) {
            this.cpuVendorArchitectures = CpuVendorArchitecturesCopier.copyEnumToString(cpuVendorArchitectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cpuVendorArchitectures(CpuVendorArchitecture ... cpuVendorArchitectures) {
            this.cpuVendorArchitectures(Arrays.asList(cpuVendorArchitectures));
            return this;
        }

        public final String getEnhancedInfrastructureMetrics() {
            return this.enhancedInfrastructureMetrics;
        }

        public final void setEnhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
        }

        @Override
        public final Builder enhancedInfrastructureMetrics(String enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics = enhancedInfrastructureMetrics;
            return this;
        }

        @Override
        public final Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics enhancedInfrastructureMetrics) {
            this.enhancedInfrastructureMetrics(enhancedInfrastructureMetrics == null ? null : enhancedInfrastructureMetrics.toString());
            return this;
        }

        public final String getInferredWorkloadTypes() {
            return this.inferredWorkloadTypes;
        }

        public final void setInferredWorkloadTypes(String inferredWorkloadTypes) {
            this.inferredWorkloadTypes = inferredWorkloadTypes;
        }

        @Override
        public final Builder inferredWorkloadTypes(String inferredWorkloadTypes) {
            this.inferredWorkloadTypes = inferredWorkloadTypes;
            return this;
        }

        @Override
        public final Builder inferredWorkloadTypes(InferredWorkloadTypesPreference inferredWorkloadTypes) {
            this.inferredWorkloadTypes(inferredWorkloadTypes == null ? null : inferredWorkloadTypes.toString());
            return this;
        }

        public final ExternalMetricsPreference.Builder getExternalMetricsPreference() {
            return this.externalMetricsPreference != null ? this.externalMetricsPreference.toBuilder() : null;
        }

        public final void setExternalMetricsPreference(ExternalMetricsPreference.BuilderImpl externalMetricsPreference) {
            this.externalMetricsPreference = externalMetricsPreference != null ? externalMetricsPreference.build() : null;
        }

        @Override
        public final Builder externalMetricsPreference(ExternalMetricsPreference externalMetricsPreference) {
            this.externalMetricsPreference = externalMetricsPreference;
            return this;
        }

        public final String getLookBackPeriod() {
            return this.lookBackPeriod;
        }

        public final void setLookBackPeriod(String lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
        }

        @Override
        public final Builder lookBackPeriod(String lookBackPeriod) {
            this.lookBackPeriod = lookBackPeriod;
            return this;
        }

        @Override
        public final Builder lookBackPeriod(LookBackPeriodPreference lookBackPeriod) {
            this.lookBackPeriod(lookBackPeriod == null ? null : lookBackPeriod.toString());
            return this;
        }

        public final List<UtilizationPreference.Builder> getUtilizationPreferences() {
            List<UtilizationPreference.Builder> result = UtilizationPreferencesCopier.copyToBuilder(this.utilizationPreferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUtilizationPreferences(Collection<UtilizationPreference.BuilderImpl> utilizationPreferences) {
            this.utilizationPreferences = UtilizationPreferencesCopier.copyFromBuilder(utilizationPreferences);
        }

        @Override
        public final Builder utilizationPreferences(Collection<UtilizationPreference> utilizationPreferences) {
            this.utilizationPreferences = UtilizationPreferencesCopier.copy(utilizationPreferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationPreferences(UtilizationPreference ... utilizationPreferences) {
            this.utilizationPreferences(Arrays.asList(utilizationPreferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationPreferences(Consumer<UtilizationPreference.Builder> ... utilizationPreferences) {
            this.utilizationPreferences(Stream.of(utilizationPreferences).map(c -> (UtilizationPreference)((UtilizationPreference.Builder)UtilizationPreference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EffectivePreferredResource.Builder> getPreferredResources() {
            List<EffectivePreferredResource.Builder> result = EffectivePreferredResourcesCopier.copyToBuilder(this.preferredResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPreferredResources(Collection<EffectivePreferredResource.BuilderImpl> preferredResources) {
            this.preferredResources = EffectivePreferredResourcesCopier.copyFromBuilder(preferredResources);
        }

        @Override
        public final Builder preferredResources(Collection<EffectivePreferredResource> preferredResources) {
            this.preferredResources = EffectivePreferredResourcesCopier.copy(preferredResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredResources(EffectivePreferredResource ... preferredResources) {
            this.preferredResources(Arrays.asList(preferredResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredResources(Consumer<EffectivePreferredResource.Builder> ... preferredResources) {
            this.preferredResources(Stream.of(preferredResources).map(c -> (EffectivePreferredResource)((EffectivePreferredResource.Builder)EffectivePreferredResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InstanceSavingsEstimationMode.Builder getSavingsEstimationMode() {
            return this.savingsEstimationMode != null ? this.savingsEstimationMode.toBuilder() : null;
        }

        public final void setSavingsEstimationMode(InstanceSavingsEstimationMode.BuilderImpl savingsEstimationMode) {
            this.savingsEstimationMode = savingsEstimationMode != null ? savingsEstimationMode.build() : null;
        }

        @Override
        public final Builder savingsEstimationMode(InstanceSavingsEstimationMode savingsEstimationMode) {
            this.savingsEstimationMode = savingsEstimationMode;
            return this;
        }

        public EffectiveRecommendationPreferences build() {
            return new EffectiveRecommendationPreferences(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EffectiveRecommendationPreferences> {
        public Builder cpuVendorArchitecturesWithStrings(Collection<String> var1);

        public Builder cpuVendorArchitecturesWithStrings(String ... var1);

        public Builder cpuVendorArchitectures(Collection<CpuVendorArchitecture> var1);

        public Builder cpuVendorArchitectures(CpuVendorArchitecture ... var1);

        public Builder enhancedInfrastructureMetrics(String var1);

        public Builder enhancedInfrastructureMetrics(EnhancedInfrastructureMetrics var1);

        public Builder inferredWorkloadTypes(String var1);

        public Builder inferredWorkloadTypes(InferredWorkloadTypesPreference var1);

        public Builder externalMetricsPreference(ExternalMetricsPreference var1);

        default public Builder externalMetricsPreference(Consumer<ExternalMetricsPreference.Builder> externalMetricsPreference) {
            return this.externalMetricsPreference((ExternalMetricsPreference)((ExternalMetricsPreference.Builder)ExternalMetricsPreference.builder().applyMutation(externalMetricsPreference)).build());
        }

        public Builder lookBackPeriod(String var1);

        public Builder lookBackPeriod(LookBackPeriodPreference var1);

        public Builder utilizationPreferences(Collection<UtilizationPreference> var1);

        public Builder utilizationPreferences(UtilizationPreference ... var1);

        public Builder utilizationPreferences(Consumer<UtilizationPreference.Builder> ... var1);

        public Builder preferredResources(Collection<EffectivePreferredResource> var1);

        public Builder preferredResources(EffectivePreferredResource ... var1);

        public Builder preferredResources(Consumer<EffectivePreferredResource.Builder> ... var1);

        public Builder savingsEstimationMode(InstanceSavingsEstimationMode var1);

        default public Builder savingsEstimationMode(Consumer<InstanceSavingsEstimationMode.Builder> savingsEstimationMode) {
            return this.savingsEstimationMode((InstanceSavingsEstimationMode)((InstanceSavingsEstimationMode.Builder)InstanceSavingsEstimationMode.builder().applyMutation(savingsEstimationMode)).build());
        }
    }
}

