/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.Currency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingGroupEstimatedMonthlySavings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingGroupEstimatedMonthlySavings> {
    private static final SdkField<String> CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currency").getter(AutoScalingGroupEstimatedMonthlySavings.getter(AutoScalingGroupEstimatedMonthlySavings::currencyAsString)).setter(AutoScalingGroupEstimatedMonthlySavings.setter(Builder::currency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()}).build();
    private static final SdkField<Double> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("value").getter(AutoScalingGroupEstimatedMonthlySavings.getter(AutoScalingGroupEstimatedMonthlySavings::value)).setter(AutoScalingGroupEstimatedMonthlySavings.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String currency;
    private final Double value;

    private AutoScalingGroupEstimatedMonthlySavings(BuilderImpl builder) {
        this.currency = builder.currency;
        this.value = builder.value;
    }

    public final Currency currency() {
        return Currency.fromValue(this.currency);
    }

    public final String currencyAsString() {
        return this.currency;
    }

    public final Double value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroupEstimatedMonthlySavings)) {
            return false;
        }
        AutoScalingGroupEstimatedMonthlySavings other = (AutoScalingGroupEstimatedMonthlySavings)obj;
        return Objects.equals(this.currencyAsString(), other.currencyAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingGroupEstimatedMonthlySavings").add("Currency", (Object)this.currencyAsString()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "currency": {
                return Optional.ofNullable(clazz.cast(this.currencyAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroupEstimatedMonthlySavings, T> g) {
        return obj -> g.apply((AutoScalingGroupEstimatedMonthlySavings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currency;
        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroupEstimatedMonthlySavings model) {
            this.currency(model.currency);
            this.value(model.value);
        }

        public final String getCurrency() {
            return this.currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public final Builder currency(Currency currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final Double getValue() {
            return this.value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public AutoScalingGroupEstimatedMonthlySavings build() {
            return new AutoScalingGroupEstimatedMonthlySavings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingGroupEstimatedMonthlySavings> {
        public Builder currency(String var1);

        public Builder currency(Currency var1);

        public Builder value(Double var1);
    }
}

