/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ExportableECSServiceField {
    ACCOUNT_ID("AccountId"),

    SERVICE_ARN("ServiceArn"),

    LOOKBACK_PERIOD_IN_DAYS("LookbackPeriodInDays"),

    LAST_REFRESH_TIMESTAMP("LastRefreshTimestamp"),

    LAUNCH_TYPE("LaunchType"),

    CURRENT_PERFORMANCE_RISK("CurrentPerformanceRisk"),

    CURRENT_SERVICE_CONFIGURATION_MEMORY("CurrentServiceConfigurationMemory"),

    CURRENT_SERVICE_CONFIGURATION_CPU("CurrentServiceConfigurationCpu"),

    CURRENT_SERVICE_CONFIGURATION_TASK_DEFINITION_ARN("CurrentServiceConfigurationTaskDefinitionArn"),

    CURRENT_SERVICE_CONFIGURATION_AUTO_SCALING_CONFIGURATION("CurrentServiceConfigurationAutoScalingConfiguration"),

    CURRENT_SERVICE_CONTAINER_CONFIGURATIONS("CurrentServiceContainerConfigurations"),

    UTILIZATION_METRICS_CPU_MAXIMUM("UtilizationMetricsCpuMaximum"),

    UTILIZATION_METRICS_MEMORY_MAXIMUM("UtilizationMetricsMemoryMaximum"),

    FINDING("Finding"),

    FINDING_REASON_CODES("FindingReasonCodes"),

    RECOMMENDATION_OPTIONS_MEMORY("RecommendationOptionsMemory"),

    RECOMMENDATION_OPTIONS_CPU("RecommendationOptionsCpu"),

    RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE("RecommendationOptionsSavingsOpportunityPercentage"),

    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY("RecommendationOptionsEstimatedMonthlySavingsCurrency"),

    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE("RecommendationOptionsEstimatedMonthlySavingsValue"),

    RECOMMENDATION_OPTIONS_CONTAINER_RECOMMENDATIONS("RecommendationOptionsContainerRecommendations"),

    RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_CPU_MAXIMUM("RecommendationOptionsProjectedUtilizationMetricsCpuMaximum"),

    RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_MEMORY_MAXIMUM(
            "RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum"),

    TAGS("Tags"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportableECSServiceField> VALUE_MAP = EnumUtils.uniqueIndex(
            ExportableECSServiceField.class, ExportableECSServiceField::toString);

    private final String value;

    private ExportableECSServiceField(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ExportableECSServiceField corresponding to the value
     */
    public static ExportableECSServiceField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ExportableECSServiceField}s
     */
    public static Set<ExportableECSServiceField> knownValues() {
        Set<ExportableECSServiceField> knownValues = EnumSet.allOf(ExportableECSServiceField.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
