/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.computeoptimizer.ComputeOptimizerClient;
import software.amazon.awssdk.services.computeoptimizer.ComputeOptimizerServiceClientConfiguration;
import software.amazon.awssdk.services.computeoptimizer.model.AccessDeniedException;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerException;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerRequest;
import software.amazon.awssdk.services.computeoptimizer.model.DeleteRecommendationPreferencesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.DeleteRecommendationPreferencesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.DescribeRecommendationExportJobsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportAutoScalingGroupRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEbsVolumeRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEbsVolumeRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEc2InstanceRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEc2InstanceRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEcsServiceRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportEcsServiceRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.ExportLambdaFunctionRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEbsVolumeRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEbsVolumeRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEc2InstanceRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEc2RecommendationProjectedMetricsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationProjectedMetricsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEcsServiceRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetEnrollmentStatusesForOrganizationResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationSummariesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.InternalServerException;
import software.amazon.awssdk.services.computeoptimizer.model.InvalidParameterValueException;
import software.amazon.awssdk.services.computeoptimizer.model.LimitExceededException;
import software.amazon.awssdk.services.computeoptimizer.model.MissingAuthenticationTokenException;
import software.amazon.awssdk.services.computeoptimizer.model.OptInRequiredException;
import software.amazon.awssdk.services.computeoptimizer.model.PutRecommendationPreferencesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.PutRecommendationPreferencesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.ResourceNotFoundException;
import software.amazon.awssdk.services.computeoptimizer.model.ServiceUnavailableException;
import software.amazon.awssdk.services.computeoptimizer.model.ThrottlingException;
import software.amazon.awssdk.services.computeoptimizer.model.UpdateEnrollmentStatusRequest;
import software.amazon.awssdk.services.computeoptimizer.model.UpdateEnrollmentStatusResponse;
import software.amazon.awssdk.services.computeoptimizer.paginators.DescribeRecommendationExportJobsIterable;
import software.amazon.awssdk.services.computeoptimizer.paginators.GetEnrollmentStatusesForOrganizationIterable;
import software.amazon.awssdk.services.computeoptimizer.paginators.GetLambdaFunctionRecommendationsIterable;
import software.amazon.awssdk.services.computeoptimizer.paginators.GetRecommendationPreferencesIterable;
import software.amazon.awssdk.services.computeoptimizer.paginators.GetRecommendationSummariesIterable;
import software.amazon.awssdk.services.computeoptimizer.transform.DeleteRecommendationPreferencesRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.DescribeRecommendationExportJobsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.ExportAutoScalingGroupRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.ExportEbsVolumeRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.ExportEc2InstanceRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.ExportEcsServiceRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.ExportLambdaFunctionRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetAutoScalingGroupRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetEbsVolumeRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetEc2InstanceRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetEc2RecommendationProjectedMetricsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetEcsServiceRecommendationProjectedMetricsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetEcsServiceRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetEffectiveRecommendationPreferencesRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetEnrollmentStatusRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetEnrollmentStatusesForOrganizationRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetLambdaFunctionRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetRecommendationPreferencesRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.GetRecommendationSummariesRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.PutRecommendationPreferencesRequestMarshaller;
import software.amazon.awssdk.services.computeoptimizer.transform.UpdateEnrollmentStatusRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultComputeOptimizerClient
implements ComputeOptimizerClient {
    private static final Logger log = Logger.loggerFor(DefaultComputeOptimizerClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ComputeOptimizerServiceClientConfiguration serviceClientConfiguration;

    protected DefaultComputeOptimizerClient(ComputeOptimizerServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRecommendationPreferencesResponse deleteRecommendationPreferences(DeleteRecommendationPreferencesRequest deleteRecommendationPreferencesRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRecommendationPreferencesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, deleteRecommendationPreferencesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRecommendationPreferences");
            DeleteRecommendationPreferencesResponse deleteRecommendationPreferencesResponse = (DeleteRecommendationPreferencesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRecommendationPreferences").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRecommendationPreferencesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRecommendationPreferencesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRecommendationPreferencesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$deleteRecommendationPreferences$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRecommendationExportJobsResponse describeRecommendationExportJobs(DescribeRecommendationExportJobsRequest describeRecommendationExportJobsRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRecommendationExportJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, describeRecommendationExportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRecommendationExportJobs");
            DescribeRecommendationExportJobsResponse describeRecommendationExportJobsResponse = (DescribeRecommendationExportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRecommendationExportJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRecommendationExportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRecommendationExportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRecommendationExportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$describeRecommendationExportJobs$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeRecommendationExportJobsIterable describeRecommendationExportJobsPaginator(DescribeRecommendationExportJobsRequest describeRecommendationExportJobsRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        return new DescribeRecommendationExportJobsIterable(this, this.applyPaginatorUserAgent(describeRecommendationExportJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportAutoScalingGroupRecommendationsResponse exportAutoScalingGroupRecommendations(ExportAutoScalingGroupRecommendationsRequest exportAutoScalingGroupRecommendationsRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, MissingAuthenticationTokenException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportAutoScalingGroupRecommendationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, exportAutoScalingGroupRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportAutoScalingGroupRecommendations");
            ExportAutoScalingGroupRecommendationsResponse exportAutoScalingGroupRecommendationsResponse = (ExportAutoScalingGroupRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportAutoScalingGroupRecommendations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)exportAutoScalingGroupRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExportAutoScalingGroupRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return exportAutoScalingGroupRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$exportAutoScalingGroupRecommendations$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportEbsVolumeRecommendationsResponse exportEBSVolumeRecommendations(ExportEbsVolumeRecommendationsRequest exportEbsVolumeRecommendationsRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, MissingAuthenticationTokenException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportEbsVolumeRecommendationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, exportEbsVolumeRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportEBSVolumeRecommendations");
            ExportEbsVolumeRecommendationsResponse exportEbsVolumeRecommendationsResponse = (ExportEbsVolumeRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportEBSVolumeRecommendations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)exportEbsVolumeRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExportEbsVolumeRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return exportEbsVolumeRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$exportEBSVolumeRecommendations$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportEc2InstanceRecommendationsResponse exportEC2InstanceRecommendations(ExportEc2InstanceRecommendationsRequest exportEc2InstanceRecommendationsRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, MissingAuthenticationTokenException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportEc2InstanceRecommendationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, exportEc2InstanceRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportEC2InstanceRecommendations");
            ExportEc2InstanceRecommendationsResponse exportEc2InstanceRecommendationsResponse = (ExportEc2InstanceRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportEC2InstanceRecommendations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)exportEc2InstanceRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExportEc2InstanceRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return exportEc2InstanceRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$exportEC2InstanceRecommendations$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportEcsServiceRecommendationsResponse exportECSServiceRecommendations(ExportEcsServiceRecommendationsRequest exportEcsServiceRecommendationsRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, MissingAuthenticationTokenException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportEcsServiceRecommendationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, exportEcsServiceRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportECSServiceRecommendations");
            ExportEcsServiceRecommendationsResponse exportEcsServiceRecommendationsResponse = (ExportEcsServiceRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportECSServiceRecommendations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)exportEcsServiceRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExportEcsServiceRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return exportEcsServiceRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$exportECSServiceRecommendations$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportLambdaFunctionRecommendationsResponse exportLambdaFunctionRecommendations(ExportLambdaFunctionRecommendationsRequest exportLambdaFunctionRecommendationsRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, MissingAuthenticationTokenException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportLambdaFunctionRecommendationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, exportLambdaFunctionRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportLambdaFunctionRecommendations");
            ExportLambdaFunctionRecommendationsResponse exportLambdaFunctionRecommendationsResponse = (ExportLambdaFunctionRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportLambdaFunctionRecommendations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)exportLambdaFunctionRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExportLambdaFunctionRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return exportLambdaFunctionRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$exportLambdaFunctionRecommendations$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAutoScalingGroupRecommendationsResponse getAutoScalingGroupRecommendations(GetAutoScalingGroupRecommendationsRequest getAutoScalingGroupRecommendationsRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAutoScalingGroupRecommendationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, getAutoScalingGroupRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAutoScalingGroupRecommendations");
            GetAutoScalingGroupRecommendationsResponse getAutoScalingGroupRecommendationsResponse = (GetAutoScalingGroupRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAutoScalingGroupRecommendations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAutoScalingGroupRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAutoScalingGroupRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAutoScalingGroupRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$getAutoScalingGroupRecommendations$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEbsVolumeRecommendationsResponse getEBSVolumeRecommendations(GetEbsVolumeRecommendationsRequest getEbsVolumeRecommendationsRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEbsVolumeRecommendationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, getEbsVolumeRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEBSVolumeRecommendations");
            GetEbsVolumeRecommendationsResponse getEbsVolumeRecommendationsResponse = (GetEbsVolumeRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEBSVolumeRecommendations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEbsVolumeRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEbsVolumeRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEbsVolumeRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$getEBSVolumeRecommendations$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEc2InstanceRecommendationsResponse getEC2InstanceRecommendations(GetEc2InstanceRecommendationsRequest getEc2InstanceRecommendationsRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEc2InstanceRecommendationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, getEc2InstanceRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEC2InstanceRecommendations");
            GetEc2InstanceRecommendationsResponse getEc2InstanceRecommendationsResponse = (GetEc2InstanceRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEC2InstanceRecommendations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEc2InstanceRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEc2InstanceRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEc2InstanceRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$getEC2InstanceRecommendations$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEc2RecommendationProjectedMetricsResponse getEC2RecommendationProjectedMetrics(GetEc2RecommendationProjectedMetricsRequest getEc2RecommendationProjectedMetricsRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEc2RecommendationProjectedMetricsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, getEc2RecommendationProjectedMetricsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEC2RecommendationProjectedMetrics");
            GetEc2RecommendationProjectedMetricsResponse getEc2RecommendationProjectedMetricsResponse = (GetEc2RecommendationProjectedMetricsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEC2RecommendationProjectedMetrics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEc2RecommendationProjectedMetricsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEc2RecommendationProjectedMetricsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEc2RecommendationProjectedMetricsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$getEC2RecommendationProjectedMetrics$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEcsServiceRecommendationProjectedMetricsResponse getECSServiceRecommendationProjectedMetrics(GetEcsServiceRecommendationProjectedMetricsRequest getEcsServiceRecommendationProjectedMetricsRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEcsServiceRecommendationProjectedMetricsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, getEcsServiceRecommendationProjectedMetricsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetECSServiceRecommendationProjectedMetrics");
            GetEcsServiceRecommendationProjectedMetricsResponse getEcsServiceRecommendationProjectedMetricsResponse = (GetEcsServiceRecommendationProjectedMetricsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetECSServiceRecommendationProjectedMetrics").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEcsServiceRecommendationProjectedMetricsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEcsServiceRecommendationProjectedMetricsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEcsServiceRecommendationProjectedMetricsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$getECSServiceRecommendationProjectedMetrics$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEcsServiceRecommendationsResponse getECSServiceRecommendations(GetEcsServiceRecommendationsRequest getEcsServiceRecommendationsRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEcsServiceRecommendationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, getEcsServiceRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetECSServiceRecommendations");
            GetEcsServiceRecommendationsResponse getEcsServiceRecommendationsResponse = (GetEcsServiceRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetECSServiceRecommendations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEcsServiceRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEcsServiceRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEcsServiceRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$getECSServiceRecommendations$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEffectiveRecommendationPreferencesResponse getEffectiveRecommendationPreferences(GetEffectiveRecommendationPreferencesRequest getEffectiveRecommendationPreferencesRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEffectiveRecommendationPreferencesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, getEffectiveRecommendationPreferencesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEffectiveRecommendationPreferences");
            GetEffectiveRecommendationPreferencesResponse getEffectiveRecommendationPreferencesResponse = (GetEffectiveRecommendationPreferencesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEffectiveRecommendationPreferences").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEffectiveRecommendationPreferencesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEffectiveRecommendationPreferencesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEffectiveRecommendationPreferencesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$getEffectiveRecommendationPreferences$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEnrollmentStatusResponse getEnrollmentStatus(GetEnrollmentStatusRequest getEnrollmentStatusRequest) throws InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEnrollmentStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, getEnrollmentStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEnrollmentStatus");
            GetEnrollmentStatusResponse getEnrollmentStatusResponse = (GetEnrollmentStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEnrollmentStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEnrollmentStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEnrollmentStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEnrollmentStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$getEnrollmentStatus$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEnrollmentStatusesForOrganizationResponse getEnrollmentStatusesForOrganization(GetEnrollmentStatusesForOrganizationRequest getEnrollmentStatusesForOrganizationRequest) throws InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEnrollmentStatusesForOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, getEnrollmentStatusesForOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEnrollmentStatusesForOrganization");
            GetEnrollmentStatusesForOrganizationResponse getEnrollmentStatusesForOrganizationResponse = (GetEnrollmentStatusesForOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEnrollmentStatusesForOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEnrollmentStatusesForOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEnrollmentStatusesForOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEnrollmentStatusesForOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$getEnrollmentStatusesForOrganization$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetEnrollmentStatusesForOrganizationIterable getEnrollmentStatusesForOrganizationPaginator(GetEnrollmentStatusesForOrganizationRequest getEnrollmentStatusesForOrganizationRequest) throws InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        return new GetEnrollmentStatusesForOrganizationIterable(this, this.applyPaginatorUserAgent(getEnrollmentStatusesForOrganizationRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLambdaFunctionRecommendationsResponse getLambdaFunctionRecommendations(GetLambdaFunctionRecommendationsRequest getLambdaFunctionRecommendationsRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, MissingAuthenticationTokenException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLambdaFunctionRecommendationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, getLambdaFunctionRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLambdaFunctionRecommendations");
            GetLambdaFunctionRecommendationsResponse getLambdaFunctionRecommendationsResponse = (GetLambdaFunctionRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLambdaFunctionRecommendations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLambdaFunctionRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLambdaFunctionRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLambdaFunctionRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$getLambdaFunctionRecommendations$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetLambdaFunctionRecommendationsIterable getLambdaFunctionRecommendationsPaginator(GetLambdaFunctionRecommendationsRequest getLambdaFunctionRecommendationsRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, MissingAuthenticationTokenException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        return new GetLambdaFunctionRecommendationsIterable(this, this.applyPaginatorUserAgent(getLambdaFunctionRecommendationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRecommendationPreferencesResponse getRecommendationPreferences(GetRecommendationPreferencesRequest getRecommendationPreferencesRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRecommendationPreferencesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, getRecommendationPreferencesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRecommendationPreferences");
            GetRecommendationPreferencesResponse getRecommendationPreferencesResponse = (GetRecommendationPreferencesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRecommendationPreferences").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRecommendationPreferencesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRecommendationPreferencesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRecommendationPreferencesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$getRecommendationPreferences$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetRecommendationPreferencesIterable getRecommendationPreferencesPaginator(GetRecommendationPreferencesRequest getRecommendationPreferencesRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        return new GetRecommendationPreferencesIterable(this, this.applyPaginatorUserAgent(getRecommendationPreferencesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRecommendationSummariesResponse getRecommendationSummaries(GetRecommendationSummariesRequest getRecommendationSummariesRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRecommendationSummariesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, getRecommendationSummariesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRecommendationSummaries");
            GetRecommendationSummariesResponse getRecommendationSummariesResponse = (GetRecommendationSummariesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRecommendationSummaries").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRecommendationSummariesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRecommendationSummariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRecommendationSummariesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$getRecommendationSummaries$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetRecommendationSummariesIterable getRecommendationSummariesPaginator(GetRecommendationSummariesRequest getRecommendationSummariesRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        return new GetRecommendationSummariesIterable(this, this.applyPaginatorUserAgent(getRecommendationSummariesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRecommendationPreferencesResponse putRecommendationPreferences(PutRecommendationPreferencesRequest putRecommendationPreferencesRequest) throws OptInRequiredException, InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRecommendationPreferencesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, putRecommendationPreferencesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRecommendationPreferences");
            PutRecommendationPreferencesResponse putRecommendationPreferencesResponse = (PutRecommendationPreferencesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRecommendationPreferences").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putRecommendationPreferencesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutRecommendationPreferencesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putRecommendationPreferencesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$putRecommendationPreferences$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEnrollmentStatusResponse updateEnrollmentStatus(UpdateEnrollmentStatusRequest updateEnrollmentStatusRequest) throws InternalServerException, ServiceUnavailableException, AccessDeniedException, InvalidParameterValueException, MissingAuthenticationTokenException, ThrottlingException, AwsServiceException, SdkClientException, ComputeOptimizerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEnrollmentStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultComputeOptimizerClient.resolveMetricPublishers(this.clientConfiguration, updateEnrollmentStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Compute Optimizer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEnrollmentStatus");
            UpdateEnrollmentStatusResponse updateEnrollmentStatusResponse = (UpdateEnrollmentStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEnrollmentStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEnrollmentStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEnrollmentStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEnrollmentStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComputeOptimizerClient.lambda$updateEnrollmentStatus$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends ComputeOptimizerRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.78").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ComputeOptimizerRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "compute-optimizer";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ComputeOptimizerException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OptInRequiredException").exceptionBuilderSupplier(OptInRequiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MissingAuthenticationToken").exceptionBuilderSupplier(MissingAuthenticationTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    @Override
    public final ComputeOptimizerServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateEnrollmentStatus$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putRecommendationPreferences$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRecommendationSummaries$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRecommendationPreferences$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLambdaFunctionRecommendations$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEnrollmentStatusesForOrganization$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEnrollmentStatus$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEffectiveRecommendationPreferences$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getECSServiceRecommendations$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getECSServiceRecommendationProjectedMetrics$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEC2RecommendationProjectedMetrics$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEC2InstanceRecommendations$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEBSVolumeRecommendations$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAutoScalingGroupRecommendations$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportLambdaFunctionRecommendations$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportECSServiceRecommendations$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportEC2InstanceRecommendations$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportEBSVolumeRecommendations$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportAutoScalingGroupRecommendations$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRecommendationExportJobs$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRecommendationPreferences$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

