/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizer.ComputeOptimizerAsyncClient;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferencesDetail;

public class GetRecommendationPreferencesPublisher
implements SdkPublisher<GetRecommendationPreferencesResponse> {
    private final ComputeOptimizerAsyncClient client;
    private final GetRecommendationPreferencesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetRecommendationPreferencesPublisher(ComputeOptimizerAsyncClient client, GetRecommendationPreferencesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetRecommendationPreferencesPublisher(ComputeOptimizerAsyncClient client, GetRecommendationPreferencesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetRecommendationPreferencesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetRecommendationPreferencesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecommendationPreferencesDetail> recommendationPreferencesDetails() {
        Function<GetRecommendationPreferencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommendationPreferencesDetails() != null) {
                return response.recommendationPreferencesDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetRecommendationPreferencesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetRecommendationPreferencesResponseFetcher
    implements AsyncPageFetcher<GetRecommendationPreferencesResponse> {
        private GetRecommendationPreferencesResponseFetcher() {
        }

        public boolean hasNextPage(GetRecommendationPreferencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetRecommendationPreferencesResponse> nextPage(GetRecommendationPreferencesResponse previousPage) {
            if (previousPage == null) {
                return GetRecommendationPreferencesPublisher.this.client.getRecommendationPreferences(GetRecommendationPreferencesPublisher.this.firstRequest);
            }
            return GetRecommendationPreferencesPublisher.this.client.getRecommendationPreferences((GetRecommendationPreferencesRequest)((Object)GetRecommendationPreferencesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

