/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InferredWorkloadType {
    AMAZON_EMR("AmazonEmr"),
    APACHE_CASSANDRA("ApacheCassandra"),
    APACHE_HADOOP("ApacheHadoop"),
    MEMCACHED("Memcached"),
    NGINX("Nginx"),
    POSTGRE_SQL("PostgreSql"),
    REDIS("Redis"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InferredWorkloadType> VALUE_MAP;
    private final String value;

    private InferredWorkloadType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InferredWorkloadType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InferredWorkloadType> knownValues() {
        EnumSet<InferredWorkloadType> knownValues = EnumSet.allOf(InferredWorkloadType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InferredWorkloadType.class, InferredWorkloadType::toString);
    }
}

