/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerResponse;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationSummariesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecommendationSummariesResponse
extends ComputeOptimizerResponse
implements ToCopyableBuilder<Builder, GetRecommendationSummariesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetRecommendationSummariesResponse.getter(GetRecommendationSummariesResponse::nextToken)).setter(GetRecommendationSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<RecommendationSummary>> RECOMMENDATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendationSummaries").getter(GetRecommendationSummariesResponse.getter(GetRecommendationSummariesResponse::recommendationSummaries)).setter(GetRecommendationSummariesResponse.setter(Builder::recommendationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RECOMMENDATION_SUMMARIES_FIELD));
    private final String nextToken;
    private final List<RecommendationSummary> recommendationSummaries;

    private GetRecommendationSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.recommendationSummaries = builder.recommendationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRecommendationSummaries() {
        return this.recommendationSummaries != null && !(this.recommendationSummaries instanceof SdkAutoConstructList);
    }

    public final List<RecommendationSummary> recommendationSummaries() {
        return this.recommendationSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationSummaries() ? this.recommendationSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommendationSummariesResponse)) {
            return false;
        }
        GetRecommendationSummariesResponse other = (GetRecommendationSummariesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRecommendationSummaries() == other.hasRecommendationSummaries() && Objects.equals(this.recommendationSummaries(), other.recommendationSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"GetRecommendationSummariesResponse").add("NextToken", (Object)this.nextToken()).add("RecommendationSummaries", this.hasRecommendationSummaries() ? this.recommendationSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "recommendationSummaries": {
                return Optional.ofNullable(clazz.cast(this.recommendationSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecommendationSummariesResponse, T> g) {
        return obj -> g.apply((GetRecommendationSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RecommendationSummary> recommendationSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommendationSummariesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.recommendationSummaries(model.recommendationSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<RecommendationSummary.Builder> getRecommendationSummaries() {
            if (this.recommendationSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendationSummaries != null ? (Collection)this.recommendationSummaries.stream().map(RecommendationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recommendationSummaries(Collection<RecommendationSummary> recommendationSummaries) {
            this.recommendationSummaries = RecommendationSummariesCopier.copy(recommendationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationSummaries(RecommendationSummary ... recommendationSummaries) {
            this.recommendationSummaries(Arrays.asList(recommendationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationSummaries(Consumer<RecommendationSummary.Builder> ... recommendationSummaries) {
            this.recommendationSummaries(Stream.of(recommendationSummaries).map(c -> (RecommendationSummary)((RecommendationSummary.Builder)RecommendationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecommendationSummaries(Collection<RecommendationSummary.BuilderImpl> recommendationSummaries) {
            this.recommendationSummaries = RecommendationSummariesCopier.copyFromBuilder(recommendationSummaries);
        }

        @Override
        public GetRecommendationSummariesResponse build() {
            return new GetRecommendationSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComputeOptimizerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecommendationSummariesResponse> {
        public Builder nextToken(String var1);

        public Builder recommendationSummaries(Collection<RecommendationSummary> var1);

        public Builder recommendationSummaries(RecommendationSummary ... var1);

        public Builder recommendationSummaries(Consumer<RecommendationSummary.Builder> ... var1);
    }
}

