/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.Finding;
import software.amazon.awssdk.services.computeoptimizer.model.ReasonCodeSummariesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.ReasonCodeSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Summary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Summary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Summary.getter(Summary::nameAsString)).setter(Summary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Double> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("value").getter(Summary.getter(Summary::value)).setter(Summary.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<List<ReasonCodeSummary>> REASON_CODE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reasonCodeSummaries").getter(Summary.getter(Summary::reasonCodeSummaries)).setter(Summary.setter(Builder::reasonCodeSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasonCodeSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReasonCodeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD, REASON_CODE_SUMMARIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Double value;
    private final List<ReasonCodeSummary> reasonCodeSummaries;

    private Summary(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.reasonCodeSummaries = builder.reasonCodeSummaries;
    }

    public final Finding name() {
        return Finding.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final Double value() {
        return this.value;
    }

    public final boolean hasReasonCodeSummaries() {
        return this.reasonCodeSummaries != null && !(this.reasonCodeSummaries instanceof SdkAutoConstructList);
    }

    public final List<ReasonCodeSummary> reasonCodeSummaries() {
        return this.reasonCodeSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReasonCodeSummaries() ? this.reasonCodeSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Summary)) {
            return false;
        }
        Summary other = (Summary)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.value(), other.value()) && this.hasReasonCodeSummaries() == other.hasReasonCodeSummaries() && Objects.equals(this.reasonCodeSummaries(), other.reasonCodeSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"Summary").add("Name", (Object)this.nameAsString()).add("Value", (Object)this.value()).add("ReasonCodeSummaries", this.hasReasonCodeSummaries() ? this.reasonCodeSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "reasonCodeSummaries": {
                return Optional.ofNullable(clazz.cast(this.reasonCodeSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Summary, T> g) {
        return obj -> g.apply((Summary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Double value;
        private List<ReasonCodeSummary> reasonCodeSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Summary model) {
            this.name(model.name);
            this.value(model.value);
            this.reasonCodeSummaries(model.reasonCodeSummaries);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(Finding name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Double getValue() {
            return this.value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        public final Collection<ReasonCodeSummary.Builder> getReasonCodeSummaries() {
            if (this.reasonCodeSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reasonCodeSummaries != null ? (Collection)this.reasonCodeSummaries.stream().map(ReasonCodeSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reasonCodeSummaries(Collection<ReasonCodeSummary> reasonCodeSummaries) {
            this.reasonCodeSummaries = ReasonCodeSummariesCopier.copy(reasonCodeSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonCodeSummaries(ReasonCodeSummary ... reasonCodeSummaries) {
            this.reasonCodeSummaries(Arrays.asList(reasonCodeSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonCodeSummaries(Consumer<ReasonCodeSummary.Builder> ... reasonCodeSummaries) {
            this.reasonCodeSummaries(Stream.of(reasonCodeSummaries).map(c -> (ReasonCodeSummary)((ReasonCodeSummary.Builder)ReasonCodeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReasonCodeSummaries(Collection<ReasonCodeSummary.BuilderImpl> reasonCodeSummaries) {
            this.reasonCodeSummaries = ReasonCodeSummariesCopier.copyFromBuilder(reasonCodeSummaries);
        }

        public Summary build() {
            return new Summary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Summary> {
        public Builder name(String var1);

        public Builder name(Finding var1);

        public Builder value(Double var1);

        public Builder reasonCodeSummaries(Collection<ReasonCodeSummary> var1);

        public Builder reasonCodeSummaries(ReasonCodeSummary ... var1);

        public Builder reasonCodeSummaries(Consumer<ReasonCodeSummary.Builder> ... var1);
    }
}

