/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerResponse;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationExportJob;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationExportJobsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRecommendationExportJobsResponse
extends ComputeOptimizerResponse
implements ToCopyableBuilder<Builder, DescribeRecommendationExportJobsResponse> {
    private static final SdkField<List<RecommendationExportJob>> RECOMMENDATION_EXPORT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendationExportJobs").getter(DescribeRecommendationExportJobsResponse.getter(DescribeRecommendationExportJobsResponse::recommendationExportJobs)).setter(DescribeRecommendationExportJobsResponse.setter(Builder::recommendationExportJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationExportJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationExportJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeRecommendationExportJobsResponse.getter(DescribeRecommendationExportJobsResponse::nextToken)).setter(DescribeRecommendationExportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_EXPORT_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private final List<RecommendationExportJob> recommendationExportJobs;
    private final String nextToken;

    private DescribeRecommendationExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.recommendationExportJobs = builder.recommendationExportJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRecommendationExportJobs() {
        return this.recommendationExportJobs != null && !(this.recommendationExportJobs instanceof SdkAutoConstructList);
    }

    public final List<RecommendationExportJob> recommendationExportJobs() {
        return this.recommendationExportJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationExportJobs() ? this.recommendationExportJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecommendationExportJobsResponse)) {
            return false;
        }
        DescribeRecommendationExportJobsResponse other = (DescribeRecommendationExportJobsResponse)((Object)obj);
        return this.hasRecommendationExportJobs() == other.hasRecommendationExportJobs() && Objects.equals(this.recommendationExportJobs(), other.recommendationExportJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRecommendationExportJobsResponse").add("RecommendationExportJobs", this.hasRecommendationExportJobs() ? this.recommendationExportJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recommendationExportJobs": {
                return Optional.ofNullable(clazz.cast(this.recommendationExportJobs()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecommendationExportJobsResponse, T> g) {
        return obj -> g.apply((DescribeRecommendationExportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerResponse.BuilderImpl
    implements Builder {
        private List<RecommendationExportJob> recommendationExportJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecommendationExportJobsResponse model) {
            super(model);
            this.recommendationExportJobs(model.recommendationExportJobs);
            this.nextToken(model.nextToken);
        }

        public final Collection<RecommendationExportJob.Builder> getRecommendationExportJobs() {
            if (this.recommendationExportJobs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendationExportJobs != null ? (Collection)this.recommendationExportJobs.stream().map(RecommendationExportJob::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recommendationExportJobs(Collection<RecommendationExportJob> recommendationExportJobs) {
            this.recommendationExportJobs = RecommendationExportJobsCopier.copy(recommendationExportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationExportJobs(RecommendationExportJob ... recommendationExportJobs) {
            this.recommendationExportJobs(Arrays.asList(recommendationExportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationExportJobs(Consumer<RecommendationExportJob.Builder> ... recommendationExportJobs) {
            this.recommendationExportJobs(Stream.of(recommendationExportJobs).map(c -> (RecommendationExportJob)((RecommendationExportJob.Builder)RecommendationExportJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecommendationExportJobs(Collection<RecommendationExportJob.BuilderImpl> recommendationExportJobs) {
            this.recommendationExportJobs = RecommendationExportJobsCopier.copyFromBuilder(recommendationExportJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeRecommendationExportJobsResponse build() {
            return new DescribeRecommendationExportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComputeOptimizerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRecommendationExportJobsResponse> {
        public Builder recommendationExportJobs(Collection<RecommendationExportJob> var1);

        public Builder recommendationExportJobs(RecommendationExportJob ... var1);

        public Builder recommendationExportJobs(Consumer<RecommendationExportJob.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

