/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.ComputeOptimizerResponse;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationError;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationErrorsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendation;
import software.amazon.awssdk.services.computeoptimizer.model.VolumeRecommendationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEbsVolumeRecommendationsResponse
extends ComputeOptimizerResponse
implements ToCopyableBuilder<Builder, GetEbsVolumeRecommendationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetEbsVolumeRecommendationsResponse.getter(GetEbsVolumeRecommendationsResponse::nextToken)).setter(GetEbsVolumeRecommendationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<VolumeRecommendation>> VOLUME_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumeRecommendations").getter(GetEbsVolumeRecommendationsResponse.getter(GetEbsVolumeRecommendationsResponse::volumeRecommendations)).setter(GetEbsVolumeRecommendationsResponse.setter(Builder::volumeRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VolumeRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GetRecommendationError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(GetEbsVolumeRecommendationsResponse.getter(GetEbsVolumeRecommendationsResponse::errors)).setter(GetEbsVolumeRecommendationsResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetRecommendationError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, VOLUME_RECOMMENDATIONS_FIELD, ERRORS_FIELD));
    private final String nextToken;
    private final List<VolumeRecommendation> volumeRecommendations;
    private final List<GetRecommendationError> errors;

    private GetEbsVolumeRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.volumeRecommendations = builder.volumeRecommendations;
        this.errors = builder.errors;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasVolumeRecommendations() {
        return this.volumeRecommendations != null && !(this.volumeRecommendations instanceof SdkAutoConstructList);
    }

    public List<VolumeRecommendation> volumeRecommendations() {
        return this.volumeRecommendations;
    }

    public boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public List<GetRecommendationError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumeRecommendations() ? this.volumeRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEbsVolumeRecommendationsResponse)) {
            return false;
        }
        GetEbsVolumeRecommendationsResponse other = (GetEbsVolumeRecommendationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasVolumeRecommendations() == other.hasVolumeRecommendations() && Objects.equals(this.volumeRecommendations(), other.volumeRecommendations()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public String toString() {
        return ToString.builder((String)"GetEbsVolumeRecommendationsResponse").add("NextToken", (Object)this.nextToken()).add("VolumeRecommendations", this.hasVolumeRecommendations() ? this.volumeRecommendations() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "volumeRecommendations": {
                return Optional.ofNullable(clazz.cast(this.volumeRecommendations()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEbsVolumeRecommendationsResponse, T> g) {
        return obj -> g.apply((GetEbsVolumeRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VolumeRecommendation> volumeRecommendations = DefaultSdkAutoConstructList.getInstance();
        private List<GetRecommendationError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEbsVolumeRecommendationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.volumeRecommendations(model.volumeRecommendations);
            this.errors(model.errors);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VolumeRecommendation.Builder> getVolumeRecommendations() {
            if (this.volumeRecommendations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.volumeRecommendations != null ? (Collection)this.volumeRecommendations.stream().map(VolumeRecommendation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumeRecommendations(Collection<VolumeRecommendation> volumeRecommendations) {
            this.volumeRecommendations = VolumeRecommendationsCopier.copy(volumeRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeRecommendations(VolumeRecommendation ... volumeRecommendations) {
            this.volumeRecommendations(Arrays.asList(volumeRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeRecommendations(Consumer<VolumeRecommendation.Builder> ... volumeRecommendations) {
            this.volumeRecommendations(Stream.of(volumeRecommendations).map(c -> (VolumeRecommendation)((VolumeRecommendation.Builder)VolumeRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVolumeRecommendations(Collection<VolumeRecommendation.BuilderImpl> volumeRecommendations) {
            this.volumeRecommendations = VolumeRecommendationsCopier.copyFromBuilder(volumeRecommendations);
        }

        public final Collection<GetRecommendationError.Builder> getErrors() {
            if (this.errors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.errors != null ? (Collection)this.errors.stream().map(GetRecommendationError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<GetRecommendationError> errors) {
            this.errors = GetRecommendationErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(GetRecommendationError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<GetRecommendationError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (GetRecommendationError)((GetRecommendationError.Builder)GetRecommendationError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<GetRecommendationError.BuilderImpl> errors) {
            this.errors = GetRecommendationErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public GetEbsVolumeRecommendationsResponse build() {
            return new GetEbsVolumeRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComputeOptimizerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEbsVolumeRecommendationsResponse> {
        public Builder nextToken(String var1);

        public Builder volumeRecommendations(Collection<VolumeRecommendation> var1);

        public Builder volumeRecommendations(VolumeRecommendation ... var1);

        public Builder volumeRecommendations(Consumer<VolumeRecommendation.Builder> ... var1);

        public Builder errors(Collection<GetRecommendationError> var1);

        public Builder errors(GetRecommendationError ... var1);

        public Builder errors(Consumer<GetRecommendationError.Builder> ... var1);
    }
}

