/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupConfiguration;
import software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendationOption;
import software.amazon.awssdk.services.computeoptimizer.model.AutoScalingGroupRecommendationOptionsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.Finding;
import software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetric;
import software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetricsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingGroupRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingGroupRecommendation> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::accountId)).setter(AutoScalingGroupRecommendation.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::autoScalingGroupArn)).setter(AutoScalingGroupRecommendation.setter(Builder::autoScalingGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupArn").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::autoScalingGroupName)).setter(AutoScalingGroupRecommendation.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroupName").build()}).build();
    private static final SdkField<String> FINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::findingAsString)).setter(AutoScalingGroupRecommendation.setter(Builder::finding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finding").build()}).build();
    private static final SdkField<List<UtilizationMetric>> UTILIZATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::utilizationMetrics)).setter(AutoScalingGroupRecommendation.setter(Builder::utilizationMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utilizationMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UtilizationMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> LOOK_BACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::lookBackPeriodInDays)).setter(AutoScalingGroupRecommendation.setter(Builder::lookBackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookBackPeriodInDays").build()}).build();
    private static final SdkField<AutoScalingGroupConfiguration> CURRENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::currentConfiguration)).setter(AutoScalingGroupRecommendation.setter(Builder::currentConfiguration)).constructor(AutoScalingGroupConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentConfiguration").build()}).build();
    private static final SdkField<List<AutoScalingGroupRecommendationOption>> RECOMMENDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::recommendationOptions)).setter(AutoScalingGroupRecommendation.setter(Builder::recommendationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoScalingGroupRecommendationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_REFRESH_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AutoScalingGroupRecommendation.getter(AutoScalingGroupRecommendation::lastRefreshTimestamp)).setter(AutoScalingGroupRecommendation.setter(Builder::lastRefreshTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRefreshTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, AUTO_SCALING_GROUP_ARN_FIELD, AUTO_SCALING_GROUP_NAME_FIELD, FINDING_FIELD, UTILIZATION_METRICS_FIELD, LOOK_BACK_PERIOD_IN_DAYS_FIELD, CURRENT_CONFIGURATION_FIELD, RECOMMENDATION_OPTIONS_FIELD, LAST_REFRESH_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String autoScalingGroupArn;
    private final String autoScalingGroupName;
    private final String finding;
    private final List<UtilizationMetric> utilizationMetrics;
    private final Double lookBackPeriodInDays;
    private final AutoScalingGroupConfiguration currentConfiguration;
    private final List<AutoScalingGroupRecommendationOption> recommendationOptions;
    private final Instant lastRefreshTimestamp;

    private AutoScalingGroupRecommendation(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.autoScalingGroupArn = builder.autoScalingGroupArn;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.finding = builder.finding;
        this.utilizationMetrics = builder.utilizationMetrics;
        this.lookBackPeriodInDays = builder.lookBackPeriodInDays;
        this.currentConfiguration = builder.currentConfiguration;
        this.recommendationOptions = builder.recommendationOptions;
        this.lastRefreshTimestamp = builder.lastRefreshTimestamp;
    }

    public String accountId() {
        return this.accountId;
    }

    public String autoScalingGroupArn() {
        return this.autoScalingGroupArn;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public Finding finding() {
        return Finding.fromValue(this.finding);
    }

    public String findingAsString() {
        return this.finding;
    }

    public boolean hasUtilizationMetrics() {
        return this.utilizationMetrics != null && !(this.utilizationMetrics instanceof SdkAutoConstructList);
    }

    public List<UtilizationMetric> utilizationMetrics() {
        return this.utilizationMetrics;
    }

    public Double lookBackPeriodInDays() {
        return this.lookBackPeriodInDays;
    }

    public AutoScalingGroupConfiguration currentConfiguration() {
        return this.currentConfiguration;
    }

    public boolean hasRecommendationOptions() {
        return this.recommendationOptions != null && !(this.recommendationOptions instanceof SdkAutoConstructList);
    }

    public List<AutoScalingGroupRecommendationOption> recommendationOptions() {
        return this.recommendationOptions;
    }

    public Instant lastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.utilizationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookBackPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRefreshTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroupRecommendation)) {
            return false;
        }
        AutoScalingGroupRecommendation other = (AutoScalingGroupRecommendation)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.autoScalingGroupArn(), other.autoScalingGroupArn()) && Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.findingAsString(), other.findingAsString()) && Objects.equals(this.utilizationMetrics(), other.utilizationMetrics()) && Objects.equals(this.lookBackPeriodInDays(), other.lookBackPeriodInDays()) && Objects.equals(this.currentConfiguration(), other.currentConfiguration()) && Objects.equals(this.recommendationOptions(), other.recommendationOptions()) && Objects.equals(this.lastRefreshTimestamp(), other.lastRefreshTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"AutoScalingGroupRecommendation").add("AccountId", (Object)this.accountId()).add("AutoScalingGroupArn", (Object)this.autoScalingGroupArn()).add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("Finding", (Object)this.findingAsString()).add("UtilizationMetrics", this.utilizationMetrics()).add("LookBackPeriodInDays", (Object)this.lookBackPeriodInDays()).add("CurrentConfiguration", (Object)this.currentConfiguration()).add("RecommendationOptions", this.recommendationOptions()).add("LastRefreshTimestamp", (Object)this.lastRefreshTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "autoScalingGroupArn": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupArn()));
            }
            case "autoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "finding": {
                return Optional.ofNullable(clazz.cast(this.findingAsString()));
            }
            case "utilizationMetrics": {
                return Optional.ofNullable(clazz.cast(this.utilizationMetrics()));
            }
            case "lookBackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookBackPeriodInDays()));
            }
            case "currentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.currentConfiguration()));
            }
            case "recommendationOptions": {
                return Optional.ofNullable(clazz.cast(this.recommendationOptions()));
            }
            case "lastRefreshTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastRefreshTimestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroupRecommendation, T> g) {
        return obj -> g.apply((AutoScalingGroupRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String autoScalingGroupArn;
        private String autoScalingGroupName;
        private String finding;
        private List<UtilizationMetric> utilizationMetrics = DefaultSdkAutoConstructList.getInstance();
        private Double lookBackPeriodInDays;
        private AutoScalingGroupConfiguration currentConfiguration;
        private List<AutoScalingGroupRecommendationOption> recommendationOptions = DefaultSdkAutoConstructList.getInstance();
        private Instant lastRefreshTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroupRecommendation model) {
            this.accountId(model.accountId);
            this.autoScalingGroupArn(model.autoScalingGroupArn);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.finding(model.finding);
            this.utilizationMetrics(model.utilizationMetrics);
            this.lookBackPeriodInDays(model.lookBackPeriodInDays);
            this.currentConfiguration(model.currentConfiguration);
            this.recommendationOptions(model.recommendationOptions);
            this.lastRefreshTimestamp(model.lastRefreshTimestamp);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getAutoScalingGroupArn() {
            return this.autoScalingGroupArn;
        }

        @Override
        public final Builder autoScalingGroupArn(String autoScalingGroupArn) {
            this.autoScalingGroupArn = autoScalingGroupArn;
            return this;
        }

        public final void setAutoScalingGroupArn(String autoScalingGroupArn) {
            this.autoScalingGroupArn = autoScalingGroupArn;
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getFinding() {
            return this.finding;
        }

        @Override
        public final Builder finding(String finding) {
            this.finding = finding;
            return this;
        }

        @Override
        public final Builder finding(Finding finding) {
            this.finding(finding == null ? null : finding.toString());
            return this;
        }

        public final void setFinding(String finding) {
            this.finding = finding;
        }

        public final Collection<UtilizationMetric.Builder> getUtilizationMetrics() {
            return this.utilizationMetrics != null ? (Collection)this.utilizationMetrics.stream().map(UtilizationMetric::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder utilizationMetrics(Collection<UtilizationMetric> utilizationMetrics) {
            this.utilizationMetrics = UtilizationMetricsCopier.copy(utilizationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(UtilizationMetric ... utilizationMetrics) {
            this.utilizationMetrics(Arrays.asList(utilizationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(Consumer<UtilizationMetric.Builder> ... utilizationMetrics) {
            this.utilizationMetrics(Stream.of(utilizationMetrics).map(c -> (UtilizationMetric)((UtilizationMetric.Builder)UtilizationMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUtilizationMetrics(Collection<UtilizationMetric.BuilderImpl> utilizationMetrics) {
            this.utilizationMetrics = UtilizationMetricsCopier.copyFromBuilder(utilizationMetrics);
        }

        public final Double getLookBackPeriodInDays() {
            return this.lookBackPeriodInDays;
        }

        @Override
        public final Builder lookBackPeriodInDays(Double lookBackPeriodInDays) {
            this.lookBackPeriodInDays = lookBackPeriodInDays;
            return this;
        }

        public final void setLookBackPeriodInDays(Double lookBackPeriodInDays) {
            this.lookBackPeriodInDays = lookBackPeriodInDays;
        }

        public final AutoScalingGroupConfiguration.Builder getCurrentConfiguration() {
            return this.currentConfiguration != null ? this.currentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder currentConfiguration(AutoScalingGroupConfiguration currentConfiguration) {
            this.currentConfiguration = currentConfiguration;
            return this;
        }

        public final void setCurrentConfiguration(AutoScalingGroupConfiguration.BuilderImpl currentConfiguration) {
            this.currentConfiguration = currentConfiguration != null ? currentConfiguration.build() : null;
        }

        public final Collection<AutoScalingGroupRecommendationOption.Builder> getRecommendationOptions() {
            return this.recommendationOptions != null ? (Collection)this.recommendationOptions.stream().map(AutoScalingGroupRecommendationOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recommendationOptions(Collection<AutoScalingGroupRecommendationOption> recommendationOptions) {
            this.recommendationOptions = AutoScalingGroupRecommendationOptionsCopier.copy(recommendationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationOptions(AutoScalingGroupRecommendationOption ... recommendationOptions) {
            this.recommendationOptions(Arrays.asList(recommendationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationOptions(Consumer<AutoScalingGroupRecommendationOption.Builder> ... recommendationOptions) {
            this.recommendationOptions(Stream.of(recommendationOptions).map(c -> (AutoScalingGroupRecommendationOption)((AutoScalingGroupRecommendationOption.Builder)AutoScalingGroupRecommendationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecommendationOptions(Collection<AutoScalingGroupRecommendationOption.BuilderImpl> recommendationOptions) {
            this.recommendationOptions = AutoScalingGroupRecommendationOptionsCopier.copyFromBuilder(recommendationOptions);
        }

        public final Instant getLastRefreshTimestamp() {
            return this.lastRefreshTimestamp;
        }

        @Override
        public final Builder lastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
            return this;
        }

        public final void setLastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
        }

        public AutoScalingGroupRecommendation build() {
            return new AutoScalingGroupRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingGroupRecommendation> {
        public Builder accountId(String var1);

        public Builder autoScalingGroupArn(String var1);

        public Builder autoScalingGroupName(String var1);

        public Builder finding(String var1);

        public Builder finding(Finding var1);

        public Builder utilizationMetrics(Collection<UtilizationMetric> var1);

        public Builder utilizationMetrics(UtilizationMetric ... var1);

        public Builder utilizationMetrics(Consumer<UtilizationMetric.Builder> ... var1);

        public Builder lookBackPeriodInDays(Double var1);

        public Builder currentConfiguration(AutoScalingGroupConfiguration var1);

        default public Builder currentConfiguration(Consumer<AutoScalingGroupConfiguration.Builder> currentConfiguration) {
            return this.currentConfiguration((AutoScalingGroupConfiguration)((AutoScalingGroupConfiguration.Builder)AutoScalingGroupConfiguration.builder().applyMutation(currentConfiguration)).build());
        }

        public Builder recommendationOptions(Collection<AutoScalingGroupRecommendationOption> var1);

        public Builder recommendationOptions(AutoScalingGroupRecommendationOption ... var1);

        public Builder recommendationOptions(Consumer<AutoScalingGroupRecommendationOption.Builder> ... var1);

        public Builder lastRefreshTimestamp(Instant var1);
    }
}

