/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the source of a recommendation, such as an Amazon EC2 instance or Auto Scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationSource implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationSource.Builder, RecommendationSource> {
    private static final SdkField<String> RECOMMENDATION_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecommendationSource::recommendationSourceArn)).setter(setter(Builder::recommendationSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationSourceArn").build())
            .build();

    private static final SdkField<String> RECOMMENDATION_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecommendationSource::recommendationSourceTypeAsString))
            .setter(setter(Builder::recommendationSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationSourceType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RECOMMENDATION_SOURCE_ARN_FIELD, RECOMMENDATION_SOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recommendationSourceArn;

    private final String recommendationSourceType;

    private RecommendationSource(BuilderImpl builder) {
        this.recommendationSourceArn = builder.recommendationSourceArn;
        this.recommendationSourceType = builder.recommendationSourceType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the recommendation source.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the recommendation source.
     */
    public String recommendationSourceArn() {
        return recommendationSourceArn;
    }

    /**
     * <p>
     * The resource type of the recommendation source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationSourceType} will return {@link RecommendationSourceType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #recommendationSourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the recommendation source.
     * @see RecommendationSourceType
     */
    public RecommendationSourceType recommendationSourceType() {
        return RecommendationSourceType.fromValue(recommendationSourceType);
    }

    /**
     * <p>
     * The resource type of the recommendation source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationSourceType} will return {@link RecommendationSourceType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #recommendationSourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the recommendation source.
     * @see RecommendationSourceType
     */
    public String recommendationSourceTypeAsString() {
        return recommendationSourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommendationSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationSourceTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSource)) {
            return false;
        }
        RecommendationSource other = (RecommendationSource) obj;
        return Objects.equals(recommendationSourceArn(), other.recommendationSourceArn())
                && Objects.equals(recommendationSourceTypeAsString(), other.recommendationSourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RecommendationSource").add("RecommendationSourceArn", recommendationSourceArn())
                .add("RecommendationSourceType", recommendationSourceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recommendationSourceArn":
            return Optional.ofNullable(clazz.cast(recommendationSourceArn()));
        case "recommendationSourceType":
            return Optional.ofNullable(clazz.cast(recommendationSourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationSource, T> g) {
        return obj -> g.apply((RecommendationSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationSource> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the recommendation source.
         * </p>
         * 
         * @param recommendationSourceArn
         *        The Amazon Resource Name (ARN) of the recommendation source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationSourceArn(String recommendationSourceArn);

        /**
         * <p>
         * The resource type of the recommendation source.
         * </p>
         * 
         * @param recommendationSourceType
         *        The resource type of the recommendation source.
         * @see RecommendationSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationSourceType
         */
        Builder recommendationSourceType(String recommendationSourceType);

        /**
         * <p>
         * The resource type of the recommendation source.
         * </p>
         * 
         * @param recommendationSourceType
         *        The resource type of the recommendation source.
         * @see RecommendationSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationSourceType
         */
        Builder recommendationSourceType(RecommendationSourceType recommendationSourceType);
    }

    static final class BuilderImpl implements Builder {
        private String recommendationSourceArn;

        private String recommendationSourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationSource model) {
            recommendationSourceArn(model.recommendationSourceArn);
            recommendationSourceType(model.recommendationSourceType);
        }

        public final String getRecommendationSourceArn() {
            return recommendationSourceArn;
        }

        @Override
        public final Builder recommendationSourceArn(String recommendationSourceArn) {
            this.recommendationSourceArn = recommendationSourceArn;
            return this;
        }

        public final void setRecommendationSourceArn(String recommendationSourceArn) {
            this.recommendationSourceArn = recommendationSourceArn;
        }

        public final String getRecommendationSourceTypeAsString() {
            return recommendationSourceType;
        }

        @Override
        public final Builder recommendationSourceType(String recommendationSourceType) {
            this.recommendationSourceType = recommendationSourceType;
            return this;
        }

        @Override
        public final Builder recommendationSourceType(RecommendationSourceType recommendationSourceType) {
            this.recommendationSourceType(recommendationSourceType == null ? null : recommendationSourceType.toString());
            return this;
        }

        public final void setRecommendationSourceType(String recommendationSourceType) {
            this.recommendationSourceType = recommendationSourceType;
        }

        @Override
        public RecommendationSource build() {
            return new RecommendationSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
