/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEc2RecommendationProjectedMetricsResponse extends ComputeOptimizerResponse implements
        ToCopyableBuilder<GetEc2RecommendationProjectedMetricsResponse.Builder, GetEc2RecommendationProjectedMetricsResponse> {
    private static final SdkField<List<RecommendedOptionProjectedMetric>> RECOMMENDED_OPTION_PROJECTED_METRICS_FIELD = SdkField
            .<List<RecommendedOptionProjectedMetric>> builder(MarshallingType.LIST)
            .getter(getter(GetEc2RecommendationProjectedMetricsResponse::recommendedOptionProjectedMetrics))
            .setter(setter(Builder::recommendedOptionProjectedMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedOptionProjectedMetrics")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendedOptionProjectedMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendedOptionProjectedMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RECOMMENDED_OPTION_PROJECTED_METRICS_FIELD));

    private final List<RecommendedOptionProjectedMetric> recommendedOptionProjectedMetrics;

    private GetEc2RecommendationProjectedMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.recommendedOptionProjectedMetrics = builder.recommendedOptionProjectedMetrics;
    }

    /**
     * Returns true if the RecommendedOptionProjectedMetrics property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasRecommendedOptionProjectedMetrics() {
        return recommendedOptionProjectedMetrics != null && !(recommendedOptionProjectedMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe a projected metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecommendedOptionProjectedMetrics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that describe a projected metrics.
     */
    public List<RecommendedOptionProjectedMetric> recommendedOptionProjectedMetrics() {
        return recommendedOptionProjectedMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recommendedOptionProjectedMetrics());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEc2RecommendationProjectedMetricsResponse)) {
            return false;
        }
        GetEc2RecommendationProjectedMetricsResponse other = (GetEc2RecommendationProjectedMetricsResponse) obj;
        return Objects.equals(recommendedOptionProjectedMetrics(), other.recommendedOptionProjectedMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetEc2RecommendationProjectedMetricsResponse")
                .add("RecommendedOptionProjectedMetrics", recommendedOptionProjectedMetrics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recommendedOptionProjectedMetrics":
            return Optional.ofNullable(clazz.cast(recommendedOptionProjectedMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEc2RecommendationProjectedMetricsResponse, T> g) {
        return obj -> g.apply((GetEc2RecommendationProjectedMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComputeOptimizerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEc2RecommendationProjectedMetricsResponse> {
        /**
         * <p>
         * An array of objects that describe a projected metrics.
         * </p>
         * 
         * @param recommendedOptionProjectedMetrics
         *        An array of objects that describe a projected metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedOptionProjectedMetrics(Collection<RecommendedOptionProjectedMetric> recommendedOptionProjectedMetrics);

        /**
         * <p>
         * An array of objects that describe a projected metrics.
         * </p>
         * 
         * @param recommendedOptionProjectedMetrics
         *        An array of objects that describe a projected metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedOptionProjectedMetrics(RecommendedOptionProjectedMetric... recommendedOptionProjectedMetrics);

        /**
         * <p>
         * An array of objects that describe a projected metrics.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RecommendedOptionProjectedMetric>.Builder}
         * avoiding the need to create one manually via {@link List<RecommendedOptionProjectedMetric>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecommendedOptionProjectedMetric>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #recommendedOptionProjectedMetrics(List<RecommendedOptionProjectedMetric>)}.
         * 
         * @param recommendedOptionProjectedMetrics
         *        a consumer that will call methods on {@link List<RecommendedOptionProjectedMetric>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendedOptionProjectedMetrics(List<RecommendedOptionProjectedMetric>)
         */
        Builder recommendedOptionProjectedMetrics(
                Consumer<RecommendedOptionProjectedMetric.Builder>... recommendedOptionProjectedMetrics);
    }

    static final class BuilderImpl extends ComputeOptimizerResponse.BuilderImpl implements Builder {
        private List<RecommendedOptionProjectedMetric> recommendedOptionProjectedMetrics = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEc2RecommendationProjectedMetricsResponse model) {
            super(model);
            recommendedOptionProjectedMetrics(model.recommendedOptionProjectedMetrics);
        }

        public final Collection<RecommendedOptionProjectedMetric.Builder> getRecommendedOptionProjectedMetrics() {
            return recommendedOptionProjectedMetrics != null ? recommendedOptionProjectedMetrics.stream()
                    .map(RecommendedOptionProjectedMetric::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recommendedOptionProjectedMetrics(
                Collection<RecommendedOptionProjectedMetric> recommendedOptionProjectedMetrics) {
            this.recommendedOptionProjectedMetrics = RecommendedOptionProjectedMetricsCopier
                    .copy(recommendedOptionProjectedMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedOptionProjectedMetrics(
                RecommendedOptionProjectedMetric... recommendedOptionProjectedMetrics) {
            recommendedOptionProjectedMetrics(Arrays.asList(recommendedOptionProjectedMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedOptionProjectedMetrics(
                Consumer<RecommendedOptionProjectedMetric.Builder>... recommendedOptionProjectedMetrics) {
            recommendedOptionProjectedMetrics(Stream.of(recommendedOptionProjectedMetrics)
                    .map(c -> RecommendedOptionProjectedMetric.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecommendedOptionProjectedMetrics(
                Collection<RecommendedOptionProjectedMetric.BuilderImpl> recommendedOptionProjectedMetrics) {
            this.recommendedOptionProjectedMetrics = RecommendedOptionProjectedMetricsCopier
                    .copyFromBuilder(recommendedOptionProjectedMetrics);
        }

        @Override
        public GetEc2RecommendationProjectedMetricsResponse build() {
            return new GetEc2RecommendationProjectedMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
