/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.Finding;
import software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationOption;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationOptionsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationSource;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourcesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetric;
import software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetricsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceRecommendation> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceRecommendation.getter(InstanceRecommendation::instanceArn)).setter(InstanceRecommendation.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceRecommendation.getter(InstanceRecommendation::accountId)).setter(InstanceRecommendation.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceRecommendation.getter(InstanceRecommendation::instanceName)).setter(InstanceRecommendation.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()}).build();
    private static final SdkField<String> CURRENT_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceRecommendation.getter(InstanceRecommendation::currentInstanceType)).setter(InstanceRecommendation.setter(Builder::currentInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentInstanceType").build()}).build();
    private static final SdkField<String> FINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceRecommendation.getter(InstanceRecommendation::findingAsString)).setter(InstanceRecommendation.setter(Builder::finding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finding").build()}).build();
    private static final SdkField<List<UtilizationMetric>> UTILIZATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InstanceRecommendation.getter(InstanceRecommendation::utilizationMetrics)).setter(InstanceRecommendation.setter(Builder::utilizationMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utilizationMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UtilizationMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> LOOK_BACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(InstanceRecommendation.getter(InstanceRecommendation::lookBackPeriodInDays)).setter(InstanceRecommendation.setter(Builder::lookBackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookBackPeriodInDays").build()}).build();
    private static final SdkField<List<InstanceRecommendationOption>> RECOMMENDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InstanceRecommendation.getter(InstanceRecommendation::recommendationOptions)).setter(InstanceRecommendation.setter(Builder::recommendationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceRecommendationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RecommendationSource>> RECOMMENDATION_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InstanceRecommendation.getter(InstanceRecommendation::recommendationSources)).setter(InstanceRecommendation.setter(Builder::recommendationSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_REFRESH_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(InstanceRecommendation.getter(InstanceRecommendation::lastRefreshTimestamp)).setter(InstanceRecommendation.setter(Builder::lastRefreshTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRefreshTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD, ACCOUNT_ID_FIELD, INSTANCE_NAME_FIELD, CURRENT_INSTANCE_TYPE_FIELD, FINDING_FIELD, UTILIZATION_METRICS_FIELD, LOOK_BACK_PERIOD_IN_DAYS_FIELD, RECOMMENDATION_OPTIONS_FIELD, RECOMMENDATION_SOURCES_FIELD, LAST_REFRESH_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceArn;
    private final String accountId;
    private final String instanceName;
    private final String currentInstanceType;
    private final String finding;
    private final List<UtilizationMetric> utilizationMetrics;
    private final Double lookBackPeriodInDays;
    private final List<InstanceRecommendationOption> recommendationOptions;
    private final List<RecommendationSource> recommendationSources;
    private final Instant lastRefreshTimestamp;

    private InstanceRecommendation(BuilderImpl builder) {
        this.instanceArn = builder.instanceArn;
        this.accountId = builder.accountId;
        this.instanceName = builder.instanceName;
        this.currentInstanceType = builder.currentInstanceType;
        this.finding = builder.finding;
        this.utilizationMetrics = builder.utilizationMetrics;
        this.lookBackPeriodInDays = builder.lookBackPeriodInDays;
        this.recommendationOptions = builder.recommendationOptions;
        this.recommendationSources = builder.recommendationSources;
        this.lastRefreshTimestamp = builder.lastRefreshTimestamp;
    }

    public String instanceArn() {
        return this.instanceArn;
    }

    public String accountId() {
        return this.accountId;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public String currentInstanceType() {
        return this.currentInstanceType;
    }

    public Finding finding() {
        return Finding.fromValue(this.finding);
    }

    public String findingAsString() {
        return this.finding;
    }

    public boolean hasUtilizationMetrics() {
        return this.utilizationMetrics != null && !(this.utilizationMetrics instanceof SdkAutoConstructList);
    }

    public List<UtilizationMetric> utilizationMetrics() {
        return this.utilizationMetrics;
    }

    public Double lookBackPeriodInDays() {
        return this.lookBackPeriodInDays;
    }

    public boolean hasRecommendationOptions() {
        return this.recommendationOptions != null && !(this.recommendationOptions instanceof SdkAutoConstructList);
    }

    public List<InstanceRecommendationOption> recommendationOptions() {
        return this.recommendationOptions;
    }

    public boolean hasRecommendationSources() {
        return this.recommendationSources != null && !(this.recommendationSources instanceof SdkAutoConstructList);
    }

    public List<RecommendationSource> recommendationSources() {
        return this.recommendationSources;
    }

    public Instant lastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.utilizationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookBackPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRefreshTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceRecommendation)) {
            return false;
        }
        InstanceRecommendation other = (InstanceRecommendation)obj;
        return Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.currentInstanceType(), other.currentInstanceType()) && Objects.equals(this.findingAsString(), other.findingAsString()) && Objects.equals(this.utilizationMetrics(), other.utilizationMetrics()) && Objects.equals(this.lookBackPeriodInDays(), other.lookBackPeriodInDays()) && Objects.equals(this.recommendationOptions(), other.recommendationOptions()) && Objects.equals(this.recommendationSources(), other.recommendationSources()) && Objects.equals(this.lastRefreshTimestamp(), other.lastRefreshTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"InstanceRecommendation").add("InstanceArn", (Object)this.instanceArn()).add("AccountId", (Object)this.accountId()).add("InstanceName", (Object)this.instanceName()).add("CurrentInstanceType", (Object)this.currentInstanceType()).add("Finding", (Object)this.findingAsString()).add("UtilizationMetrics", this.utilizationMetrics()).add("LookBackPeriodInDays", (Object)this.lookBackPeriodInDays()).add("RecommendationOptions", this.recommendationOptions()).add("RecommendationSources", this.recommendationSources()).add("LastRefreshTimestamp", (Object)this.lastRefreshTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
            case "currentInstanceType": {
                return Optional.ofNullable(clazz.cast(this.currentInstanceType()));
            }
            case "finding": {
                return Optional.ofNullable(clazz.cast(this.findingAsString()));
            }
            case "utilizationMetrics": {
                return Optional.ofNullable(clazz.cast(this.utilizationMetrics()));
            }
            case "lookBackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookBackPeriodInDays()));
            }
            case "recommendationOptions": {
                return Optional.ofNullable(clazz.cast(this.recommendationOptions()));
            }
            case "recommendationSources": {
                return Optional.ofNullable(clazz.cast(this.recommendationSources()));
            }
            case "lastRefreshTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastRefreshTimestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceRecommendation, T> g) {
        return obj -> g.apply((InstanceRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceArn;
        private String accountId;
        private String instanceName;
        private String currentInstanceType;
        private String finding;
        private List<UtilizationMetric> utilizationMetrics = DefaultSdkAutoConstructList.getInstance();
        private Double lookBackPeriodInDays;
        private List<InstanceRecommendationOption> recommendationOptions = DefaultSdkAutoConstructList.getInstance();
        private List<RecommendationSource> recommendationSources = DefaultSdkAutoConstructList.getInstance();
        private Instant lastRefreshTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceRecommendation model) {
            this.instanceArn(model.instanceArn);
            this.accountId(model.accountId);
            this.instanceName(model.instanceName);
            this.currentInstanceType(model.currentInstanceType);
            this.finding(model.finding);
            this.utilizationMetrics(model.utilizationMetrics);
            this.lookBackPeriodInDays(model.lookBackPeriodInDays);
            this.recommendationOptions(model.recommendationOptions);
            this.recommendationSources(model.recommendationSources);
            this.lastRefreshTimestamp(model.lastRefreshTimestamp);
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getCurrentInstanceType() {
            return this.currentInstanceType;
        }

        @Override
        public final Builder currentInstanceType(String currentInstanceType) {
            this.currentInstanceType = currentInstanceType;
            return this;
        }

        public final void setCurrentInstanceType(String currentInstanceType) {
            this.currentInstanceType = currentInstanceType;
        }

        public final String getFindingAsString() {
            return this.finding;
        }

        @Override
        public final Builder finding(String finding) {
            this.finding = finding;
            return this;
        }

        @Override
        public final Builder finding(Finding finding) {
            this.finding(finding == null ? null : finding.toString());
            return this;
        }

        public final void setFinding(String finding) {
            this.finding = finding;
        }

        public final Collection<UtilizationMetric.Builder> getUtilizationMetrics() {
            return this.utilizationMetrics != null ? (Collection)this.utilizationMetrics.stream().map(UtilizationMetric::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder utilizationMetrics(Collection<UtilizationMetric> utilizationMetrics) {
            this.utilizationMetrics = UtilizationMetricsCopier.copy(utilizationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(UtilizationMetric ... utilizationMetrics) {
            this.utilizationMetrics(Arrays.asList(utilizationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(Consumer<UtilizationMetric.Builder> ... utilizationMetrics) {
            this.utilizationMetrics(Stream.of(utilizationMetrics).map(c -> (UtilizationMetric)((UtilizationMetric.Builder)UtilizationMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUtilizationMetrics(Collection<UtilizationMetric.BuilderImpl> utilizationMetrics) {
            this.utilizationMetrics = UtilizationMetricsCopier.copyFromBuilder(utilizationMetrics);
        }

        public final Double getLookBackPeriodInDays() {
            return this.lookBackPeriodInDays;
        }

        @Override
        public final Builder lookBackPeriodInDays(Double lookBackPeriodInDays) {
            this.lookBackPeriodInDays = lookBackPeriodInDays;
            return this;
        }

        public final void setLookBackPeriodInDays(Double lookBackPeriodInDays) {
            this.lookBackPeriodInDays = lookBackPeriodInDays;
        }

        public final Collection<InstanceRecommendationOption.Builder> getRecommendationOptions() {
            return this.recommendationOptions != null ? (Collection)this.recommendationOptions.stream().map(InstanceRecommendationOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recommendationOptions(Collection<InstanceRecommendationOption> recommendationOptions) {
            this.recommendationOptions = RecommendationOptionsCopier.copy(recommendationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationOptions(InstanceRecommendationOption ... recommendationOptions) {
            this.recommendationOptions(Arrays.asList(recommendationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationOptions(Consumer<InstanceRecommendationOption.Builder> ... recommendationOptions) {
            this.recommendationOptions(Stream.of(recommendationOptions).map(c -> (InstanceRecommendationOption)((InstanceRecommendationOption.Builder)InstanceRecommendationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecommendationOptions(Collection<InstanceRecommendationOption.BuilderImpl> recommendationOptions) {
            this.recommendationOptions = RecommendationOptionsCopier.copyFromBuilder(recommendationOptions);
        }

        public final Collection<RecommendationSource.Builder> getRecommendationSources() {
            return this.recommendationSources != null ? (Collection)this.recommendationSources.stream().map(RecommendationSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recommendationSources(Collection<RecommendationSource> recommendationSources) {
            this.recommendationSources = RecommendationSourcesCopier.copy(recommendationSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationSources(RecommendationSource ... recommendationSources) {
            this.recommendationSources(Arrays.asList(recommendationSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationSources(Consumer<RecommendationSource.Builder> ... recommendationSources) {
            this.recommendationSources(Stream.of(recommendationSources).map(c -> (RecommendationSource)((RecommendationSource.Builder)RecommendationSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecommendationSources(Collection<RecommendationSource.BuilderImpl> recommendationSources) {
            this.recommendationSources = RecommendationSourcesCopier.copyFromBuilder(recommendationSources);
        }

        public final Instant getLastRefreshTimestamp() {
            return this.lastRefreshTimestamp;
        }

        @Override
        public final Builder lastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
            return this;
        }

        public final void setLastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
        }

        public InstanceRecommendation build() {
            return new InstanceRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceRecommendation> {
        public Builder instanceArn(String var1);

        public Builder accountId(String var1);

        public Builder instanceName(String var1);

        public Builder currentInstanceType(String var1);

        public Builder finding(String var1);

        public Builder finding(Finding var1);

        public Builder utilizationMetrics(Collection<UtilizationMetric> var1);

        public Builder utilizationMetrics(UtilizationMetric ... var1);

        public Builder utilizationMetrics(Consumer<UtilizationMetric.Builder> ... var1);

        public Builder lookBackPeriodInDays(Double var1);

        public Builder recommendationOptions(Collection<InstanceRecommendationOption> var1);

        public Builder recommendationOptions(InstanceRecommendationOption ... var1);

        public Builder recommendationOptions(Consumer<InstanceRecommendationOption.Builder> ... var1);

        public Builder recommendationSources(Collection<RecommendationSource> var1);

        public Builder recommendationSources(RecommendationSource ... var1);

        public Builder recommendationSources(Consumer<RecommendationSource.Builder> ... var1);

        public Builder lastRefreshTimestamp(Instant var1);
    }
}

