/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of characters in the input text to be analyzed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Characters implements SdkPojo, Serializable, ToCopyableBuilder<Characters.Builder, Characters> {
    private static final SdkField<Integer> ORIGINAL_TEXT_CHARACTERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OriginalTextCharacters").getter(getter(Characters::originalTextCharacters))
            .setter(setter(Builder::originalTextCharacters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalTextCharacters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ORIGINAL_TEXT_CHARACTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer originalTextCharacters;

    private Characters(BuilderImpl builder) {
        this.originalTextCharacters = builder.originalTextCharacters;
    }

    /**
     * <p>
     * The number of characters present in the input text document as processed by Amazon Comprehend Medical.
     * </p>
     * 
     * @return The number of characters present in the input text document as processed by Amazon Comprehend Medical.
     */
    public final Integer originalTextCharacters() {
        return originalTextCharacters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(originalTextCharacters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Characters)) {
            return false;
        }
        Characters other = (Characters) obj;
        return Objects.equals(originalTextCharacters(), other.originalTextCharacters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Characters").add("OriginalTextCharacters", originalTextCharacters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OriginalTextCharacters":
            return Optional.ofNullable(clazz.cast(originalTextCharacters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OriginalTextCharacters", ORIGINAL_TEXT_CHARACTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Characters, T> g) {
        return obj -> g.apply((Characters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Characters> {
        /**
         * <p>
         * The number of characters present in the input text document as processed by Amazon Comprehend Medical.
         * </p>
         * 
         * @param originalTextCharacters
         *        The number of characters present in the input text document as processed by Amazon Comprehend Medical.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalTextCharacters(Integer originalTextCharacters);
    }

    static final class BuilderImpl implements Builder {
        private Integer originalTextCharacters;

        private BuilderImpl() {
        }

        private BuilderImpl(Characters model) {
            originalTextCharacters(model.originalTextCharacters);
        }

        public final Integer getOriginalTextCharacters() {
            return originalTextCharacters;
        }

        public final void setOriginalTextCharacters(Integer originalTextCharacters) {
            this.originalTextCharacters = originalTextCharacters;
        }

        @Override
        public final Builder originalTextCharacters(Integer originalTextCharacters) {
            this.originalTextCharacters = originalTextCharacters;
            return this;
        }

        @Override
        public Characters build() {
            return new Characters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
