/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SNOMEDCTEntityCategory {
    MEDICAL_CONDITION("MEDICAL_CONDITION"),
    ANATOMY("ANATOMY"),
    TEST_TREATMENT_PROCEDURE("TEST_TREATMENT_PROCEDURE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SNOMEDCTEntityCategory> VALUE_MAP;
    private final String value;

    private SNOMEDCTEntityCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SNOMEDCTEntityCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SNOMEDCTEntityCategory> knownValues() {
        EnumSet<SNOMEDCTEntityCategory> knownValues = EnumSet.allOf(SNOMEDCTEntityCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SNOMEDCTEntityCategory.class, SNOMEDCTEntityCategory::toString);
    }
}

