/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.BatchSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ComprehendException;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.ConcurrentModificationException;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.InternalServerException;
import software.amazon.awssdk.services.comprehend.model.InvalidFilterException;
import software.amazon.awssdk.services.comprehend.model.InvalidRequestException;
import software.amazon.awssdk.services.comprehend.model.JobNotFoundException;
import software.amazon.awssdk.services.comprehend.model.KmsKeyValidationException;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ResourceInUseException;
import software.amazon.awssdk.services.comprehend.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ResourceNotFoundException;
import software.amazon.awssdk.services.comprehend.model.ResourceUnavailableException;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.TagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.TagResourceResponse;
import software.amazon.awssdk.services.comprehend.model.TextSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.TooManyRequestsException;
import software.amazon.awssdk.services.comprehend.model.TooManyTagKeysException;
import software.amazon.awssdk.services.comprehend.model.TooManyTagsException;
import software.amazon.awssdk.services.comprehend.model.UnsupportedLanguageException;
import software.amazon.awssdk.services.comprehend.model.UntagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.UntagResourceResponse;
import software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsIterable;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectDominantLanguageRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectKeyPhrasesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSyntaxRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDocumentClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeTopicsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectDominantLanguageRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectKeyPhrasesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectSyntaxRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDocumentClassificationJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDocumentClassifiersRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDominantLanguageDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEntitiesDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEntityRecognizersRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListKeyPhrasesDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListSentimentDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTopicsDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartDocumentClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartTopicsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopTrainingDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopTrainingEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.UntagResourceRequestMarshaller;

@SdkInternalApi
final class DefaultComprehendClient
implements ComprehendClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultComprehendClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "comprehend";
    }

    @Override
    public BatchDetectDominantLanguageResponse batchDetectDominantLanguage(BatchDetectDominantLanguageRequest batchDetectDominantLanguageRequest) throws InvalidRequestException, TextSizeLimitExceededException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectDominantLanguageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (BatchDetectDominantLanguageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectDominantLanguage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectDominantLanguageRequest).withMarshaller((Marshaller)new BatchDetectDominantLanguageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public BatchDetectEntitiesResponse batchDetectEntities(BatchDetectEntitiesRequest batchDetectEntitiesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectEntitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (BatchDetectEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectEntities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectEntitiesRequest).withMarshaller((Marshaller)new BatchDetectEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public BatchDetectKeyPhrasesResponse batchDetectKeyPhrases(BatchDetectKeyPhrasesRequest batchDetectKeyPhrasesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectKeyPhrasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (BatchDetectKeyPhrasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectKeyPhrases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectKeyPhrasesRequest).withMarshaller((Marshaller)new BatchDetectKeyPhrasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public BatchDetectSentimentResponse batchDetectSentiment(BatchDetectSentimentRequest batchDetectSentimentRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectSentimentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (BatchDetectSentimentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectSentiment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectSentimentRequest).withMarshaller((Marshaller)new BatchDetectSentimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public BatchDetectSyntaxResponse batchDetectSyntax(BatchDetectSyntaxRequest batchDetectSyntaxRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectSyntaxResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (BatchDetectSyntaxResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectSyntax").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDetectSyntaxRequest).withMarshaller((Marshaller)new BatchDetectSyntaxRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateDocumentClassifierResponse createDocumentClassifier(CreateDocumentClassifierRequest createDocumentClassifierRequest) throws InvalidRequestException, ResourceInUseException, TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException, UnsupportedLanguageException, KmsKeyValidationException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDocumentClassifierResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateDocumentClassifierResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDocumentClassifier").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDocumentClassifierRequest).withMarshaller((Marshaller)new CreateDocumentClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateEntityRecognizerResponse createEntityRecognizer(CreateEntityRecognizerRequest createEntityRecognizerRequest) throws InvalidRequestException, ResourceInUseException, TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException, UnsupportedLanguageException, KmsKeyValidationException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEntityRecognizerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateEntityRecognizerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEntityRecognizer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEntityRecognizerRequest).withMarshaller((Marshaller)new CreateEntityRecognizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteDocumentClassifierResponse deleteDocumentClassifier(DeleteDocumentClassifierRequest deleteDocumentClassifierRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDocumentClassifierResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteDocumentClassifierResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDocumentClassifier").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDocumentClassifierRequest).withMarshaller((Marshaller)new DeleteDocumentClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteEntityRecognizerResponse deleteEntityRecognizer(DeleteEntityRecognizerRequest deleteEntityRecognizerRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEntityRecognizerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteEntityRecognizerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEntityRecognizer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEntityRecognizerRequest).withMarshaller((Marshaller)new DeleteEntityRecognizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeDocumentClassificationJobResponse describeDocumentClassificationJob(DescribeDocumentClassificationJobRequest describeDocumentClassificationJobRequest) throws InvalidRequestException, TooManyRequestsException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDocumentClassificationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeDocumentClassificationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDocumentClassificationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDocumentClassificationJobRequest).withMarshaller((Marshaller)new DescribeDocumentClassificationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeDocumentClassifierResponse describeDocumentClassifier(DescribeDocumentClassifierRequest describeDocumentClassifierRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDocumentClassifierResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeDocumentClassifierResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDocumentClassifier").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDocumentClassifierRequest).withMarshaller((Marshaller)new DescribeDocumentClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeDominantLanguageDetectionJobResponse describeDominantLanguageDetectionJob(DescribeDominantLanguageDetectionJobRequest describeDominantLanguageDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDominantLanguageDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeDominantLanguageDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDominantLanguageDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDominantLanguageDetectionJobRequest).withMarshaller((Marshaller)new DescribeDominantLanguageDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeEntitiesDetectionJobResponse describeEntitiesDetectionJob(DescribeEntitiesDetectionJobRequest describeEntitiesDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEntitiesDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeEntitiesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEntitiesDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEntitiesDetectionJobRequest).withMarshaller((Marshaller)new DescribeEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeEntityRecognizerResponse describeEntityRecognizer(DescribeEntityRecognizerRequest describeEntityRecognizerRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEntityRecognizerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeEntityRecognizerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEntityRecognizer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEntityRecognizerRequest).withMarshaller((Marshaller)new DescribeEntityRecognizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeKeyPhrasesDetectionJobResponse describeKeyPhrasesDetectionJob(DescribeKeyPhrasesDetectionJobRequest describeKeyPhrasesDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeKeyPhrasesDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeKeyPhrasesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeKeyPhrasesDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeKeyPhrasesDetectionJobRequest).withMarshaller((Marshaller)new DescribeKeyPhrasesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeSentimentDetectionJobResponse describeSentimentDetectionJob(DescribeSentimentDetectionJobRequest describeSentimentDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSentimentDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeSentimentDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSentimentDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSentimentDetectionJobRequest).withMarshaller((Marshaller)new DescribeSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeTopicsDetectionJobResponse describeTopicsDetectionJob(DescribeTopicsDetectionJobRequest describeTopicsDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTopicsDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeTopicsDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTopicsDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTopicsDetectionJobRequest).withMarshaller((Marshaller)new DescribeTopicsDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DetectDominantLanguageResponse detectDominantLanguage(DetectDominantLanguageRequest detectDominantLanguageRequest) throws InvalidRequestException, TextSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectDominantLanguageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DetectDominantLanguageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectDominantLanguage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectDominantLanguageRequest).withMarshaller((Marshaller)new DetectDominantLanguageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DetectEntitiesResponse detectEntities(DetectEntitiesRequest detectEntitiesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectEntitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DetectEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectEntities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectEntitiesRequest).withMarshaller((Marshaller)new DetectEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DetectKeyPhrasesResponse detectKeyPhrases(DetectKeyPhrasesRequest detectKeyPhrasesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectKeyPhrasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DetectKeyPhrasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectKeyPhrases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectKeyPhrasesRequest).withMarshaller((Marshaller)new DetectKeyPhrasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DetectSentimentResponse detectSentiment(DetectSentimentRequest detectSentimentRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectSentimentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DetectSentimentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectSentiment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectSentimentRequest).withMarshaller((Marshaller)new DetectSentimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DetectSyntaxResponse detectSyntax(DetectSyntaxRequest detectSyntaxRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectSyntaxResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DetectSyntaxResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectSyntax").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)detectSyntaxRequest).withMarshaller((Marshaller)new DetectSyntaxRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDocumentClassificationJobsResponse listDocumentClassificationJobs(ListDocumentClassificationJobsRequest listDocumentClassificationJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDocumentClassificationJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDocumentClassificationJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDocumentClassificationJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDocumentClassificationJobsRequest).withMarshaller((Marshaller)new ListDocumentClassificationJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDocumentClassificationJobsIterable listDocumentClassificationJobsPaginator(ListDocumentClassificationJobsRequest listDocumentClassificationJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListDocumentClassificationJobsIterable(this, this.applyPaginatorUserAgent(listDocumentClassificationJobsRequest));
    }

    @Override
    public ListDocumentClassifiersResponse listDocumentClassifiers(ListDocumentClassifiersRequest listDocumentClassifiersRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDocumentClassifiersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDocumentClassifiersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDocumentClassifiers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDocumentClassifiersRequest).withMarshaller((Marshaller)new ListDocumentClassifiersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDocumentClassifiersIterable listDocumentClassifiersPaginator(ListDocumentClassifiersRequest listDocumentClassifiersRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListDocumentClassifiersIterable(this, this.applyPaginatorUserAgent(listDocumentClassifiersRequest));
    }

    @Override
    public ListDominantLanguageDetectionJobsResponse listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest listDominantLanguageDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDominantLanguageDetectionJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDominantLanguageDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDominantLanguageDetectionJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDominantLanguageDetectionJobsRequest).withMarshaller((Marshaller)new ListDominantLanguageDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDominantLanguageDetectionJobsIterable listDominantLanguageDetectionJobsPaginator(ListDominantLanguageDetectionJobsRequest listDominantLanguageDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListDominantLanguageDetectionJobsIterable(this, this.applyPaginatorUserAgent(listDominantLanguageDetectionJobsRequest));
    }

    @Override
    public ListEntitiesDetectionJobsResponse listEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest listEntitiesDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEntitiesDetectionJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListEntitiesDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEntitiesDetectionJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEntitiesDetectionJobsRequest).withMarshaller((Marshaller)new ListEntitiesDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListEntitiesDetectionJobsIterable listEntitiesDetectionJobsPaginator(ListEntitiesDetectionJobsRequest listEntitiesDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListEntitiesDetectionJobsIterable(this, this.applyPaginatorUserAgent(listEntitiesDetectionJobsRequest));
    }

    @Override
    public ListEntityRecognizersResponse listEntityRecognizers(ListEntityRecognizersRequest listEntityRecognizersRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEntityRecognizersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListEntityRecognizersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEntityRecognizers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEntityRecognizersRequest).withMarshaller((Marshaller)new ListEntityRecognizersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListEntityRecognizersIterable listEntityRecognizersPaginator(ListEntityRecognizersRequest listEntityRecognizersRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListEntityRecognizersIterable(this, this.applyPaginatorUserAgent(listEntityRecognizersRequest));
    }

    @Override
    public ListKeyPhrasesDetectionJobsResponse listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest listKeyPhrasesDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKeyPhrasesDetectionJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListKeyPhrasesDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKeyPhrasesDetectionJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listKeyPhrasesDetectionJobsRequest).withMarshaller((Marshaller)new ListKeyPhrasesDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListKeyPhrasesDetectionJobsIterable listKeyPhrasesDetectionJobsPaginator(ListKeyPhrasesDetectionJobsRequest listKeyPhrasesDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListKeyPhrasesDetectionJobsIterable(this, this.applyPaginatorUserAgent(listKeyPhrasesDetectionJobsRequest));
    }

    @Override
    public ListSentimentDetectionJobsResponse listSentimentDetectionJobs(ListSentimentDetectionJobsRequest listSentimentDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSentimentDetectionJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListSentimentDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSentimentDetectionJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSentimentDetectionJobsRequest).withMarshaller((Marshaller)new ListSentimentDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListSentimentDetectionJobsIterable listSentimentDetectionJobsPaginator(ListSentimentDetectionJobsRequest listSentimentDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListSentimentDetectionJobsIterable(this, this.applyPaginatorUserAgent(listSentimentDetectionJobsRequest));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTopicsDetectionJobsResponse listTopicsDetectionJobs(ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTopicsDetectionJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTopicsDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTopicsDetectionJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTopicsDetectionJobsRequest).withMarshaller((Marshaller)new ListTopicsDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTopicsDetectionJobsIterable listTopicsDetectionJobsPaginator(ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        return new ListTopicsDetectionJobsIterable(this, this.applyPaginatorUserAgent(listTopicsDetectionJobsRequest));
    }

    @Override
    public StartDocumentClassificationJobResponse startDocumentClassificationJob(StartDocumentClassificationJobRequest startDocumentClassificationJobRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, KmsKeyValidationException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDocumentClassificationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartDocumentClassificationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDocumentClassificationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startDocumentClassificationJobRequest).withMarshaller((Marshaller)new StartDocumentClassificationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartDominantLanguageDetectionJobResponse startDominantLanguageDetectionJob(StartDominantLanguageDetectionJobRequest startDominantLanguageDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDominantLanguageDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartDominantLanguageDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDominantLanguageDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startDominantLanguageDetectionJobRequest).withMarshaller((Marshaller)new StartDominantLanguageDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartEntitiesDetectionJobResponse startEntitiesDetectionJob(StartEntitiesDetectionJobRequest startEntitiesDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, KmsKeyValidationException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartEntitiesDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartEntitiesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartEntitiesDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startEntitiesDetectionJobRequest).withMarshaller((Marshaller)new StartEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartKeyPhrasesDetectionJobResponse startKeyPhrasesDetectionJob(StartKeyPhrasesDetectionJobRequest startKeyPhrasesDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartKeyPhrasesDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartKeyPhrasesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartKeyPhrasesDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startKeyPhrasesDetectionJobRequest).withMarshaller((Marshaller)new StartKeyPhrasesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartSentimentDetectionJobResponse startSentimentDetectionJob(StartSentimentDetectionJobRequest startSentimentDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSentimentDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartSentimentDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSentimentDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startSentimentDetectionJobRequest).withMarshaller((Marshaller)new StartSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartTopicsDetectionJobResponse startTopicsDetectionJob(StartTopicsDetectionJobRequest startTopicsDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTopicsDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartTopicsDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTopicsDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startTopicsDetectionJobRequest).withMarshaller((Marshaller)new StartTopicsDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopDominantLanguageDetectionJobResponse stopDominantLanguageDetectionJob(StopDominantLanguageDetectionJobRequest stopDominantLanguageDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopDominantLanguageDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopDominantLanguageDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDominantLanguageDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopDominantLanguageDetectionJobRequest).withMarshaller((Marshaller)new StopDominantLanguageDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopEntitiesDetectionJobResponse stopEntitiesDetectionJob(StopEntitiesDetectionJobRequest stopEntitiesDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopEntitiesDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopEntitiesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopEntitiesDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopEntitiesDetectionJobRequest).withMarshaller((Marshaller)new StopEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopKeyPhrasesDetectionJobResponse stopKeyPhrasesDetectionJob(StopKeyPhrasesDetectionJobRequest stopKeyPhrasesDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopKeyPhrasesDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopKeyPhrasesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopKeyPhrasesDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopKeyPhrasesDetectionJobRequest).withMarshaller((Marshaller)new StopKeyPhrasesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopSentimentDetectionJobResponse stopSentimentDetectionJob(StopSentimentDetectionJobRequest stopSentimentDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopSentimentDetectionJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopSentimentDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopSentimentDetectionJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopSentimentDetectionJobRequest).withMarshaller((Marshaller)new StopSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopTrainingDocumentClassifierResponse stopTrainingDocumentClassifier(StopTrainingDocumentClassifierRequest stopTrainingDocumentClassifierRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopTrainingDocumentClassifierResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopTrainingDocumentClassifierResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopTrainingDocumentClassifier").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopTrainingDocumentClassifierRequest).withMarshaller((Marshaller)new StopTrainingDocumentClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StopTrainingEntityRecognizerResponse stopTrainingEntityRecognizer(StopTrainingEntityRecognizerRequest stopTrainingEntityRecognizerRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopTrainingEntityRecognizerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StopTrainingEntityRecognizerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopTrainingEntityRecognizer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopTrainingEntityRecognizerRequest).withMarshaller((Marshaller)new StopTrainingEntityRecognizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException, ConcurrentModificationException, ResourceNotFoundException, TooManyTagsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws TooManyTagKeysException, InvalidRequestException, ConcurrentModificationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ComprehendException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").exceptionBuilderSupplier(KmsKeyValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidFilterException").exceptionBuilderSupplier(InvalidFilterException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").exceptionBuilderSupplier(TooManyTagKeysException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").exceptionBuilderSupplier(UnsupportedLanguageException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").exceptionBuilderSupplier(ResourceUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("JobNotFoundException").exceptionBuilderSupplier(JobNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ComprehendRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.7.7").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ComprehendRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

