/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.ListOfSyntaxTokensCopier;
import software.amazon.awssdk.services.comprehend.model.SyntaxToken;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectSyntaxResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, DetectSyntaxResponse> {
    private static final SdkField<List<SyntaxToken>> SYNTAX_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DetectSyntaxResponse.getter(DetectSyntaxResponse::syntaxTokens)).setter(DetectSyntaxResponse.setter(Builder::syntaxTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyntaxTokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SyntaxToken::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNTAX_TOKENS_FIELD));
    private final List<SyntaxToken> syntaxTokens;

    private DetectSyntaxResponse(BuilderImpl builder) {
        super(builder);
        this.syntaxTokens = builder.syntaxTokens;
    }

    public List<SyntaxToken> syntaxTokens() {
        return this.syntaxTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.syntaxTokens());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectSyntaxResponse)) {
            return false;
        }
        DetectSyntaxResponse other = (DetectSyntaxResponse)((Object)obj);
        return Objects.equals(this.syntaxTokens(), other.syntaxTokens());
    }

    public String toString() {
        return ToString.builder((String)"DetectSyntaxResponse").add("SyntaxTokens", this.syntaxTokens()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SyntaxTokens": {
                return Optional.ofNullable(clazz.cast(this.syntaxTokens()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectSyntaxResponse, T> g) {
        return obj -> g.apply((DetectSyntaxResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<SyntaxToken> syntaxTokens = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectSyntaxResponse model) {
            super(model);
            this.syntaxTokens(model.syntaxTokens);
        }

        public final Collection<SyntaxToken.Builder> getSyntaxTokens() {
            return this.syntaxTokens != null ? (Collection)this.syntaxTokens.stream().map(SyntaxToken::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder syntaxTokens(Collection<SyntaxToken> syntaxTokens) {
            this.syntaxTokens = ListOfSyntaxTokensCopier.copy(syntaxTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder syntaxTokens(SyntaxToken ... syntaxTokens) {
            this.syntaxTokens(Arrays.asList(syntaxTokens));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder syntaxTokens(Consumer<SyntaxToken.Builder> ... syntaxTokens) {
            this.syntaxTokens(Stream.of(syntaxTokens).map(c -> (SyntaxToken)((SyntaxToken.Builder)SyntaxToken.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSyntaxTokens(Collection<SyntaxToken.BuilderImpl> syntaxTokens) {
            this.syntaxTokens = ListOfSyntaxTokensCopier.copyFromBuilder(syntaxTokens);
        }

        @Override
        public DetectSyntaxResponse build() {
            return new DetectSyntaxResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectSyntaxResponse> {
        public Builder syntaxTokens(Collection<SyntaxToken> var1);

        public Builder syntaxTokens(SyntaxToken ... var1);

        public Builder syntaxTokens(Consumer<SyntaxToken.Builder> ... var1);
    }
}

