/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.KeyPhrase;
import software.amazon.awssdk.services.comprehend.model.ListOfKeyPhrasesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDetectKeyPhrasesItemResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchDetectKeyPhrasesItemResult> {
    private static final SdkField<Integer> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BatchDetectKeyPhrasesItemResult.getter(BatchDetectKeyPhrasesItemResult::index)).setter(BatchDetectKeyPhrasesItemResult.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()}).build();
    private static final SdkField<List<KeyPhrase>> KEY_PHRASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchDetectKeyPhrasesItemResult.getter(BatchDetectKeyPhrasesItemResult::keyPhrases)).setter(BatchDetectKeyPhrasesItemResult.setter(Builder::keyPhrases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPhrases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyPhrase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD, KEY_PHRASES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer index;
    private final List<KeyPhrase> keyPhrases;

    private BatchDetectKeyPhrasesItemResult(BuilderImpl builder) {
        this.index = builder.index;
        this.keyPhrases = builder.keyPhrases;
    }

    public Integer index() {
        return this.index;
    }

    public List<KeyPhrase> keyPhrases() {
        return this.keyPhrases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPhrases());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectKeyPhrasesItemResult)) {
            return false;
        }
        BatchDetectKeyPhrasesItemResult other = (BatchDetectKeyPhrasesItemResult)obj;
        return Objects.equals(this.index(), other.index()) && Objects.equals(this.keyPhrases(), other.keyPhrases());
    }

    public String toString() {
        return ToString.builder((String)"BatchDetectKeyPhrasesItemResult").add("Index", (Object)this.index()).add("KeyPhrases", this.keyPhrases()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
            case "KeyPhrases": {
                return Optional.ofNullable(clazz.cast(this.keyPhrases()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectKeyPhrasesItemResult, T> g) {
        return obj -> g.apply((BatchDetectKeyPhrasesItemResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer index;
        private List<KeyPhrase> keyPhrases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectKeyPhrasesItemResult model) {
            this.index(model.index);
            this.keyPhrases(model.keyPhrases);
        }

        public final Integer getIndex() {
            return this.index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        public final Collection<KeyPhrase.Builder> getKeyPhrases() {
            return this.keyPhrases != null ? (Collection)this.keyPhrases.stream().map(KeyPhrase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keyPhrases(Collection<KeyPhrase> keyPhrases) {
            this.keyPhrases = ListOfKeyPhrasesCopier.copy(keyPhrases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrases(KeyPhrase ... keyPhrases) {
            this.keyPhrases(Arrays.asList(keyPhrases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrases(Consumer<KeyPhrase.Builder> ... keyPhrases) {
            this.keyPhrases(Stream.of(keyPhrases).map(c -> (KeyPhrase)((KeyPhrase.Builder)KeyPhrase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeyPhrases(Collection<KeyPhrase.BuilderImpl> keyPhrases) {
            this.keyPhrases = ListOfKeyPhrasesCopier.copyFromBuilder(keyPhrases);
        }

        public BatchDetectKeyPhrasesItemResult build() {
            return new BatchDetectKeyPhrasesItemResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchDetectKeyPhrasesItemResult> {
        public Builder index(Integer var1);

        public Builder keyPhrases(Collection<KeyPhrase> var1);

        public Builder keyPhrases(KeyPhrase ... var1);

        public Builder keyPhrases(Consumer<KeyPhrase.Builder> ... var1);
    }
}

