/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFlywheelRequest extends ComprehendRequest implements
        ToCopyableBuilder<UpdateFlywheelRequest.Builder, UpdateFlywheelRequest> {
    private static final SdkField<String> FLYWHEEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlywheelArn").getter(getter(UpdateFlywheelRequest::flywheelArn)).setter(setter(Builder::flywheelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelArn").build()).build();

    private static final SdkField<String> ACTIVE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveModelArn").getter(getter(UpdateFlywheelRequest::activeModelArn))
            .setter(setter(Builder::activeModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveModelArn").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(UpdateFlywheelRequest::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<UpdateDataSecurityConfig> DATA_SECURITY_CONFIG_FIELD = SdkField
            .<UpdateDataSecurityConfig> builder(MarshallingType.SDK_POJO).memberName("DataSecurityConfig")
            .getter(getter(UpdateFlywheelRequest::dataSecurityConfig)).setter(setter(Builder::dataSecurityConfig))
            .constructor(UpdateDataSecurityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSecurityConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLYWHEEL_ARN_FIELD,
            ACTIVE_MODEL_ARN_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, DATA_SECURITY_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String flywheelArn;

    private final String activeModelArn;

    private final String dataAccessRoleArn;

    private final UpdateDataSecurityConfig dataSecurityConfig;

    private UpdateFlywheelRequest(BuilderImpl builder) {
        super(builder);
        this.flywheelArn = builder.flywheelArn;
        this.activeModelArn = builder.activeModelArn;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.dataSecurityConfig = builder.dataSecurityConfig;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the flywheel to update.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the flywheel to update.
     */
    public final String flywheelArn() {
        return flywheelArn;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the active model version.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the active model version.
     */
    public final String activeModelArn() {
        return activeModelArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend permission to access the flywheel
     * data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend permission to access the
     *         flywheel data.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * Flywheel data security configuration.
     * </p>
     * 
     * @return Flywheel data security configuration.
     */
    public final UpdateDataSecurityConfig dataSecurityConfig() {
        return dataSecurityConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flywheelArn());
        hashCode = 31 * hashCode + Objects.hashCode(activeModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataSecurityConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlywheelRequest)) {
            return false;
        }
        UpdateFlywheelRequest other = (UpdateFlywheelRequest) obj;
        return Objects.equals(flywheelArn(), other.flywheelArn()) && Objects.equals(activeModelArn(), other.activeModelArn())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn())
                && Objects.equals(dataSecurityConfig(), other.dataSecurityConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFlywheelRequest").add("FlywheelArn", flywheelArn())
                .add("ActiveModelArn", activeModelArn()).add("DataAccessRoleArn", dataAccessRoleArn())
                .add("DataSecurityConfig", dataSecurityConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlywheelArn":
            return Optional.ofNullable(clazz.cast(flywheelArn()));
        case "ActiveModelArn":
            return Optional.ofNullable(clazz.cast(activeModelArn()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "DataSecurityConfig":
            return Optional.ofNullable(clazz.cast(dataSecurityConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FlywheelArn", FLYWHEEL_ARN_FIELD);
        map.put("ActiveModelArn", ACTIVE_MODEL_ARN_FIELD);
        map.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
        map.put("DataSecurityConfig", DATA_SECURITY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlywheelRequest, T> g) {
        return obj -> g.apply((UpdateFlywheelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComprehendRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFlywheelRequest> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the flywheel to update.
         * </p>
         * 
         * @param flywheelArn
         *        The Amazon Resource Number (ARN) of the flywheel to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flywheelArn(String flywheelArn);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the active model version.
         * </p>
         * 
         * @param activeModelArn
         *        The Amazon Resource Number (ARN) of the active model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeModelArn(String activeModelArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend permission to access the
         * flywheel data.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend permission to access the
         *        flywheel data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * Flywheel data security configuration.
         * </p>
         * 
         * @param dataSecurityConfig
         *        Flywheel data security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSecurityConfig(UpdateDataSecurityConfig dataSecurityConfig);

        /**
         * <p>
         * Flywheel data security configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateDataSecurityConfig.Builder}
         * avoiding the need to create one manually via {@link UpdateDataSecurityConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateDataSecurityConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSecurityConfig(UpdateDataSecurityConfig)}.
         * 
         * @param dataSecurityConfig
         *        a consumer that will call methods on {@link UpdateDataSecurityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSecurityConfig(UpdateDataSecurityConfig)
         */
        default Builder dataSecurityConfig(Consumer<UpdateDataSecurityConfig.Builder> dataSecurityConfig) {
            return dataSecurityConfig(UpdateDataSecurityConfig.builder().applyMutation(dataSecurityConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComprehendRequest.BuilderImpl implements Builder {
        private String flywheelArn;

        private String activeModelArn;

        private String dataAccessRoleArn;

        private UpdateDataSecurityConfig dataSecurityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlywheelRequest model) {
            super(model);
            flywheelArn(model.flywheelArn);
            activeModelArn(model.activeModelArn);
            dataAccessRoleArn(model.dataAccessRoleArn);
            dataSecurityConfig(model.dataSecurityConfig);
        }

        public final String getFlywheelArn() {
            return flywheelArn;
        }

        public final void setFlywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
        }

        @Override
        public final Builder flywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
            return this;
        }

        public final String getActiveModelArn() {
            return activeModelArn;
        }

        public final void setActiveModelArn(String activeModelArn) {
            this.activeModelArn = activeModelArn;
        }

        @Override
        public final Builder activeModelArn(String activeModelArn) {
            this.activeModelArn = activeModelArn;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final UpdateDataSecurityConfig.Builder getDataSecurityConfig() {
            return dataSecurityConfig != null ? dataSecurityConfig.toBuilder() : null;
        }

        public final void setDataSecurityConfig(UpdateDataSecurityConfig.BuilderImpl dataSecurityConfig) {
            this.dataSecurityConfig = dataSecurityConfig != null ? dataSecurityConfig.build() : null;
        }

        @Override
        public final Builder dataSecurityConfig(UpdateDataSecurityConfig dataSecurityConfig) {
            this.dataSecurityConfig = dataSecurityConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlywheelRequest build() {
            return new UpdateFlywheelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
