/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventsDetectionJobResponse extends ComprehendResponse implements
        ToCopyableBuilder<DescribeEventsDetectionJobResponse.Builder, DescribeEventsDetectionJobResponse> {
    private static final SdkField<EventsDetectionJobProperties> EVENTS_DETECTION_JOB_PROPERTIES_FIELD = SdkField
            .<EventsDetectionJobProperties> builder(MarshallingType.SDK_POJO)
            .memberName("EventsDetectionJobProperties")
            .getter(getter(DescribeEventsDetectionJobResponse::eventsDetectionJobProperties))
            .setter(setter(Builder::eventsDetectionJobProperties))
            .constructor(EventsDetectionJobProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsDetectionJobProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EVENTS_DETECTION_JOB_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final EventsDetectionJobProperties eventsDetectionJobProperties;

    private DescribeEventsDetectionJobResponse(BuilderImpl builder) {
        super(builder);
        this.eventsDetectionJobProperties = builder.eventsDetectionJobProperties;
    }

    /**
     * <p>
     * An object that contains the properties associated with an event detection job.
     * </p>
     * 
     * @return An object that contains the properties associated with an event detection job.
     */
    public final EventsDetectionJobProperties eventsDetectionJobProperties() {
        return eventsDetectionJobProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventsDetectionJobProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsDetectionJobResponse)) {
            return false;
        }
        DescribeEventsDetectionJobResponse other = (DescribeEventsDetectionJobResponse) obj;
        return Objects.equals(eventsDetectionJobProperties(), other.eventsDetectionJobProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEventsDetectionJobResponse")
                .add("EventsDetectionJobProperties", eventsDetectionJobProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventsDetectionJobProperties":
            return Optional.ofNullable(clazz.cast(eventsDetectionJobProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventsDetectionJobProperties", EVENTS_DETECTION_JOB_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventsDetectionJobResponse, T> g) {
        return obj -> g.apply((DescribeEventsDetectionJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEventsDetectionJobResponse> {
        /**
         * <p>
         * An object that contains the properties associated with an event detection job.
         * </p>
         * 
         * @param eventsDetectionJobProperties
         *        An object that contains the properties associated with an event detection job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventsDetectionJobProperties(EventsDetectionJobProperties eventsDetectionJobProperties);

        /**
         * <p>
         * An object that contains the properties associated with an event detection job.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventsDetectionJobProperties.Builder}
         * avoiding the need to create one manually via {@link EventsDetectionJobProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventsDetectionJobProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #eventsDetectionJobProperties(EventsDetectionJobProperties)}.
         * 
         * @param eventsDetectionJobProperties
         *        a consumer that will call methods on {@link EventsDetectionJobProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventsDetectionJobProperties(EventsDetectionJobProperties)
         */
        default Builder eventsDetectionJobProperties(Consumer<EventsDetectionJobProperties.Builder> eventsDetectionJobProperties) {
            return eventsDetectionJobProperties(EventsDetectionJobProperties.builder()
                    .applyMutation(eventsDetectionJobProperties).build());
        }
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private EventsDetectionJobProperties eventsDetectionJobProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventsDetectionJobResponse model) {
            super(model);
            eventsDetectionJobProperties(model.eventsDetectionJobProperties);
        }

        public final EventsDetectionJobProperties.Builder getEventsDetectionJobProperties() {
            return eventsDetectionJobProperties != null ? eventsDetectionJobProperties.toBuilder() : null;
        }

        public final void setEventsDetectionJobProperties(EventsDetectionJobProperties.BuilderImpl eventsDetectionJobProperties) {
            this.eventsDetectionJobProperties = eventsDetectionJobProperties != null ? eventsDetectionJobProperties.build()
                    : null;
        }

        @Override
        public final Builder eventsDetectionJobProperties(EventsDetectionJobProperties eventsDetectionJobProperties) {
            this.eventsDetectionJobProperties = eventsDetectionJobProperties;
            return this;
        }

        @Override
        public DescribeEventsDetectionJobResponse build() {
            return new DescribeEventsDetectionJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
