/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse;

public class ListEntitiesDetectionJobsIterable
implements SdkIterable<ListEntitiesDetectionJobsResponse> {
    private final ComprehendClient client;
    private final ListEntitiesDetectionJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEntitiesDetectionJobsIterable(ComprehendClient client, ListEntitiesDetectionJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEntitiesDetectionJobsResponseFetcher();
    }

    public Iterator<ListEntitiesDetectionJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListEntitiesDetectionJobsIterable resume(ListEntitiesDetectionJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListEntitiesDetectionJobsIterable(this.client, (ListEntitiesDetectionJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListEntitiesDetectionJobsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListEntitiesDetectionJobsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListEntitiesDetectionJobsResponseFetcher
    implements SyncPageFetcher<ListEntitiesDetectionJobsResponse> {
        private ListEntitiesDetectionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListEntitiesDetectionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEntitiesDetectionJobsResponse nextPage(ListEntitiesDetectionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListEntitiesDetectionJobsIterable.this.client.listEntitiesDetectionJobs(ListEntitiesDetectionJobsIterable.this.firstRequest);
            }
            return ListEntitiesDetectionJobsIterable.this.client.listEntitiesDetectionJobs((ListEntitiesDetectionJobsRequest)((Object)ListEntitiesDetectionJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

