/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageItemResult;
import software.amazon.awssdk.services.comprehend.model.BatchItemError;
import software.amazon.awssdk.services.comprehend.model.BatchItemErrorListCopier;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.ListOfDetectDominantLanguageResultCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDetectDominantLanguageResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, BatchDetectDominantLanguageResponse> {
    private static final SdkField<List<BatchDetectDominantLanguageItemResult>> RESULT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResultList").getter(BatchDetectDominantLanguageResponse.getter(BatchDetectDominantLanguageResponse::resultList)).setter(BatchDetectDominantLanguageResponse.setter(Builder::resultList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDetectDominantLanguageItemResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchItemError>> ERROR_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorList").getter(BatchDetectDominantLanguageResponse.getter(BatchDetectDominantLanguageResponse::errorList)).setter(BatchDetectDominantLanguageResponse.setter(Builder::errorList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchItemError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_LIST_FIELD, ERROR_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDetectDominantLanguageResponse.memberNameToFieldInitializer();
    private final List<BatchDetectDominantLanguageItemResult> resultList;
    private final List<BatchItemError> errorList;

    private BatchDetectDominantLanguageResponse(BuilderImpl builder) {
        super(builder);
        this.resultList = builder.resultList;
        this.errorList = builder.errorList;
    }

    public final boolean hasResultList() {
        return this.resultList != null && !(this.resultList instanceof SdkAutoConstructList);
    }

    public final List<BatchDetectDominantLanguageItemResult> resultList() {
        return this.resultList;
    }

    public final boolean hasErrorList() {
        return this.errorList != null && !(this.errorList instanceof SdkAutoConstructList);
    }

    public final List<BatchItemError> errorList() {
        return this.errorList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultList() ? this.resultList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorList() ? this.errorList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectDominantLanguageResponse)) {
            return false;
        }
        BatchDetectDominantLanguageResponse other = (BatchDetectDominantLanguageResponse)((Object)obj);
        return this.hasResultList() == other.hasResultList() && Objects.equals(this.resultList(), other.resultList()) && this.hasErrorList() == other.hasErrorList() && Objects.equals(this.errorList(), other.errorList());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDetectDominantLanguageResponse").add("ResultList", this.hasResultList() ? this.resultList() : null).add("ErrorList", this.hasErrorList() ? this.errorList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultList": {
                return Optional.ofNullable(clazz.cast(this.resultList()));
            }
            case "ErrorList": {
                return Optional.ofNullable(clazz.cast(this.errorList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResultList", RESULT_LIST_FIELD);
        map.put("ErrorList", ERROR_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectDominantLanguageResponse, T> g) {
        return obj -> g.apply((BatchDetectDominantLanguageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<BatchDetectDominantLanguageItemResult> resultList = DefaultSdkAutoConstructList.getInstance();
        private List<BatchItemError> errorList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectDominantLanguageResponse model) {
            super(model);
            this.resultList(model.resultList);
            this.errorList(model.errorList);
        }

        public final List<BatchDetectDominantLanguageItemResult.Builder> getResultList() {
            List<BatchDetectDominantLanguageItemResult.Builder> result = ListOfDetectDominantLanguageResultCopier.copyToBuilder(this.resultList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultList(Collection<BatchDetectDominantLanguageItemResult.BuilderImpl> resultList) {
            this.resultList = ListOfDetectDominantLanguageResultCopier.copyFromBuilder(resultList);
        }

        @Override
        public final Builder resultList(Collection<BatchDetectDominantLanguageItemResult> resultList) {
            this.resultList = ListOfDetectDominantLanguageResultCopier.copy(resultList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(BatchDetectDominantLanguageItemResult ... resultList) {
            this.resultList(Arrays.asList(resultList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(Consumer<BatchDetectDominantLanguageItemResult.Builder> ... resultList) {
            this.resultList(Stream.of(resultList).map(c -> (BatchDetectDominantLanguageItemResult)((BatchDetectDominantLanguageItemResult.Builder)BatchDetectDominantLanguageItemResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchItemError.Builder> getErrorList() {
            List<BatchItemError.Builder> result = BatchItemErrorListCopier.copyToBuilder(this.errorList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorList(Collection<BatchItemError.BuilderImpl> errorList) {
            this.errorList = BatchItemErrorListCopier.copyFromBuilder(errorList);
        }

        @Override
        public final Builder errorList(Collection<BatchItemError> errorList) {
            this.errorList = BatchItemErrorListCopier.copy(errorList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorList(BatchItemError ... errorList) {
            this.errorList(Arrays.asList(errorList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorList(Consumer<BatchItemError.Builder> ... errorList) {
            this.errorList(Stream.of(errorList).map(c -> (BatchItemError)((BatchItemError.Builder)BatchItemError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDetectDominantLanguageResponse build() {
            return new BatchDetectDominantLanguageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDetectDominantLanguageResponse> {
        public Builder resultList(Collection<BatchDetectDominantLanguageItemResult> var1);

        public Builder resultList(BatchDetectDominantLanguageItemResult ... var1);

        public Builder resultList(Consumer<BatchDetectDominantLanguageItemResult.Builder> ... var1);

        public Builder errorList(Collection<BatchItemError> var1);

        public Builder errorList(BatchItemError ... var1);

        public Builder errorList(Consumer<BatchItemError.Builder> ... var1);
    }
}

