/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.DataSecurityConfig;
import software.amazon.awssdk.services.comprehend.model.FlywheelStatus;
import software.amazon.awssdk.services.comprehend.model.ModelType;
import software.amazon.awssdk.services.comprehend.model.TaskConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlywheelProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlywheelProperties> {
    private static final SdkField<String> FLYWHEEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlywheelArn").getter(FlywheelProperties.getter(FlywheelProperties::flywheelArn)).setter(FlywheelProperties.setter(Builder::flywheelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelArn").build()}).build();
    private static final SdkField<String> ACTIVE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveModelArn").getter(FlywheelProperties.getter(FlywheelProperties::activeModelArn)).setter(FlywheelProperties.setter(Builder::activeModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveModelArn").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(FlywheelProperties.getter(FlywheelProperties::dataAccessRoleArn)).setter(FlywheelProperties.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<TaskConfig> TASK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TaskConfig").getter(FlywheelProperties.getter(FlywheelProperties::taskConfig)).setter(FlywheelProperties.setter(Builder::taskConfig)).constructor(TaskConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskConfig").build()}).build();
    private static final SdkField<String> DATA_LAKE_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataLakeS3Uri").getter(FlywheelProperties.getter(FlywheelProperties::dataLakeS3Uri)).setter(FlywheelProperties.setter(Builder::dataLakeS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeS3Uri").build()}).build();
    private static final SdkField<DataSecurityConfig> DATA_SECURITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSecurityConfig").getter(FlywheelProperties.getter(FlywheelProperties::dataSecurityConfig)).setter(FlywheelProperties.setter(Builder::dataSecurityConfig)).constructor(DataSecurityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSecurityConfig").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(FlywheelProperties.getter(FlywheelProperties::statusAsString)).setter(FlywheelProperties.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelType").getter(FlywheelProperties.getter(FlywheelProperties::modelTypeAsString)).setter(FlywheelProperties.setter(Builder::modelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelType").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(FlywheelProperties.getter(FlywheelProperties::message)).setter(FlywheelProperties.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(FlywheelProperties.getter(FlywheelProperties::creationTime)).setter(FlywheelProperties.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(FlywheelProperties.getter(FlywheelProperties::lastModifiedTime)).setter(FlywheelProperties.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LATEST_FLYWHEEL_ITERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestFlywheelIteration").getter(FlywheelProperties.getter(FlywheelProperties::latestFlywheelIteration)).setter(FlywheelProperties.setter(Builder::latestFlywheelIteration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestFlywheelIteration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLYWHEEL_ARN_FIELD, ACTIVE_MODEL_ARN_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, TASK_CONFIG_FIELD, DATA_LAKE_S3_URI_FIELD, DATA_SECURITY_CONFIG_FIELD, STATUS_FIELD, MODEL_TYPE_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LATEST_FLYWHEEL_ITERATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlywheelProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String flywheelArn;
    private final String activeModelArn;
    private final String dataAccessRoleArn;
    private final TaskConfig taskConfig;
    private final String dataLakeS3Uri;
    private final DataSecurityConfig dataSecurityConfig;
    private final String status;
    private final String modelType;
    private final String message;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String latestFlywheelIteration;

    private FlywheelProperties(BuilderImpl builder) {
        this.flywheelArn = builder.flywheelArn;
        this.activeModelArn = builder.activeModelArn;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.taskConfig = builder.taskConfig;
        this.dataLakeS3Uri = builder.dataLakeS3Uri;
        this.dataSecurityConfig = builder.dataSecurityConfig;
        this.status = builder.status;
        this.modelType = builder.modelType;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.latestFlywheelIteration = builder.latestFlywheelIteration;
    }

    public final String flywheelArn() {
        return this.flywheelArn;
    }

    public final String activeModelArn() {
        return this.activeModelArn;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public final TaskConfig taskConfig() {
        return this.taskConfig;
    }

    public final String dataLakeS3Uri() {
        return this.dataLakeS3Uri;
    }

    public final DataSecurityConfig dataSecurityConfig() {
        return this.dataSecurityConfig;
    }

    public final FlywheelStatus status() {
        return FlywheelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ModelType modelType() {
        return ModelType.fromValue(this.modelType);
    }

    public final String modelTypeAsString() {
        return this.modelType;
    }

    public final String message() {
        return this.message;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String latestFlywheelIteration() {
        return this.latestFlywheelIteration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flywheelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLakeS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSecurityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestFlywheelIteration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlywheelProperties)) {
            return false;
        }
        FlywheelProperties other = (FlywheelProperties)obj;
        return Objects.equals(this.flywheelArn(), other.flywheelArn()) && Objects.equals(this.activeModelArn(), other.activeModelArn()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.taskConfig(), other.taskConfig()) && Objects.equals(this.dataLakeS3Uri(), other.dataLakeS3Uri()) && Objects.equals(this.dataSecurityConfig(), other.dataSecurityConfig()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.modelTypeAsString(), other.modelTypeAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.latestFlywheelIteration(), other.latestFlywheelIteration());
    }

    public final String toString() {
        return ToString.builder((String)"FlywheelProperties").add("FlywheelArn", (Object)this.flywheelArn()).add("ActiveModelArn", (Object)this.activeModelArn()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("TaskConfig", (Object)this.taskConfig()).add("DataLakeS3Uri", (Object)this.dataLakeS3Uri()).add("DataSecurityConfig", (Object)this.dataSecurityConfig()).add("Status", (Object)this.statusAsString()).add("ModelType", (Object)this.modelTypeAsString()).add("Message", (Object)this.message()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LatestFlywheelIteration", (Object)this.latestFlywheelIteration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlywheelArn": {
                return Optional.ofNullable(clazz.cast(this.flywheelArn()));
            }
            case "ActiveModelArn": {
                return Optional.ofNullable(clazz.cast(this.activeModelArn()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "TaskConfig": {
                return Optional.ofNullable(clazz.cast(this.taskConfig()));
            }
            case "DataLakeS3Uri": {
                return Optional.ofNullable(clazz.cast(this.dataLakeS3Uri()));
            }
            case "DataSecurityConfig": {
                return Optional.ofNullable(clazz.cast(this.dataSecurityConfig()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ModelType": {
                return Optional.ofNullable(clazz.cast(this.modelTypeAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LatestFlywheelIteration": {
                return Optional.ofNullable(clazz.cast(this.latestFlywheelIteration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FlywheelArn", FLYWHEEL_ARN_FIELD);
        map.put("ActiveModelArn", ACTIVE_MODEL_ARN_FIELD);
        map.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
        map.put("TaskConfig", TASK_CONFIG_FIELD);
        map.put("DataLakeS3Uri", DATA_LAKE_S3_URI_FIELD);
        map.put("DataSecurityConfig", DATA_SECURITY_CONFIG_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ModelType", MODEL_TYPE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LatestFlywheelIteration", LATEST_FLYWHEEL_ITERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlywheelProperties, T> g) {
        return obj -> g.apply((FlywheelProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String flywheelArn;
        private String activeModelArn;
        private String dataAccessRoleArn;
        private TaskConfig taskConfig;
        private String dataLakeS3Uri;
        private DataSecurityConfig dataSecurityConfig;
        private String status;
        private String modelType;
        private String message;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String latestFlywheelIteration;

        private BuilderImpl() {
        }

        private BuilderImpl(FlywheelProperties model) {
            this.flywheelArn(model.flywheelArn);
            this.activeModelArn(model.activeModelArn);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.taskConfig(model.taskConfig);
            this.dataLakeS3Uri(model.dataLakeS3Uri);
            this.dataSecurityConfig(model.dataSecurityConfig);
            this.status(model.status);
            this.modelType(model.modelType);
            this.message(model.message);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.latestFlywheelIteration(model.latestFlywheelIteration);
        }

        public final String getFlywheelArn() {
            return this.flywheelArn;
        }

        public final void setFlywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
        }

        @Override
        public final Builder flywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
            return this;
        }

        public final String getActiveModelArn() {
            return this.activeModelArn;
        }

        public final void setActiveModelArn(String activeModelArn) {
            this.activeModelArn = activeModelArn;
        }

        @Override
        public final Builder activeModelArn(String activeModelArn) {
            this.activeModelArn = activeModelArn;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final TaskConfig.Builder getTaskConfig() {
            return this.taskConfig != null ? this.taskConfig.toBuilder() : null;
        }

        public final void setTaskConfig(TaskConfig.BuilderImpl taskConfig) {
            this.taskConfig = taskConfig != null ? taskConfig.build() : null;
        }

        @Override
        public final Builder taskConfig(TaskConfig taskConfig) {
            this.taskConfig = taskConfig;
            return this;
        }

        public final String getDataLakeS3Uri() {
            return this.dataLakeS3Uri;
        }

        public final void setDataLakeS3Uri(String dataLakeS3Uri) {
            this.dataLakeS3Uri = dataLakeS3Uri;
        }

        @Override
        public final Builder dataLakeS3Uri(String dataLakeS3Uri) {
            this.dataLakeS3Uri = dataLakeS3Uri;
            return this;
        }

        public final DataSecurityConfig.Builder getDataSecurityConfig() {
            return this.dataSecurityConfig != null ? this.dataSecurityConfig.toBuilder() : null;
        }

        public final void setDataSecurityConfig(DataSecurityConfig.BuilderImpl dataSecurityConfig) {
            this.dataSecurityConfig = dataSecurityConfig != null ? dataSecurityConfig.build() : null;
        }

        @Override
        public final Builder dataSecurityConfig(DataSecurityConfig dataSecurityConfig) {
            this.dataSecurityConfig = dataSecurityConfig;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FlywheelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getModelType() {
            return this.modelType;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        public final Builder modelType(ModelType modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLatestFlywheelIteration() {
            return this.latestFlywheelIteration;
        }

        public final void setLatestFlywheelIteration(String latestFlywheelIteration) {
            this.latestFlywheelIteration = latestFlywheelIteration;
        }

        @Override
        public final Builder latestFlywheelIteration(String latestFlywheelIteration) {
            this.latestFlywheelIteration = latestFlywheelIteration;
            return this;
        }

        public FlywheelProperties build() {
            return new FlywheelProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlywheelProperties> {
        public Builder flywheelArn(String var1);

        public Builder activeModelArn(String var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder taskConfig(TaskConfig var1);

        default public Builder taskConfig(Consumer<TaskConfig.Builder> taskConfig) {
            return this.taskConfig((TaskConfig)((TaskConfig.Builder)TaskConfig.builder().applyMutation(taskConfig)).build());
        }

        public Builder dataLakeS3Uri(String var1);

        public Builder dataSecurityConfig(DataSecurityConfig var1);

        default public Builder dataSecurityConfig(Consumer<DataSecurityConfig.Builder> dataSecurityConfig) {
            return this.dataSecurityConfig((DataSecurityConfig)((DataSecurityConfig.Builder)DataSecurityConfig.builder().applyMutation(dataSecurityConfig)).build());
        }

        public Builder status(String var1);

        public Builder status(FlywheelStatus var1);

        public Builder modelType(String var1);

        public Builder modelType(ModelType var1);

        public Builder message(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder latestFlywheelIteration(String var1);
    }
}

