/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.EntityRecognizerProperties;
import software.amazon.awssdk.services.comprehend.model.EntityRecognizerPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEntityRecognizersResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListEntityRecognizersResponse> {
    private static final SdkField<List<EntityRecognizerProperties>> ENTITY_RECOGNIZER_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntityRecognizerPropertiesList").getter(ListEntityRecognizersResponse.getter(ListEntityRecognizersResponse::entityRecognizerPropertiesList)).setter(ListEntityRecognizersResponse.setter(Builder::entityRecognizerPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityRecognizerPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityRecognizerProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEntityRecognizersResponse.getter(ListEntityRecognizersResponse::nextToken)).setter(ListEntityRecognizersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_RECOGNIZER_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEntityRecognizersResponse.memberNameToFieldInitializer();
    private final List<EntityRecognizerProperties> entityRecognizerPropertiesList;
    private final String nextToken;

    private ListEntityRecognizersResponse(BuilderImpl builder) {
        super(builder);
        this.entityRecognizerPropertiesList = builder.entityRecognizerPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEntityRecognizerPropertiesList() {
        return this.entityRecognizerPropertiesList != null && !(this.entityRecognizerPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<EntityRecognizerProperties> entityRecognizerPropertiesList() {
        return this.entityRecognizerPropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntityRecognizerPropertiesList() ? this.entityRecognizerPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntityRecognizersResponse)) {
            return false;
        }
        ListEntityRecognizersResponse other = (ListEntityRecognizersResponse)((Object)obj);
        return this.hasEntityRecognizerPropertiesList() == other.hasEntityRecognizerPropertiesList() && Objects.equals(this.entityRecognizerPropertiesList(), other.entityRecognizerPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEntityRecognizersResponse").add("EntityRecognizerPropertiesList", this.hasEntityRecognizerPropertiesList() ? this.entityRecognizerPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityRecognizerPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.entityRecognizerPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EntityRecognizerPropertiesList", ENTITY_RECOGNIZER_PROPERTIES_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEntityRecognizersResponse, T> g) {
        return obj -> g.apply((ListEntityRecognizersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<EntityRecognizerProperties> entityRecognizerPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntityRecognizersResponse model) {
            super(model);
            this.entityRecognizerPropertiesList(model.entityRecognizerPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final List<EntityRecognizerProperties.Builder> getEntityRecognizerPropertiesList() {
            List<EntityRecognizerProperties.Builder> result = EntityRecognizerPropertiesListCopier.copyToBuilder(this.entityRecognizerPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntityRecognizerPropertiesList(Collection<EntityRecognizerProperties.BuilderImpl> entityRecognizerPropertiesList) {
            this.entityRecognizerPropertiesList = EntityRecognizerPropertiesListCopier.copyFromBuilder(entityRecognizerPropertiesList);
        }

        @Override
        public final Builder entityRecognizerPropertiesList(Collection<EntityRecognizerProperties> entityRecognizerPropertiesList) {
            this.entityRecognizerPropertiesList = EntityRecognizerPropertiesListCopier.copy(entityRecognizerPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityRecognizerPropertiesList(EntityRecognizerProperties ... entityRecognizerPropertiesList) {
            this.entityRecognizerPropertiesList(Arrays.asList(entityRecognizerPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityRecognizerPropertiesList(Consumer<EntityRecognizerProperties.Builder> ... entityRecognizerPropertiesList) {
            this.entityRecognizerPropertiesList(Stream.of(entityRecognizerPropertiesList).map(c -> (EntityRecognizerProperties)((EntityRecognizerProperties.Builder)EntityRecognizerProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEntityRecognizersResponse build() {
            return new ListEntityRecognizersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEntityRecognizersResponse> {
        public Builder entityRecognizerPropertiesList(Collection<EntityRecognizerProperties> var1);

        public Builder entityRecognizerPropertiesList(EntityRecognizerProperties ... var1);

        public Builder entityRecognizerPropertiesList(Consumer<EntityRecognizerProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

