/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEndpointRequest
extends ComprehendRequest
implements ToCopyableBuilder<Builder, UpdateEndpointRequest> {
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointArn").getter(UpdateEndpointRequest.getter(UpdateEndpointRequest::endpointArn)).setter(UpdateEndpointRequest.setter(Builder::endpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()}).build();
    private static final SdkField<String> DESIRED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DesiredModelArn").getter(UpdateEndpointRequest.getter(UpdateEndpointRequest::desiredModelArn)).setter(UpdateEndpointRequest.setter(Builder::desiredModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredModelArn").build()}).build();
    private static final SdkField<Integer> DESIRED_INFERENCE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DesiredInferenceUnits").getter(UpdateEndpointRequest.getter(UpdateEndpointRequest::desiredInferenceUnits)).setter(UpdateEndpointRequest.setter(Builder::desiredInferenceUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredInferenceUnits").build()}).build();
    private static final SdkField<String> DESIRED_DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DesiredDataAccessRoleArn").getter(UpdateEndpointRequest.getter(UpdateEndpointRequest::desiredDataAccessRoleArn)).setter(UpdateEndpointRequest.setter(Builder::desiredDataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredDataAccessRoleArn").build()}).build();
    private static final SdkField<String> FLYWHEEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlywheelArn").getter(UpdateEndpointRequest.getter(UpdateEndpointRequest::flywheelArn)).setter(UpdateEndpointRequest.setter(Builder::flywheelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ARN_FIELD, DESIRED_MODEL_ARN_FIELD, DESIRED_INFERENCE_UNITS_FIELD, DESIRED_DATA_ACCESS_ROLE_ARN_FIELD, FLYWHEEL_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateEndpointRequest.memberNameToFieldInitializer();
    private final String endpointArn;
    private final String desiredModelArn;
    private final Integer desiredInferenceUnits;
    private final String desiredDataAccessRoleArn;
    private final String flywheelArn;

    private UpdateEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointArn = builder.endpointArn;
        this.desiredModelArn = builder.desiredModelArn;
        this.desiredInferenceUnits = builder.desiredInferenceUnits;
        this.desiredDataAccessRoleArn = builder.desiredDataAccessRoleArn;
        this.flywheelArn = builder.flywheelArn;
    }

    public final String endpointArn() {
        return this.endpointArn;
    }

    public final String desiredModelArn() {
        return this.desiredModelArn;
    }

    public final Integer desiredInferenceUnits() {
        return this.desiredInferenceUnits;
    }

    public final String desiredDataAccessRoleArn() {
        return this.desiredDataAccessRoleArn;
    }

    public final String flywheelArn() {
        return this.flywheelArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredDataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flywheelArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointRequest)) {
            return false;
        }
        UpdateEndpointRequest other = (UpdateEndpointRequest)((Object)obj);
        return Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.desiredModelArn(), other.desiredModelArn()) && Objects.equals(this.desiredInferenceUnits(), other.desiredInferenceUnits()) && Objects.equals(this.desiredDataAccessRoleArn(), other.desiredDataAccessRoleArn()) && Objects.equals(this.flywheelArn(), other.flywheelArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEndpointRequest").add("EndpointArn", (Object)this.endpointArn()).add("DesiredModelArn", (Object)this.desiredModelArn()).add("DesiredInferenceUnits", (Object)this.desiredInferenceUnits()).add("DesiredDataAccessRoleArn", (Object)this.desiredDataAccessRoleArn()).add("FlywheelArn", (Object)this.flywheelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "DesiredModelArn": {
                return Optional.ofNullable(clazz.cast(this.desiredModelArn()));
            }
            case "DesiredInferenceUnits": {
                return Optional.ofNullable(clazz.cast(this.desiredInferenceUnits()));
            }
            case "DesiredDataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.desiredDataAccessRoleArn()));
            }
            case "FlywheelArn": {
                return Optional.ofNullable(clazz.cast(this.flywheelArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EndpointArn", ENDPOINT_ARN_FIELD);
        map.put("DesiredModelArn", DESIRED_MODEL_ARN_FIELD);
        map.put("DesiredInferenceUnits", DESIRED_INFERENCE_UNITS_FIELD);
        map.put("DesiredDataAccessRoleArn", DESIRED_DATA_ACCESS_ROLE_ARN_FIELD);
        map.put("FlywheelArn", FLYWHEEL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndpointRequest, T> g) {
        return obj -> g.apply((UpdateEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendRequest.BuilderImpl
    implements Builder {
        private String endpointArn;
        private String desiredModelArn;
        private Integer desiredInferenceUnits;
        private String desiredDataAccessRoleArn;
        private String flywheelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointRequest model) {
            super(model);
            this.endpointArn(model.endpointArn);
            this.desiredModelArn(model.desiredModelArn);
            this.desiredInferenceUnits(model.desiredInferenceUnits);
            this.desiredDataAccessRoleArn(model.desiredDataAccessRoleArn);
            this.flywheelArn(model.flywheelArn);
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final String getDesiredModelArn() {
            return this.desiredModelArn;
        }

        public final void setDesiredModelArn(String desiredModelArn) {
            this.desiredModelArn = desiredModelArn;
        }

        @Override
        public final Builder desiredModelArn(String desiredModelArn) {
            this.desiredModelArn = desiredModelArn;
            return this;
        }

        public final Integer getDesiredInferenceUnits() {
            return this.desiredInferenceUnits;
        }

        public final void setDesiredInferenceUnits(Integer desiredInferenceUnits) {
            this.desiredInferenceUnits = desiredInferenceUnits;
        }

        @Override
        public final Builder desiredInferenceUnits(Integer desiredInferenceUnits) {
            this.desiredInferenceUnits = desiredInferenceUnits;
            return this;
        }

        public final String getDesiredDataAccessRoleArn() {
            return this.desiredDataAccessRoleArn;
        }

        public final void setDesiredDataAccessRoleArn(String desiredDataAccessRoleArn) {
            this.desiredDataAccessRoleArn = desiredDataAccessRoleArn;
        }

        @Override
        public final Builder desiredDataAccessRoleArn(String desiredDataAccessRoleArn) {
            this.desiredDataAccessRoleArn = desiredDataAccessRoleArn;
            return this;
        }

        public final String getFlywheelArn() {
            return this.flywheelArn;
        }

        public final void setFlywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
        }

        @Override
        public final Builder flywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEndpointRequest build() {
            return new UpdateEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComprehendRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEndpointRequest> {
        public Builder endpointArn(String var1);

        public Builder desiredModelArn(String var1);

        public Builder desiredInferenceUnits(Integer var1);

        public Builder desiredDataAccessRoleArn(String var1);

        public Builder flywheelArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

