/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.JobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartEntitiesDetectionJobResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, StartEntitiesDetectionJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(StartEntitiesDetectionJobResponse.getter(StartEntitiesDetectionJobResponse::jobId)).setter(StartEntitiesDetectionJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobArn").getter(StartEntitiesDetectionJobResponse.getter(StartEntitiesDetectionJobResponse::jobArn)).setter(StartEntitiesDetectionJobResponse.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobArn").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(StartEntitiesDetectionJobResponse.getter(StartEntitiesDetectionJobResponse::jobStatusAsString)).setter(StartEntitiesDetectionJobResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<String> ENTITY_RECOGNIZER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityRecognizerArn").getter(StartEntitiesDetectionJobResponse.getter(StartEntitiesDetectionJobResponse::entityRecognizerArn)).setter(StartEntitiesDetectionJobResponse.setter(Builder::entityRecognizerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityRecognizerArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_ARN_FIELD, JOB_STATUS_FIELD, ENTITY_RECOGNIZER_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartEntitiesDetectionJobResponse.memberNameToFieldInitializer();
    private final String jobId;
    private final String jobArn;
    private final String jobStatus;
    private final String entityRecognizerArn;

    private StartEntitiesDetectionJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.jobArn = builder.jobArn;
        this.jobStatus = builder.jobStatus;
        this.entityRecognizerArn = builder.entityRecognizerArn;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final String entityRecognizerArn() {
        return this.entityRecognizerArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityRecognizerArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartEntitiesDetectionJobResponse)) {
            return false;
        }
        StartEntitiesDetectionJobResponse other = (StartEntitiesDetectionJobResponse)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.entityRecognizerArn(), other.entityRecognizerArn());
    }

    public final String toString() {
        return ToString.builder((String)"StartEntitiesDetectionJobResponse").add("JobId", (Object)this.jobId()).add("JobArn", (Object)this.jobArn()).add("JobStatus", (Object)this.jobStatusAsString()).add("EntityRecognizerArn", (Object)this.entityRecognizerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "JobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "EntityRecognizerArn": {
                return Optional.ofNullable(clazz.cast(this.entityRecognizerArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("JobArn", JOB_ARN_FIELD);
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("EntityRecognizerArn", ENTITY_RECOGNIZER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartEntitiesDetectionJobResponse, T> g) {
        return obj -> g.apply((StartEntitiesDetectionJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private String jobId;
        private String jobArn;
        private String jobStatus;
        private String entityRecognizerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartEntitiesDetectionJobResponse model) {
            super(model);
            this.jobId(model.jobId);
            this.jobArn(model.jobArn);
            this.jobStatus(model.jobStatus);
            this.entityRecognizerArn(model.entityRecognizerArn);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getEntityRecognizerArn() {
            return this.entityRecognizerArn;
        }

        public final void setEntityRecognizerArn(String entityRecognizerArn) {
            this.entityRecognizerArn = entityRecognizerArn;
        }

        @Override
        public final Builder entityRecognizerArn(String entityRecognizerArn) {
            this.entityRecognizerArn = entityRecognizerArn;
            return this;
        }

        @Override
        public StartEntitiesDetectionJobResponse build() {
            return new StartEntitiesDetectionJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartEntitiesDetectionJobResponse> {
        public Builder jobId(String var1);

        public Builder jobArn(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder entityRecognizerArn(String var1);
    }
}

