/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse;

public class ListSentimentDetectionJobsPublisher
implements SdkPublisher<ListSentimentDetectionJobsResponse> {
    private final ComprehendAsyncClient client;
    private final ListSentimentDetectionJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSentimentDetectionJobsPublisher(ComprehendAsyncClient client, ListSentimentDetectionJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSentimentDetectionJobsPublisher(ComprehendAsyncClient client, ListSentimentDetectionJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSentimentDetectionJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSentimentDetectionJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListSentimentDetectionJobsPublisher resume(ListSentimentDetectionJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSentimentDetectionJobsPublisher(this.client, (ListSentimentDetectionJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListSentimentDetectionJobsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListSentimentDetectionJobsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListSentimentDetectionJobsResponseFetcher
    implements AsyncPageFetcher<ListSentimentDetectionJobsResponse> {
        private ListSentimentDetectionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListSentimentDetectionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSentimentDetectionJobsResponse> nextPage(ListSentimentDetectionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListSentimentDetectionJobsPublisher.this.client.listSentimentDetectionJobs(ListSentimentDetectionJobsPublisher.this.firstRequest);
            }
            return ListSentimentDetectionJobsPublisher.this.client.listSentimentDetectionJobs((ListSentimentDetectionJobsRequest)((Object)ListSentimentDetectionJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

