/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.EndpointStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointProperties> {
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointArn").getter(EndpointProperties.getter(EndpointProperties::endpointArn)).setter(EndpointProperties.setter(Builder::endpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EndpointProperties.getter(EndpointProperties::statusAsString)).setter(EndpointProperties.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(EndpointProperties.getter(EndpointProperties::message)).setter(EndpointProperties.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArn").getter(EndpointProperties.getter(EndpointProperties::modelArn)).setter(EndpointProperties.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final SdkField<String> DESIRED_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DesiredModelArn").getter(EndpointProperties.getter(EndpointProperties::desiredModelArn)).setter(EndpointProperties.setter(Builder::desiredModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredModelArn").build()}).build();
    private static final SdkField<Integer> DESIRED_INFERENCE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DesiredInferenceUnits").getter(EndpointProperties.getter(EndpointProperties::desiredInferenceUnits)).setter(EndpointProperties.setter(Builder::desiredInferenceUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredInferenceUnits").build()}).build();
    private static final SdkField<Integer> CURRENT_INFERENCE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CurrentInferenceUnits").getter(EndpointProperties.getter(EndpointProperties::currentInferenceUnits)).setter(EndpointProperties.setter(Builder::currentInferenceUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentInferenceUnits").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(EndpointProperties.getter(EndpointProperties::creationTime)).setter(EndpointProperties.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(EndpointProperties.getter(EndpointProperties::lastModifiedTime)).setter(EndpointProperties.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(EndpointProperties.getter(EndpointProperties::dataAccessRoleArn)).setter(EndpointProperties.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<String> DESIRED_DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DesiredDataAccessRoleArn").getter(EndpointProperties.getter(EndpointProperties::desiredDataAccessRoleArn)).setter(EndpointProperties.setter(Builder::desiredDataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredDataAccessRoleArn").build()}).build();
    private static final SdkField<String> FLYWHEEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlywheelArn").getter(EndpointProperties.getter(EndpointProperties::flywheelArn)).setter(EndpointProperties.setter(Builder::flywheelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ARN_FIELD, STATUS_FIELD, MESSAGE_FIELD, MODEL_ARN_FIELD, DESIRED_MODEL_ARN_FIELD, DESIRED_INFERENCE_UNITS_FIELD, CURRENT_INFERENCE_UNITS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, DESIRED_DATA_ACCESS_ROLE_ARN_FIELD, FLYWHEEL_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EndpointProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String endpointArn;
    private final String status;
    private final String message;
    private final String modelArn;
    private final String desiredModelArn;
    private final Integer desiredInferenceUnits;
    private final Integer currentInferenceUnits;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String dataAccessRoleArn;
    private final String desiredDataAccessRoleArn;
    private final String flywheelArn;

    private EndpointProperties(BuilderImpl builder) {
        this.endpointArn = builder.endpointArn;
        this.status = builder.status;
        this.message = builder.message;
        this.modelArn = builder.modelArn;
        this.desiredModelArn = builder.desiredModelArn;
        this.desiredInferenceUnits = builder.desiredInferenceUnits;
        this.currentInferenceUnits = builder.currentInferenceUnits;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.desiredDataAccessRoleArn = builder.desiredDataAccessRoleArn;
        this.flywheelArn = builder.flywheelArn;
    }

    public final String endpointArn() {
        return this.endpointArn;
    }

    public final EndpointStatus status() {
        return EndpointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String message() {
        return this.message;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final String desiredModelArn() {
        return this.desiredModelArn;
    }

    public final Integer desiredInferenceUnits() {
        return this.desiredInferenceUnits;
    }

    public final Integer currentInferenceUnits() {
        return this.currentInferenceUnits;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public final String desiredDataAccessRoleArn() {
        return this.desiredDataAccessRoleArn;
    }

    public final String flywheelArn() {
        return this.flywheelArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredDataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flywheelArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointProperties)) {
            return false;
        }
        EndpointProperties other = (EndpointProperties)obj;
        return Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.desiredModelArn(), other.desiredModelArn()) && Objects.equals(this.desiredInferenceUnits(), other.desiredInferenceUnits()) && Objects.equals(this.currentInferenceUnits(), other.currentInferenceUnits()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.desiredDataAccessRoleArn(), other.desiredDataAccessRoleArn()) && Objects.equals(this.flywheelArn(), other.flywheelArn());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointProperties").add("EndpointArn", (Object)this.endpointArn()).add("Status", (Object)this.statusAsString()).add("Message", (Object)this.message()).add("ModelArn", (Object)this.modelArn()).add("DesiredModelArn", (Object)this.desiredModelArn()).add("DesiredInferenceUnits", (Object)this.desiredInferenceUnits()).add("CurrentInferenceUnits", (Object)this.currentInferenceUnits()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("DesiredDataAccessRoleArn", (Object)this.desiredDataAccessRoleArn()).add("FlywheelArn", (Object)this.flywheelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "DesiredModelArn": {
                return Optional.ofNullable(clazz.cast(this.desiredModelArn()));
            }
            case "DesiredInferenceUnits": {
                return Optional.ofNullable(clazz.cast(this.desiredInferenceUnits()));
            }
            case "CurrentInferenceUnits": {
                return Optional.ofNullable(clazz.cast(this.currentInferenceUnits()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "DesiredDataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.desiredDataAccessRoleArn()));
            }
            case "FlywheelArn": {
                return Optional.ofNullable(clazz.cast(this.flywheelArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EndpointArn", ENDPOINT_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("ModelArn", MODEL_ARN_FIELD);
        map.put("DesiredModelArn", DESIRED_MODEL_ARN_FIELD);
        map.put("DesiredInferenceUnits", DESIRED_INFERENCE_UNITS_FIELD);
        map.put("CurrentInferenceUnits", CURRENT_INFERENCE_UNITS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
        map.put("DesiredDataAccessRoleArn", DESIRED_DATA_ACCESS_ROLE_ARN_FIELD);
        map.put("FlywheelArn", FLYWHEEL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EndpointProperties, T> g) {
        return obj -> g.apply((EndpointProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointArn;
        private String status;
        private String message;
        private String modelArn;
        private String desiredModelArn;
        private Integer desiredInferenceUnits;
        private Integer currentInferenceUnits;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String dataAccessRoleArn;
        private String desiredDataAccessRoleArn;
        private String flywheelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointProperties model) {
            this.endpointArn(model.endpointArn);
            this.status(model.status);
            this.message(model.message);
            this.modelArn(model.modelArn);
            this.desiredModelArn(model.desiredModelArn);
            this.desiredInferenceUnits(model.desiredInferenceUnits);
            this.currentInferenceUnits(model.currentInferenceUnits);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.desiredDataAccessRoleArn(model.desiredDataAccessRoleArn);
            this.flywheelArn(model.flywheelArn);
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getDesiredModelArn() {
            return this.desiredModelArn;
        }

        public final void setDesiredModelArn(String desiredModelArn) {
            this.desiredModelArn = desiredModelArn;
        }

        @Override
        public final Builder desiredModelArn(String desiredModelArn) {
            this.desiredModelArn = desiredModelArn;
            return this;
        }

        public final Integer getDesiredInferenceUnits() {
            return this.desiredInferenceUnits;
        }

        public final void setDesiredInferenceUnits(Integer desiredInferenceUnits) {
            this.desiredInferenceUnits = desiredInferenceUnits;
        }

        @Override
        public final Builder desiredInferenceUnits(Integer desiredInferenceUnits) {
            this.desiredInferenceUnits = desiredInferenceUnits;
            return this;
        }

        public final Integer getCurrentInferenceUnits() {
            return this.currentInferenceUnits;
        }

        public final void setCurrentInferenceUnits(Integer currentInferenceUnits) {
            this.currentInferenceUnits = currentInferenceUnits;
        }

        @Override
        public final Builder currentInferenceUnits(Integer currentInferenceUnits) {
            this.currentInferenceUnits = currentInferenceUnits;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getDesiredDataAccessRoleArn() {
            return this.desiredDataAccessRoleArn;
        }

        public final void setDesiredDataAccessRoleArn(String desiredDataAccessRoleArn) {
            this.desiredDataAccessRoleArn = desiredDataAccessRoleArn;
        }

        @Override
        public final Builder desiredDataAccessRoleArn(String desiredDataAccessRoleArn) {
            this.desiredDataAccessRoleArn = desiredDataAccessRoleArn;
            return this;
        }

        public final String getFlywheelArn() {
            return this.flywheelArn;
        }

        public final void setFlywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
        }

        @Override
        public final Builder flywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
            return this;
        }

        public EndpointProperties build() {
            return new EndpointProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointProperties> {
        public Builder endpointArn(String var1);

        public Builder status(String var1);

        public Builder status(EndpointStatus var1);

        public Builder message(String var1);

        public Builder modelArn(String var1);

        public Builder desiredModelArn(String var1);

        public Builder desiredInferenceUnits(Integer var1);

        public Builder currentInferenceUnits(Integer var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder desiredDataAccessRoleArn(String var1);

        public Builder flywheelArn(String var1);
    }
}

