/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.FlywheelStatus;
import software.amazon.awssdk.services.comprehend.model.ModelType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlywheelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlywheelSummary> {
    private static final SdkField<String> FLYWHEEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlywheelArn").getter(FlywheelSummary.getter(FlywheelSummary::flywheelArn)).setter(FlywheelSummary.setter(Builder::flywheelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelArn").build()}).build();
    private static final SdkField<String> ACTIVE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveModelArn").getter(FlywheelSummary.getter(FlywheelSummary::activeModelArn)).setter(FlywheelSummary.setter(Builder::activeModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveModelArn").build()}).build();
    private static final SdkField<String> DATA_LAKE_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataLakeS3Uri").getter(FlywheelSummary.getter(FlywheelSummary::dataLakeS3Uri)).setter(FlywheelSummary.setter(Builder::dataLakeS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeS3Uri").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(FlywheelSummary.getter(FlywheelSummary::statusAsString)).setter(FlywheelSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelType").getter(FlywheelSummary.getter(FlywheelSummary::modelTypeAsString)).setter(FlywheelSummary.setter(Builder::modelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelType").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(FlywheelSummary.getter(FlywheelSummary::message)).setter(FlywheelSummary.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(FlywheelSummary.getter(FlywheelSummary::creationTime)).setter(FlywheelSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(FlywheelSummary.getter(FlywheelSummary::lastModifiedTime)).setter(FlywheelSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LATEST_FLYWHEEL_ITERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestFlywheelIteration").getter(FlywheelSummary.getter(FlywheelSummary::latestFlywheelIteration)).setter(FlywheelSummary.setter(Builder::latestFlywheelIteration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestFlywheelIteration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLYWHEEL_ARN_FIELD, ACTIVE_MODEL_ARN_FIELD, DATA_LAKE_S3_URI_FIELD, STATUS_FIELD, MODEL_TYPE_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LATEST_FLYWHEEL_ITERATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FlywheelArn", FLYWHEEL_ARN_FIELD);
            this.put("ActiveModelArn", ACTIVE_MODEL_ARN_FIELD);
            this.put("DataLakeS3Uri", DATA_LAKE_S3_URI_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("ModelType", MODEL_TYPE_FIELD);
            this.put("Message", MESSAGE_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
            this.put("LatestFlywheelIteration", LATEST_FLYWHEEL_ITERATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String flywheelArn;
    private final String activeModelArn;
    private final String dataLakeS3Uri;
    private final String status;
    private final String modelType;
    private final String message;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String latestFlywheelIteration;

    private FlywheelSummary(BuilderImpl builder) {
        this.flywheelArn = builder.flywheelArn;
        this.activeModelArn = builder.activeModelArn;
        this.dataLakeS3Uri = builder.dataLakeS3Uri;
        this.status = builder.status;
        this.modelType = builder.modelType;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.latestFlywheelIteration = builder.latestFlywheelIteration;
    }

    public final String flywheelArn() {
        return this.flywheelArn;
    }

    public final String activeModelArn() {
        return this.activeModelArn;
    }

    public final String dataLakeS3Uri() {
        return this.dataLakeS3Uri;
    }

    public final FlywheelStatus status() {
        return FlywheelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ModelType modelType() {
        return ModelType.fromValue(this.modelType);
    }

    public final String modelTypeAsString() {
        return this.modelType;
    }

    public final String message() {
        return this.message;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String latestFlywheelIteration() {
        return this.latestFlywheelIteration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flywheelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLakeS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestFlywheelIteration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlywheelSummary)) {
            return false;
        }
        FlywheelSummary other = (FlywheelSummary)obj;
        return Objects.equals(this.flywheelArn(), other.flywheelArn()) && Objects.equals(this.activeModelArn(), other.activeModelArn()) && Objects.equals(this.dataLakeS3Uri(), other.dataLakeS3Uri()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.modelTypeAsString(), other.modelTypeAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.latestFlywheelIteration(), other.latestFlywheelIteration());
    }

    public final String toString() {
        return ToString.builder((String)"FlywheelSummary").add("FlywheelArn", (Object)this.flywheelArn()).add("ActiveModelArn", (Object)this.activeModelArn()).add("DataLakeS3Uri", (Object)this.dataLakeS3Uri()).add("Status", (Object)this.statusAsString()).add("ModelType", (Object)this.modelTypeAsString()).add("Message", (Object)this.message()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LatestFlywheelIteration", (Object)this.latestFlywheelIteration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlywheelArn": {
                return Optional.ofNullable(clazz.cast(this.flywheelArn()));
            }
            case "ActiveModelArn": {
                return Optional.ofNullable(clazz.cast(this.activeModelArn()));
            }
            case "DataLakeS3Uri": {
                return Optional.ofNullable(clazz.cast(this.dataLakeS3Uri()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ModelType": {
                return Optional.ofNullable(clazz.cast(this.modelTypeAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LatestFlywheelIteration": {
                return Optional.ofNullable(clazz.cast(this.latestFlywheelIteration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FlywheelSummary, T> g) {
        return obj -> g.apply((FlywheelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String flywheelArn;
        private String activeModelArn;
        private String dataLakeS3Uri;
        private String status;
        private String modelType;
        private String message;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String latestFlywheelIteration;

        private BuilderImpl() {
        }

        private BuilderImpl(FlywheelSummary model) {
            this.flywheelArn(model.flywheelArn);
            this.activeModelArn(model.activeModelArn);
            this.dataLakeS3Uri(model.dataLakeS3Uri);
            this.status(model.status);
            this.modelType(model.modelType);
            this.message(model.message);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.latestFlywheelIteration(model.latestFlywheelIteration);
        }

        public final String getFlywheelArn() {
            return this.flywheelArn;
        }

        public final void setFlywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
        }

        @Override
        public final Builder flywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
            return this;
        }

        public final String getActiveModelArn() {
            return this.activeModelArn;
        }

        public final void setActiveModelArn(String activeModelArn) {
            this.activeModelArn = activeModelArn;
        }

        @Override
        public final Builder activeModelArn(String activeModelArn) {
            this.activeModelArn = activeModelArn;
            return this;
        }

        public final String getDataLakeS3Uri() {
            return this.dataLakeS3Uri;
        }

        public final void setDataLakeS3Uri(String dataLakeS3Uri) {
            this.dataLakeS3Uri = dataLakeS3Uri;
        }

        @Override
        public final Builder dataLakeS3Uri(String dataLakeS3Uri) {
            this.dataLakeS3Uri = dataLakeS3Uri;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FlywheelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getModelType() {
            return this.modelType;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        public final Builder modelType(ModelType modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLatestFlywheelIteration() {
            return this.latestFlywheelIteration;
        }

        public final void setLatestFlywheelIteration(String latestFlywheelIteration) {
            this.latestFlywheelIteration = latestFlywheelIteration;
        }

        @Override
        public final Builder latestFlywheelIteration(String latestFlywheelIteration) {
            this.latestFlywheelIteration = latestFlywheelIteration;
            return this;
        }

        public FlywheelSummary build() {
            return new FlywheelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlywheelSummary> {
        public Builder flywheelArn(String var1);

        public Builder activeModelArn(String var1);

        public Builder dataLakeS3Uri(String var1);

        public Builder status(String var1);

        public Builder status(FlywheelStatus var1);

        public Builder modelType(String var1);

        public Builder modelType(ModelType var1);

        public Builder message(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder latestFlywheelIteration(String var1);
    }
}

