/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.Block;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.DocumentMetadata;
import software.amazon.awssdk.services.comprehend.model.DocumentTypeListItem;
import software.amazon.awssdk.services.comprehend.model.Entity;
import software.amazon.awssdk.services.comprehend.model.ErrorsListItem;
import software.amazon.awssdk.services.comprehend.model.ListOfBlocksCopier;
import software.amazon.awssdk.services.comprehend.model.ListOfDocumentTypeCopier;
import software.amazon.awssdk.services.comprehend.model.ListOfEntitiesCopier;
import software.amazon.awssdk.services.comprehend.model.ListOfErrorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectEntitiesResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, DetectEntitiesResponse> {
    private static final SdkField<List<Entity>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entities").getter(DetectEntitiesResponse.getter(DetectEntitiesResponse::entities)).setter(DetectEntitiesResponse.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Entity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DocumentMetadata> DOCUMENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentMetadata").getter(DetectEntitiesResponse.getter(DetectEntitiesResponse::documentMetadata)).setter(DetectEntitiesResponse.setter(Builder::documentMetadata)).constructor(DocumentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadata").build()}).build();
    private static final SdkField<List<DocumentTypeListItem>> DOCUMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentType").getter(DetectEntitiesResponse.getter(DetectEntitiesResponse::documentType)).setter(DetectEntitiesResponse.setter(Builder::documentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentTypeListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Block>> BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Blocks").getter(DetectEntitiesResponse.getter(DetectEntitiesResponse::blocks)).setter(DetectEntitiesResponse.setter(Builder::blocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Block::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ErrorsListItem>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(DetectEntitiesResponse.getter(DetectEntitiesResponse::errors)).setter(DetectEntitiesResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorsListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_FIELD, DOCUMENT_METADATA_FIELD, DOCUMENT_TYPE_FIELD, BLOCKS_FIELD, ERRORS_FIELD));
    private final List<Entity> entities;
    private final DocumentMetadata documentMetadata;
    private final List<DocumentTypeListItem> documentType;
    private final List<Block> blocks;
    private final List<ErrorsListItem> errors;

    private DetectEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.entities = builder.entities;
        this.documentMetadata = builder.documentMetadata;
        this.documentType = builder.documentType;
        this.blocks = builder.blocks;
        this.errors = builder.errors;
    }

    public final boolean hasEntities() {
        return this.entities != null && !(this.entities instanceof SdkAutoConstructList);
    }

    public final List<Entity> entities() {
        return this.entities;
    }

    public final DocumentMetadata documentMetadata() {
        return this.documentMetadata;
    }

    public final boolean hasDocumentType() {
        return this.documentType != null && !(this.documentType instanceof SdkAutoConstructList);
    }

    public final List<DocumentTypeListItem> documentType() {
        return this.documentType;
    }

    public final boolean hasBlocks() {
        return this.blocks != null && !(this.blocks instanceof SdkAutoConstructList);
    }

    public final List<Block> blocks() {
        return this.blocks;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<ErrorsListItem> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntities() ? this.entities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.documentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentType() ? this.documentType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlocks() ? this.blocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectEntitiesResponse)) {
            return false;
        }
        DetectEntitiesResponse other = (DetectEntitiesResponse)((Object)obj);
        return this.hasEntities() == other.hasEntities() && Objects.equals(this.entities(), other.entities()) && Objects.equals(this.documentMetadata(), other.documentMetadata()) && this.hasDocumentType() == other.hasDocumentType() && Objects.equals(this.documentType(), other.documentType()) && this.hasBlocks() == other.hasBlocks() && Objects.equals(this.blocks(), other.blocks()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"DetectEntitiesResponse").add("Entities", this.hasEntities() ? this.entities() : null).add("DocumentMetadata", (Object)this.documentMetadata()).add("DocumentType", this.hasDocumentType() ? this.documentType() : null).add("Blocks", this.hasBlocks() ? this.blocks() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
            case "DocumentMetadata": {
                return Optional.ofNullable(clazz.cast(this.documentMetadata()));
            }
            case "DocumentType": {
                return Optional.ofNullable(clazz.cast(this.documentType()));
            }
            case "Blocks": {
                return Optional.ofNullable(clazz.cast(this.blocks()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectEntitiesResponse, T> g) {
        return obj -> g.apply((DetectEntitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<Entity> entities = DefaultSdkAutoConstructList.getInstance();
        private DocumentMetadata documentMetadata;
        private List<DocumentTypeListItem> documentType = DefaultSdkAutoConstructList.getInstance();
        private List<Block> blocks = DefaultSdkAutoConstructList.getInstance();
        private List<ErrorsListItem> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectEntitiesResponse model) {
            super(model);
            this.entities(model.entities);
            this.documentMetadata(model.documentMetadata);
            this.documentType(model.documentType);
            this.blocks(model.blocks);
            this.errors(model.errors);
        }

        public final List<Entity.Builder> getEntities() {
            List<Entity.Builder> result = ListOfEntitiesCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<Entity.BuilderImpl> entities) {
            this.entities = ListOfEntitiesCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<Entity> entities) {
            this.entities = ListOfEntitiesCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Entity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<Entity.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (Entity)((Entity.Builder)Entity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DocumentMetadata.Builder getDocumentMetadata() {
            return this.documentMetadata != null ? this.documentMetadata.toBuilder() : null;
        }

        public final void setDocumentMetadata(DocumentMetadata.BuilderImpl documentMetadata) {
            this.documentMetadata = documentMetadata != null ? documentMetadata.build() : null;
        }

        @Override
        public final Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            return this;
        }

        public final List<DocumentTypeListItem.Builder> getDocumentType() {
            List<DocumentTypeListItem.Builder> result = ListOfDocumentTypeCopier.copyToBuilder(this.documentType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentType(Collection<DocumentTypeListItem.BuilderImpl> documentType) {
            this.documentType = ListOfDocumentTypeCopier.copyFromBuilder(documentType);
        }

        @Override
        public final Builder documentType(Collection<DocumentTypeListItem> documentType) {
            this.documentType = ListOfDocumentTypeCopier.copy(documentType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentType(DocumentTypeListItem ... documentType) {
            this.documentType(Arrays.asList(documentType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentType(Consumer<DocumentTypeListItem.Builder> ... documentType) {
            this.documentType(Stream.of(documentType).map(c -> (DocumentTypeListItem)((DocumentTypeListItem.Builder)DocumentTypeListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Block.Builder> getBlocks() {
            List<Block.Builder> result = ListOfBlocksCopier.copyToBuilder(this.blocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlocks(Collection<Block.BuilderImpl> blocks) {
            this.blocks = ListOfBlocksCopier.copyFromBuilder(blocks);
        }

        @Override
        public final Builder blocks(Collection<Block> blocks) {
            this.blocks = ListOfBlocksCopier.copy(blocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Block ... blocks) {
            this.blocks(Arrays.asList(blocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blocks(Consumer<Block.Builder> ... blocks) {
            this.blocks(Stream.of(blocks).map(c -> (Block)((Block.Builder)Block.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ErrorsListItem.Builder> getErrors() {
            List<ErrorsListItem.Builder> result = ListOfErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<ErrorsListItem.BuilderImpl> errors) {
            this.errors = ListOfErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<ErrorsListItem> errors) {
            this.errors = ListOfErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(ErrorsListItem ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<ErrorsListItem.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (ErrorsListItem)((ErrorsListItem.Builder)ErrorsListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DetectEntitiesResponse build() {
            return new DetectEntitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectEntitiesResponse> {
        public Builder entities(Collection<Entity> var1);

        public Builder entities(Entity ... var1);

        public Builder entities(Consumer<Entity.Builder> ... var1);

        public Builder documentMetadata(DocumentMetadata var1);

        default public Builder documentMetadata(Consumer<DocumentMetadata.Builder> documentMetadata) {
            return this.documentMetadata((DocumentMetadata)((DocumentMetadata.Builder)DocumentMetadata.builder().applyMutation(documentMetadata)).build());
        }

        public Builder documentType(Collection<DocumentTypeListItem> var1);

        public Builder documentType(DocumentTypeListItem ... var1);

        public Builder documentType(Consumer<DocumentTypeListItem.Builder> ... var1);

        public Builder blocks(Collection<Block> var1);

        public Builder blocks(Block ... var1);

        public Builder blocks(Consumer<Block.Builder> ... var1);

        public Builder errors(Collection<ErrorsListItem> var1);

        public Builder errors(ErrorsListItem ... var1);

        public Builder errors(Consumer<ErrorsListItem.Builder> ... var1);
    }
}

