/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DocumentType {
    NATIVE_PDF("NATIVE_PDF"),
    SCANNED_PDF("SCANNED_PDF"),
    MS_WORD("MS_WORD"),
    IMAGE("IMAGE"),
    PLAIN_TEXT("PLAIN_TEXT"),
    TEXTRACT_DETECT_DOCUMENT_TEXT_JSON("TEXTRACT_DETECT_DOCUMENT_TEXT_JSON"),
    TEXTRACT_ANALYZE_DOCUMENT_JSON("TEXTRACT_ANALYZE_DOCUMENT_JSON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DocumentType> VALUE_MAP;
    private final String value;

    private DocumentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentType> knownValues() {
        EnumSet<DocumentType> knownValues = EnumSet.allOf(DocumentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DocumentType.class, DocumentType::toString);
    }
}

