/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelType {
    DOCUMENT_CLASSIFIER("DOCUMENT_CLASSIFIER"),
    ENTITY_RECOGNIZER("ENTITY_RECOGNIZER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelType> VALUE_MAP;
    private final String value;

    private ModelType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelType> knownValues() {
        EnumSet<ModelType> knownValues = EnumSet.allOf(ModelType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelType.class, ModelType::toString);
    }
}

