/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Output data configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityRecognizerOutputDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EntityRecognizerOutputDataConfig.Builder, EntityRecognizerOutputDataConfig> {
    private static final SdkField<String> FLYWHEEL_STATS_S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlywheelStatsS3Prefix").getter(getter(EntityRecognizerOutputDataConfig::flywheelStatsS3Prefix))
            .setter(setter(Builder::flywheelStatsS3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelStatsS3Prefix").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FLYWHEEL_STATS_S3_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String flywheelStatsS3Prefix;

    private EntityRecognizerOutputDataConfig(BuilderImpl builder) {
        this.flywheelStatsS3Prefix = builder.flywheelStatsS3Prefix;
    }

    /**
     * <p>
     * The Amazon S3 prefix for the data lake location of the flywheel statistics.
     * </p>
     * 
     * @return The Amazon S3 prefix for the data lake location of the flywheel statistics.
     */
    public final String flywheelStatsS3Prefix() {
        return flywheelStatsS3Prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flywheelStatsS3Prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognizerOutputDataConfig)) {
            return false;
        }
        EntityRecognizerOutputDataConfig other = (EntityRecognizerOutputDataConfig) obj;
        return Objects.equals(flywheelStatsS3Prefix(), other.flywheelStatsS3Prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityRecognizerOutputDataConfig").add("FlywheelStatsS3Prefix", flywheelStatsS3Prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlywheelStatsS3Prefix":
            return Optional.ofNullable(clazz.cast(flywheelStatsS3Prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityRecognizerOutputDataConfig, T> g) {
        return obj -> g.apply((EntityRecognizerOutputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityRecognizerOutputDataConfig> {
        /**
         * <p>
         * The Amazon S3 prefix for the data lake location of the flywheel statistics.
         * </p>
         * 
         * @param flywheelStatsS3Prefix
         *        The Amazon S3 prefix for the data lake location of the flywheel statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flywheelStatsS3Prefix(String flywheelStatsS3Prefix);
    }

    static final class BuilderImpl implements Builder {
        private String flywheelStatsS3Prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityRecognizerOutputDataConfig model) {
            flywheelStatsS3Prefix(model.flywheelStatsS3Prefix);
        }

        public final String getFlywheelStatsS3Prefix() {
            return flywheelStatsS3Prefix;
        }

        public final void setFlywheelStatsS3Prefix(String flywheelStatsS3Prefix) {
            this.flywheelStatsS3Prefix = flywheelStatsS3Prefix;
        }

        @Override
        public final Builder flywheelStatsS3Prefix(String flywheelStatsS3Prefix) {
            this.flywheelStatsS3Prefix = flywheelStatsS3Prefix;
            return this;
        }

        @Override
        public EntityRecognizerOutputDataConfig build() {
            return new EntityRecognizerOutputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
