/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelsRequest;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelsResponse;

public class ListFlywheelsIterable
implements SdkIterable<ListFlywheelsResponse> {
    private final ComprehendClient client;
    private final ListFlywheelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFlywheelsIterable(ComprehendClient client, ListFlywheelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFlywheelsResponseFetcher();
    }

    public Iterator<ListFlywheelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListFlywheelsResponseFetcher
    implements SyncPageFetcher<ListFlywheelsResponse> {
        private ListFlywheelsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlywheelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFlywheelsResponse nextPage(ListFlywheelsResponse previousPage) {
            if (previousPage == null) {
                return ListFlywheelsIterable.this.client.listFlywheels(ListFlywheelsIterable.this.firstRequest);
            }
            return ListFlywheelsIterable.this.client.listFlywheels((ListFlywheelsRequest)((Object)ListFlywheelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

