/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DatasetDataFormat {
    COMPREHEND_CSV("COMPREHEND_CSV"),
    AUGMENTED_MANIFEST("AUGMENTED_MANIFEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DatasetDataFormat> VALUE_MAP;
    private final String value;

    private DatasetDataFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DatasetDataFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DatasetDataFormat> knownValues() {
        EnumSet<DatasetDataFormat> knownValues = EnumSet.allOf(DatasetDataFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DatasetDataFormat.class, DatasetDataFormat::toString);
    }
}

