/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InvalidRequestReason {
    INVALID_DOCUMENT("INVALID_DOCUMENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InvalidRequestReason> VALUE_MAP;
    private final String value;

    private InvalidRequestReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InvalidRequestReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InvalidRequestReason> knownValues() {
        EnumSet<InvalidRequestReason> knownValues = EnumSet.allOf(InvalidRequestReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InvalidRequestReason.class, InvalidRequestReason::toString);
    }
}

