/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.EntityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Entity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Entity> {
    private static final SdkField<Float> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(Entity.getter(Entity::score)).setter(Entity.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Entity.getter(Entity::typeAsString)).setter(Entity.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Entity.getter(Entity::text)).setter(Entity.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Entity.getter(Entity::beginOffset)).setter(Entity.setter(Builder::beginOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()}).build();
    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Entity.getter(Entity::endOffset)).setter(Entity.setter(Builder::endOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCORE_FIELD, TYPE_FIELD, TEXT_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD));
    private static final long serialVersionUID = 1L;
    private final Float score;
    private final String type;
    private final String text;
    private final Integer beginOffset;
    private final Integer endOffset;

    private Entity(BuilderImpl builder) {
        this.score = builder.score;
        this.type = builder.type;
        this.text = builder.text;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
    }

    public Float score() {
        return this.score;
    }

    public EntityType type() {
        return EntityType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String text() {
        return this.text;
    }

    public Integer beginOffset() {
        return this.beginOffset;
    }

    public Integer endOffset() {
        return this.endOffset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffset());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)obj;
        return Objects.equals(this.score(), other.score()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.beginOffset(), other.beginOffset()) && Objects.equals(this.endOffset(), other.endOffset());
    }

    public String toString() {
        return ToString.builder((String)"Entity").add("Score", (Object)this.score()).add("Type", (Object)this.typeAsString()).add("Text", (Object)this.text()).add("BeginOffset", (Object)this.beginOffset()).add("EndOffset", (Object)this.endOffset()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "BeginOffset": {
                return Optional.ofNullable(clazz.cast(this.beginOffset()));
            }
            case "EndOffset": {
                return Optional.ofNullable(clazz.cast(this.endOffset()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Entity, T> g) {
        return obj -> g.apply((Entity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float score;
        private String type;
        private String text;
        private Integer beginOffset;
        private Integer endOffset;

        private BuilderImpl() {
        }

        private BuilderImpl(Entity model) {
            this.score(model.score);
            this.type(model.type);
            this.text(model.text);
            this.beginOffset(model.beginOffset);
            this.endOffset(model.endOffset);
        }

        public final Float getScore() {
            return this.score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EntityType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final Integer getBeginOffset() {
            return this.beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        public final Integer getEndOffset() {
            return this.endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        public Entity build() {
            return new Entity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Entity> {
        public Builder score(Float var1);

        public Builder type(String var1);

        public Builder type(EntityType var1);

        public Builder text(String var1);

        public Builder beginOffset(Integer var1);

        public Builder endOffset(Integer var1);
    }
}

