/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.model.EndpointProperties;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsResponse;

public class ListEndpointsPublisher
implements SdkPublisher<ListEndpointsResponse> {
    private final ComprehendAsyncClient client;
    private final ListEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEndpointsPublisher(ComprehendAsyncClient client, ListEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEndpointsPublisher(ComprehendAsyncClient client, ListEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EndpointProperties> endpointPropertiesList() {
        Function<ListEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpointPropertiesList() != null) {
                return response.endpointPropertiesList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEndpointsResponseFetcher
    implements AsyncPageFetcher<ListEndpointsResponse> {
        private ListEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEndpointsResponse> nextPage(ListEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListEndpointsPublisher.this.client.listEndpoints(ListEndpointsPublisher.this.firstRequest);
            }
            return ListEndpointsPublisher.this.client.listEndpoints((ListEndpointsRequest)((Object)ListEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

