/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.DocumentClass;
import software.amazon.awssdk.services.comprehend.model.DocumentLabel;
import software.amazon.awssdk.services.comprehend.model.DocumentMetadata;
import software.amazon.awssdk.services.comprehend.model.DocumentTypeListItem;
import software.amazon.awssdk.services.comprehend.model.ErrorsListItem;
import software.amazon.awssdk.services.comprehend.model.ListOfClassesCopier;
import software.amazon.awssdk.services.comprehend.model.ListOfDocumentTypeCopier;
import software.amazon.awssdk.services.comprehend.model.ListOfErrorsCopier;
import software.amazon.awssdk.services.comprehend.model.ListOfLabelsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClassifyDocumentResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ClassifyDocumentResponse> {
    private static final SdkField<List<DocumentClass>> CLASSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Classes").getter(ClassifyDocumentResponse.getter(ClassifyDocumentResponse::classes)).setter(ClassifyDocumentResponse.setter(Builder::classes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentClass::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DocumentLabel>> LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Labels").getter(ClassifyDocumentResponse.getter(ClassifyDocumentResponse::labels)).setter(ClassifyDocumentResponse.setter(Builder::labels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentLabel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DocumentMetadata> DOCUMENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentMetadata").getter(ClassifyDocumentResponse.getter(ClassifyDocumentResponse::documentMetadata)).setter(ClassifyDocumentResponse.setter(Builder::documentMetadata)).constructor(DocumentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadata").build()}).build();
    private static final SdkField<List<DocumentTypeListItem>> DOCUMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DocumentType").getter(ClassifyDocumentResponse.getter(ClassifyDocumentResponse::documentType)).setter(ClassifyDocumentResponse.setter(Builder::documentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentTypeListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ErrorsListItem>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(ClassifyDocumentResponse.getter(ClassifyDocumentResponse::errors)).setter(ClassifyDocumentResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorsListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSES_FIELD, LABELS_FIELD, DOCUMENT_METADATA_FIELD, DOCUMENT_TYPE_FIELD, ERRORS_FIELD));
    private final List<DocumentClass> classes;
    private final List<DocumentLabel> labels;
    private final DocumentMetadata documentMetadata;
    private final List<DocumentTypeListItem> documentType;
    private final List<ErrorsListItem> errors;

    private ClassifyDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.classes = builder.classes;
        this.labels = builder.labels;
        this.documentMetadata = builder.documentMetadata;
        this.documentType = builder.documentType;
        this.errors = builder.errors;
    }

    public final boolean hasClasses() {
        return this.classes != null && !(this.classes instanceof SdkAutoConstructList);
    }

    public final List<DocumentClass> classes() {
        return this.classes;
    }

    public final boolean hasLabels() {
        return this.labels != null && !(this.labels instanceof SdkAutoConstructList);
    }

    public final List<DocumentLabel> labels() {
        return this.labels;
    }

    public final DocumentMetadata documentMetadata() {
        return this.documentMetadata;
    }

    public final boolean hasDocumentType() {
        return this.documentType != null && !(this.documentType instanceof SdkAutoConstructList);
    }

    public final List<DocumentTypeListItem> documentType() {
        return this.documentType;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<ErrorsListItem> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClasses() ? this.classes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabels() ? this.labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.documentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentType() ? this.documentType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassifyDocumentResponse)) {
            return false;
        }
        ClassifyDocumentResponse other = (ClassifyDocumentResponse)((Object)obj);
        return this.hasClasses() == other.hasClasses() && Objects.equals(this.classes(), other.classes()) && this.hasLabels() == other.hasLabels() && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.documentMetadata(), other.documentMetadata()) && this.hasDocumentType() == other.hasDocumentType() && Objects.equals(this.documentType(), other.documentType()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"ClassifyDocumentResponse").add("Classes", this.hasClasses() ? this.classes() : null).add("Labels", this.hasLabels() ? this.labels() : null).add("DocumentMetadata", (Object)this.documentMetadata()).add("DocumentType", this.hasDocumentType() ? this.documentType() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Classes": {
                return Optional.ofNullable(clazz.cast(this.classes()));
            }
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "DocumentMetadata": {
                return Optional.ofNullable(clazz.cast(this.documentMetadata()));
            }
            case "DocumentType": {
                return Optional.ofNullable(clazz.cast(this.documentType()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClassifyDocumentResponse, T> g) {
        return obj -> g.apply((ClassifyDocumentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<DocumentClass> classes = DefaultSdkAutoConstructList.getInstance();
        private List<DocumentLabel> labels = DefaultSdkAutoConstructList.getInstance();
        private DocumentMetadata documentMetadata;
        private List<DocumentTypeListItem> documentType = DefaultSdkAutoConstructList.getInstance();
        private List<ErrorsListItem> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClassifyDocumentResponse model) {
            super(model);
            this.classes(model.classes);
            this.labels(model.labels);
            this.documentMetadata(model.documentMetadata);
            this.documentType(model.documentType);
            this.errors(model.errors);
        }

        public final List<DocumentClass.Builder> getClasses() {
            List<DocumentClass.Builder> result = ListOfClassesCopier.copyToBuilder(this.classes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClasses(Collection<DocumentClass.BuilderImpl> classes) {
            this.classes = ListOfClassesCopier.copyFromBuilder(classes);
        }

        @Override
        public final Builder classes(Collection<DocumentClass> classes) {
            this.classes = ListOfClassesCopier.copy(classes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classes(DocumentClass ... classes) {
            this.classes(Arrays.asList(classes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classes(Consumer<DocumentClass.Builder> ... classes) {
            this.classes(Stream.of(classes).map(c -> (DocumentClass)((DocumentClass.Builder)DocumentClass.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DocumentLabel.Builder> getLabels() {
            List<DocumentLabel.Builder> result = ListOfLabelsCopier.copyToBuilder(this.labels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabels(Collection<DocumentLabel.BuilderImpl> labels) {
            this.labels = ListOfLabelsCopier.copyFromBuilder(labels);
        }

        @Override
        public final Builder labels(Collection<DocumentLabel> labels) {
            this.labels = ListOfLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(DocumentLabel ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Consumer<DocumentLabel.Builder> ... labels) {
            this.labels(Stream.of(labels).map(c -> (DocumentLabel)((DocumentLabel.Builder)DocumentLabel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DocumentMetadata.Builder getDocumentMetadata() {
            return this.documentMetadata != null ? this.documentMetadata.toBuilder() : null;
        }

        public final void setDocumentMetadata(DocumentMetadata.BuilderImpl documentMetadata) {
            this.documentMetadata = documentMetadata != null ? documentMetadata.build() : null;
        }

        @Override
        public final Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            return this;
        }

        public final List<DocumentTypeListItem.Builder> getDocumentType() {
            List<DocumentTypeListItem.Builder> result = ListOfDocumentTypeCopier.copyToBuilder(this.documentType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentType(Collection<DocumentTypeListItem.BuilderImpl> documentType) {
            this.documentType = ListOfDocumentTypeCopier.copyFromBuilder(documentType);
        }

        @Override
        public final Builder documentType(Collection<DocumentTypeListItem> documentType) {
            this.documentType = ListOfDocumentTypeCopier.copy(documentType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentType(DocumentTypeListItem ... documentType) {
            this.documentType(Arrays.asList(documentType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentType(Consumer<DocumentTypeListItem.Builder> ... documentType) {
            this.documentType(Stream.of(documentType).map(c -> (DocumentTypeListItem)((DocumentTypeListItem.Builder)DocumentTypeListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ErrorsListItem.Builder> getErrors() {
            List<ErrorsListItem.Builder> result = ListOfErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<ErrorsListItem.BuilderImpl> errors) {
            this.errors = ListOfErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<ErrorsListItem> errors) {
            this.errors = ListOfErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(ErrorsListItem ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<ErrorsListItem.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (ErrorsListItem)((ErrorsListItem.Builder)ErrorsListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ClassifyDocumentResponse build() {
            return new ClassifyDocumentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ClassifyDocumentResponse> {
        public Builder classes(Collection<DocumentClass> var1);

        public Builder classes(DocumentClass ... var1);

        public Builder classes(Consumer<DocumentClass.Builder> ... var1);

        public Builder labels(Collection<DocumentLabel> var1);

        public Builder labels(DocumentLabel ... var1);

        public Builder labels(Consumer<DocumentLabel.Builder> ... var1);

        public Builder documentMetadata(DocumentMetadata var1);

        default public Builder documentMetadata(Consumer<DocumentMetadata.Builder> documentMetadata) {
            return this.documentMetadata((DocumentMetadata)((DocumentMetadata.Builder)DocumentMetadata.builder().applyMutation(documentMetadata)).build());
        }

        public Builder documentType(Collection<DocumentTypeListItem> var1);

        public Builder documentType(DocumentTypeListItem ... var1);

        public Builder documentType(Consumer<DocumentTypeListItem.Builder> ... var1);

        public Builder errors(Collection<ErrorsListItem> var1);

        public Builder errors(ErrorsListItem ... var1);

        public Builder errors(Consumer<ErrorsListItem.Builder> ... var1);
    }
}

