/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.Tag;
import software.amazon.awssdk.services.comprehend.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEndpointRequest
extends ComprehendRequest
implements ToCopyableBuilder<Builder, CreateEndpointRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(CreateEndpointRequest.getter(CreateEndpointRequest::endpointName)).setter(CreateEndpointRequest.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArn").getter(CreateEndpointRequest.getter(CreateEndpointRequest::modelArn)).setter(CreateEndpointRequest.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final SdkField<Integer> DESIRED_INFERENCE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DesiredInferenceUnits").getter(CreateEndpointRequest.getter(CreateEndpointRequest::desiredInferenceUnits)).setter(CreateEndpointRequest.setter(Builder::desiredInferenceUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredInferenceUnits").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateEndpointRequest.getter(CreateEndpointRequest::clientRequestToken)).setter(CreateEndpointRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateEndpointRequest.getter(CreateEndpointRequest::tags)).setter(CreateEndpointRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(CreateEndpointRequest.getter(CreateEndpointRequest::dataAccessRoleArn)).setter(CreateEndpointRequest.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, MODEL_ARN_FIELD, DESIRED_INFERENCE_UNITS_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD, DATA_ACCESS_ROLE_ARN_FIELD));
    private final String endpointName;
    private final String modelArn;
    private final Integer desiredInferenceUnits;
    private final String clientRequestToken;
    private final List<Tag> tags;
    private final String dataAccessRoleArn;

    private CreateEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.modelArn = builder.modelArn;
        this.desiredInferenceUnits = builder.desiredInferenceUnits;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final Integer desiredInferenceUnits() {
        return this.desiredInferenceUnits;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEndpointRequest)) {
            return false;
        }
        CreateEndpointRequest other = (CreateEndpointRequest)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.desiredInferenceUnits(), other.desiredInferenceUnits()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEndpointRequest").add("EndpointName", (Object)this.endpointName()).add("ModelArn", (Object)this.modelArn()).add("DesiredInferenceUnits", (Object)this.desiredInferenceUnits()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.hasTags() ? this.tags() : null).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "DesiredInferenceUnits": {
                return Optional.ofNullable(clazz.cast(this.desiredInferenceUnits()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEndpointRequest, T> g) {
        return obj -> g.apply((CreateEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendRequest.BuilderImpl
    implements Builder {
        private String endpointName;
        private String modelArn;
        private Integer desiredInferenceUnits;
        private String clientRequestToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String dataAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEndpointRequest model) {
            super(model);
            this.endpointName(model.endpointName);
            this.modelArn(model.modelArn);
            this.desiredInferenceUnits(model.desiredInferenceUnits);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        @Transient
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        @Transient
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Integer getDesiredInferenceUnits() {
            return this.desiredInferenceUnits;
        }

        public final void setDesiredInferenceUnits(Integer desiredInferenceUnits) {
            this.desiredInferenceUnits = desiredInferenceUnits;
        }

        @Override
        @Transient
        public final Builder desiredInferenceUnits(Integer desiredInferenceUnits) {
            this.desiredInferenceUnits = desiredInferenceUnits;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        @Transient
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEndpointRequest build() {
            return new CreateEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEndpointRequest> {
        public Builder endpointName(String var1);

        public Builder modelArn(String var1);

        public Builder desiredInferenceUnits(Integer var1);

        public Builder clientRequestToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

