/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse;

public class ListDocumentClassifierSummariesPublisher
implements SdkPublisher<ListDocumentClassifierSummariesResponse> {
    private final ComprehendAsyncClient client;
    private final ListDocumentClassifierSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDocumentClassifierSummariesPublisher(ComprehendAsyncClient client, ListDocumentClassifierSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDocumentClassifierSummariesPublisher(ComprehendAsyncClient client, ListDocumentClassifierSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDocumentClassifierSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDocumentClassifierSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDocumentClassifierSummariesResponseFetcher
    implements AsyncPageFetcher<ListDocumentClassifierSummariesResponse> {
        private ListDocumentClassifierSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListDocumentClassifierSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDocumentClassifierSummariesResponse> nextPage(ListDocumentClassifierSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListDocumentClassifierSummariesPublisher.this.client.listDocumentClassifierSummaries(ListDocumentClassifierSummariesPublisher.this.firstRequest);
            }
            return ListDocumentClassifierSummariesPublisher.this.client.listDocumentClassifierSummaries((ListDocumentClassifierSummariesRequest)((Object)ListDocumentClassifierSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

