/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.AugmentedManifestsListItem;
import software.amazon.awssdk.services.comprehend.model.DocumentClassifierAugmentedManifestsListCopier;
import software.amazon.awssdk.services.comprehend.model.DocumentClassifierDataFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentClassifierInputDataConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentClassifierInputDataConfig> {
    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataFormat").getter(DocumentClassifierInputDataConfig.getter(DocumentClassifierInputDataConfig::dataFormatAsString)).setter(DocumentClassifierInputDataConfig.setter(Builder::dataFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()}).build();
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Uri").getter(DocumentClassifierInputDataConfig.getter(DocumentClassifierInputDataConfig::s3Uri)).setter(DocumentClassifierInputDataConfig.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final SdkField<String> TEST_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TestS3Uri").getter(DocumentClassifierInputDataConfig.getter(DocumentClassifierInputDataConfig::testS3Uri)).setter(DocumentClassifierInputDataConfig.setter(Builder::testS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestS3Uri").build()}).build();
    private static final SdkField<String> LABEL_DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelDelimiter").getter(DocumentClassifierInputDataConfig.getter(DocumentClassifierInputDataConfig::labelDelimiter)).setter(DocumentClassifierInputDataConfig.setter(Builder::labelDelimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelDelimiter").build()}).build();
    private static final SdkField<List<AugmentedManifestsListItem>> AUGMENTED_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AugmentedManifests").getter(DocumentClassifierInputDataConfig.getter(DocumentClassifierInputDataConfig::augmentedManifests)).setter(DocumentClassifierInputDataConfig.setter(Builder::augmentedManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AugmentedManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AugmentedManifestsListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FORMAT_FIELD, S3_URI_FIELD, TEST_S3_URI_FIELD, LABEL_DELIMITER_FIELD, AUGMENTED_MANIFESTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataFormat;
    private final String s3Uri;
    private final String testS3Uri;
    private final String labelDelimiter;
    private final List<AugmentedManifestsListItem> augmentedManifests;

    private DocumentClassifierInputDataConfig(BuilderImpl builder) {
        this.dataFormat = builder.dataFormat;
        this.s3Uri = builder.s3Uri;
        this.testS3Uri = builder.testS3Uri;
        this.labelDelimiter = builder.labelDelimiter;
        this.augmentedManifests = builder.augmentedManifests;
    }

    public final DocumentClassifierDataFormat dataFormat() {
        return DocumentClassifierDataFormat.fromValue(this.dataFormat);
    }

    public final String dataFormatAsString() {
        return this.dataFormat;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final String testS3Uri() {
        return this.testS3Uri;
    }

    public final String labelDelimiter() {
        return this.labelDelimiter;
    }

    public final boolean hasAugmentedManifests() {
        return this.augmentedManifests != null && !(this.augmentedManifests instanceof SdkAutoConstructList);
    }

    public final List<AugmentedManifestsListItem> augmentedManifests() {
        return this.augmentedManifests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.testS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAugmentedManifests() ? this.augmentedManifests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentClassifierInputDataConfig)) {
            return false;
        }
        DocumentClassifierInputDataConfig other = (DocumentClassifierInputDataConfig)obj;
        return Objects.equals(this.dataFormatAsString(), other.dataFormatAsString()) && Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.testS3Uri(), other.testS3Uri()) && Objects.equals(this.labelDelimiter(), other.labelDelimiter()) && this.hasAugmentedManifests() == other.hasAugmentedManifests() && Objects.equals(this.augmentedManifests(), other.augmentedManifests());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentClassifierInputDataConfig").add("DataFormat", (Object)this.dataFormatAsString()).add("S3Uri", (Object)this.s3Uri()).add("TestS3Uri", (Object)this.testS3Uri()).add("LabelDelimiter", (Object)this.labelDelimiter()).add("AugmentedManifests", this.hasAugmentedManifests() ? this.augmentedManifests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataFormat": {
                return Optional.ofNullable(clazz.cast(this.dataFormatAsString()));
            }
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "TestS3Uri": {
                return Optional.ofNullable(clazz.cast(this.testS3Uri()));
            }
            case "LabelDelimiter": {
                return Optional.ofNullable(clazz.cast(this.labelDelimiter()));
            }
            case "AugmentedManifests": {
                return Optional.ofNullable(clazz.cast(this.augmentedManifests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentClassifierInputDataConfig, T> g) {
        return obj -> g.apply((DocumentClassifierInputDataConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataFormat;
        private String s3Uri;
        private String testS3Uri;
        private String labelDelimiter;
        private List<AugmentedManifestsListItem> augmentedManifests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentClassifierInputDataConfig model) {
            this.dataFormat(model.dataFormat);
            this.s3Uri(model.s3Uri);
            this.testS3Uri(model.testS3Uri);
            this.labelDelimiter(model.labelDelimiter);
            this.augmentedManifests(model.augmentedManifests);
        }

        public final String getDataFormat() {
            return this.dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        @Transient
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder dataFormat(DocumentClassifierDataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        @Transient
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getTestS3Uri() {
            return this.testS3Uri;
        }

        public final void setTestS3Uri(String testS3Uri) {
            this.testS3Uri = testS3Uri;
        }

        @Override
        @Transient
        public final Builder testS3Uri(String testS3Uri) {
            this.testS3Uri = testS3Uri;
            return this;
        }

        public final String getLabelDelimiter() {
            return this.labelDelimiter;
        }

        public final void setLabelDelimiter(String labelDelimiter) {
            this.labelDelimiter = labelDelimiter;
        }

        @Override
        @Transient
        public final Builder labelDelimiter(String labelDelimiter) {
            this.labelDelimiter = labelDelimiter;
            return this;
        }

        public final List<AugmentedManifestsListItem.Builder> getAugmentedManifests() {
            List<AugmentedManifestsListItem.Builder> result = DocumentClassifierAugmentedManifestsListCopier.copyToBuilder(this.augmentedManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAugmentedManifests(Collection<AugmentedManifestsListItem.BuilderImpl> augmentedManifests) {
            this.augmentedManifests = DocumentClassifierAugmentedManifestsListCopier.copyFromBuilder(augmentedManifests);
        }

        @Override
        @Transient
        public final Builder augmentedManifests(Collection<AugmentedManifestsListItem> augmentedManifests) {
            this.augmentedManifests = DocumentClassifierAugmentedManifestsListCopier.copy(augmentedManifests);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder augmentedManifests(AugmentedManifestsListItem ... augmentedManifests) {
            this.augmentedManifests(Arrays.asList(augmentedManifests));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder augmentedManifests(Consumer<AugmentedManifestsListItem.Builder> ... augmentedManifests) {
            this.augmentedManifests(Stream.of(augmentedManifests).map(c -> (AugmentedManifestsListItem)((AugmentedManifestsListItem.Builder)AugmentedManifestsListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DocumentClassifierInputDataConfig build() {
            return new DocumentClassifierInputDataConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentClassifierInputDataConfig> {
        public Builder dataFormat(String var1);

        public Builder dataFormat(DocumentClassifierDataFormat var1);

        public Builder s3Uri(String var1);

        public Builder testS3Uri(String var1);

        public Builder labelDelimiter(String var1);

        public Builder augmentedManifests(Collection<AugmentedManifestsListItem> var1);

        public Builder augmentedManifests(AugmentedManifestsListItem ... var1);

        public Builder augmentedManifests(Consumer<AugmentedManifestsListItem.Builder> ... var1);
    }
}

