/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse;

public class ListEventsDetectionJobsPublisher
implements SdkPublisher<ListEventsDetectionJobsResponse> {
    private final ComprehendAsyncClient client;
    private final ListEventsDetectionJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventsDetectionJobsPublisher(ComprehendAsyncClient client, ListEventsDetectionJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventsDetectionJobsPublisher(ComprehendAsyncClient client, ListEventsDetectionJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventsDetectionJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventsDetectionJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListEventsDetectionJobsResponseFetcher
    implements AsyncPageFetcher<ListEventsDetectionJobsResponse> {
        private ListEventsDetectionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventsDetectionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEventsDetectionJobsResponse> nextPage(ListEventsDetectionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListEventsDetectionJobsPublisher.this.client.listEventsDetectionJobs(ListEventsDetectionJobsPublisher.this.firstRequest);
            }
            return ListEventsDetectionJobsPublisher.this.client.listEventsDetectionJobs((ListEventsDetectionJobsRequest)((Object)ListEventsDetectionJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

