/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Individual item from the list of entity types in the metadata of an entity recognizer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityRecognizerMetadataEntityTypesListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<EntityRecognizerMetadataEntityTypesListItem.Builder, EntityRecognizerMetadataEntityTypesListItem> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(EntityRecognizerMetadataEntityTypesListItem::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<EntityTypesEvaluationMetrics> EVALUATION_METRICS_FIELD = SdkField
            .<EntityTypesEvaluationMetrics> builder(MarshallingType.SDK_POJO).memberName("EvaluationMetrics")
            .getter(getter(EntityRecognizerMetadataEntityTypesListItem::evaluationMetrics))
            .setter(setter(Builder::evaluationMetrics)).constructor(EntityTypesEvaluationMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMetrics").build()).build();

    private static final SdkField<Integer> NUMBER_OF_TRAIN_MENTIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfTrainMentions")
            .getter(getter(EntityRecognizerMetadataEntityTypesListItem::numberOfTrainMentions))
            .setter(setter(Builder::numberOfTrainMentions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTrainMentions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            EVALUATION_METRICS_FIELD, NUMBER_OF_TRAIN_MENTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final EntityTypesEvaluationMetrics evaluationMetrics;

    private final Integer numberOfTrainMentions;

    private EntityRecognizerMetadataEntityTypesListItem(BuilderImpl builder) {
        this.type = builder.type;
        this.evaluationMetrics = builder.evaluationMetrics;
        this.numberOfTrainMentions = builder.numberOfTrainMentions;
    }

    /**
     * <p>
     * Type of entity from the list of entity types in the metadata of an entity recognizer.
     * </p>
     * 
     * @return Type of entity from the list of entity types in the metadata of an entity recognizer.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * Detailed information about the accuracy of the entity recognizer for a specific item on the list of entity types.
     * </p>
     * 
     * @return Detailed information about the accuracy of the entity recognizer for a specific item on the list of
     *         entity types.
     */
    public final EntityTypesEvaluationMetrics evaluationMetrics() {
        return evaluationMetrics;
    }

    /**
     * <p>
     * Indicates the number of times the given entity type was seen in the training data.
     * </p>
     * 
     * @return Indicates the number of times the given entity type was seen in the training data.
     */
    public final Integer numberOfTrainMentions() {
        return numberOfTrainMentions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfTrainMentions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognizerMetadataEntityTypesListItem)) {
            return false;
        }
        EntityRecognizerMetadataEntityTypesListItem other = (EntityRecognizerMetadataEntityTypesListItem) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(evaluationMetrics(), other.evaluationMetrics())
                && Objects.equals(numberOfTrainMentions(), other.numberOfTrainMentions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityRecognizerMetadataEntityTypesListItem").add("Type", type())
                .add("EvaluationMetrics", evaluationMetrics()).add("NumberOfTrainMentions", numberOfTrainMentions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "EvaluationMetrics":
            return Optional.ofNullable(clazz.cast(evaluationMetrics()));
        case "NumberOfTrainMentions":
            return Optional.ofNullable(clazz.cast(numberOfTrainMentions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityRecognizerMetadataEntityTypesListItem, T> g) {
        return obj -> g.apply((EntityRecognizerMetadataEntityTypesListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityRecognizerMetadataEntityTypesListItem> {
        /**
         * <p>
         * Type of entity from the list of entity types in the metadata of an entity recognizer.
         * </p>
         * 
         * @param type
         *        Type of entity from the list of entity types in the metadata of an entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * Detailed information about the accuracy of the entity recognizer for a specific item on the list of entity
         * types.
         * </p>
         * 
         * @param evaluationMetrics
         *        Detailed information about the accuracy of the entity recognizer for a specific item on the list of
         *        entity types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationMetrics(EntityTypesEvaluationMetrics evaluationMetrics);

        /**
         * <p>
         * Detailed information about the accuracy of the entity recognizer for a specific item on the list of entity
         * types.
         * </p>
         * This is a convenience that creates an instance of the {@link EntityTypesEvaluationMetrics.Builder} avoiding
         * the need to create one manually via {@link EntityTypesEvaluationMetrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link EntityTypesEvaluationMetrics.Builder#build()} is called
         * immediately and its result is passed to {@link #evaluationMetrics(EntityTypesEvaluationMetrics)}.
         * 
         * @param evaluationMetrics
         *        a consumer that will call methods on {@link EntityTypesEvaluationMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationMetrics(EntityTypesEvaluationMetrics)
         */
        default Builder evaluationMetrics(Consumer<EntityTypesEvaluationMetrics.Builder> evaluationMetrics) {
            return evaluationMetrics(EntityTypesEvaluationMetrics.builder().applyMutation(evaluationMetrics).build());
        }

        /**
         * <p>
         * Indicates the number of times the given entity type was seen in the training data.
         * </p>
         * 
         * @param numberOfTrainMentions
         *        Indicates the number of times the given entity type was seen in the training data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfTrainMentions(Integer numberOfTrainMentions);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private EntityTypesEvaluationMetrics evaluationMetrics;

        private Integer numberOfTrainMentions;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityRecognizerMetadataEntityTypesListItem model) {
            type(model.type);
            evaluationMetrics(model.evaluationMetrics);
            numberOfTrainMentions(model.numberOfTrainMentions);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final EntityTypesEvaluationMetrics.Builder getEvaluationMetrics() {
            return evaluationMetrics != null ? evaluationMetrics.toBuilder() : null;
        }

        @Override
        public final Builder evaluationMetrics(EntityTypesEvaluationMetrics evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics;
            return this;
        }

        public final void setEvaluationMetrics(EntityTypesEvaluationMetrics.BuilderImpl evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics != null ? evaluationMetrics.build() : null;
        }

        public final Integer getNumberOfTrainMentions() {
            return numberOfTrainMentions;
        }

        @Override
        public final Builder numberOfTrainMentions(Integer numberOfTrainMentions) {
            this.numberOfTrainMentions = numberOfTrainMentions;
            return this;
        }

        public final void setNumberOfTrainMentions(Integer numberOfTrainMentions) {
            this.numberOfTrainMentions = numberOfTrainMentions;
        }

        @Override
        public EntityRecognizerMetadataEntityTypesListItem build() {
            return new EntityRecognizerMetadataEntityTypesListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
